/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.Box;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TrackAirspace
extends AbstractAirspace {
    protected List<Box> legs = new ArrayList<Box>();
    protected boolean legsOutOfDate = true;
    protected boolean enableInnerCaps = true;
    protected boolean enableCenterLine;
    protected Angle smallAngleThreshold = Angle.fromDegrees(22.5);

    public TrackAirspace(Collection<Box> collection) {
        this.addLegs(collection);
    }

    public TrackAirspace(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
    }

    public TrackAirspace() {
    }

    public TrackAirspace(TrackAirspace trackAirspace) {
        super(trackAirspace);
        this.legs = new ArrayList<Box>(trackAirspace.legs.size());
        for (Box box : trackAirspace.legs) {
            this.legs.add(new Box(box));
        }
        this.enableInnerCaps = trackAirspace.enableInnerCaps;
        this.enableCenterLine = trackAirspace.enableInnerCaps;
        this.smallAngleThreshold = trackAirspace.smallAngleThreshold;
    }

    public List<Box> getLegs() {
        return Collections.unmodifiableList(this.legs);
    }

    public void setLegs(Collection<Box> collection) {
        this.legs.clear();
        this.addLegs(collection);
    }

    protected void addLegs(Iterable<Box> iterable) {
        if (iterable != null) {
            for (Box box : iterable) {
                if (box == null) continue;
                this.addLeg(box);
            }
        }
        this.invalidateAirspaceData();
        this.setLegsOutOfDate(true);
    }

    public Box addLeg(LatLon latLon, LatLon latLon2, double d, double d2, double d3, double d4) {
        if (latLon == null) {
            String string = "nullValue.StartIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = "nullValue.EndIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean[] blArray = this.isTerrainConforming();
        Box box = new Box();
        box.setAltitudes(d, d2);
        box.setTerrainConforming(blArray[0], blArray[1]);
        box.setLocations(latLon, latLon2);
        box.setWidths(d3, d4);
        this.addLeg(box);
        return box;
    }

    protected void addLeg(Box box) {
        if (box == null) {
            String string = "nullValue.LegIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        box.setAlwaysOnTop(this.isAlwaysOnTop());
        box.setForceCullFace(true);
        box.setEnableCenterLine(this.enableCenterLine);
        box.setDrawSurfaceShape(this.drawSurfaceShape);
        this.legs.add(box);
        this.invalidateAirspaceData();
        this.setLegsOutOfDate(true);
    }

    public void removeAllLegs() {
        this.legs.clear();
    }

    public boolean isEnableInnerCaps() {
        return this.enableInnerCaps;
    }

    public void setEnableInnerCaps(boolean bl) {
        this.enableInnerCaps = bl;
        this.invalidateAirspaceData();
        this.setLegsOutOfDate(true);
    }

    public boolean isEnableCenterLine() {
        return this.enableCenterLine;
    }

    public void setEnableCenterLine(boolean bl) {
        this.enableCenterLine = bl;
        for (Box box : this.legs) {
            box.setEnableCenterLine(bl);
        }
    }

    @Override
    public void setEnableDepthOffset(boolean bl) {
        super.setEnableDepthOffset(bl);
        this.setLegsOutOfDate(true);
    }

    public Angle getSmallAngleThreshold() {
        return this.smallAngleThreshold;
    }

    public void setSmallAngleThreshold(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.smallAngleThreshold = angle;
    }

    @Override
    public void setAltitudes(double d, double d2) {
        super.setAltitudes(d, d2);
        for (Box box : this.legs) {
            box.setAltitudes(d, d2);
        }
        this.invalidateAirspaceData();
        this.setLegsOutOfDate(true);
    }

    @Override
    public void setTerrainConforming(boolean bl, boolean bl2) {
        super.setTerrainConforming(bl, bl2);
        for (Box box : this.legs) {
            box.setTerrainConforming(bl, bl2);
        }
        this.invalidateAirspaceData();
        this.setLegsOutOfDate(true);
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        super.setAlwaysOnTop(bl);
        for (Box box : this.getLegs()) {
            box.setAlwaysOnTop(bl);
        }
    }

    @Override
    public void setDrawSurfaceShape(boolean bl) {
        super.setDrawSurfaceShape(bl);
        for (Box box : this.getLegs()) {
            box.setDrawSurfaceShape(bl);
        }
    }

    @Override
    public boolean isAirspaceVisible(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!super.isAirspaceVisible(drawContext)) {
            return false;
        }
        boolean bl = false;
        for (Box box : this.legs) {
            if (!box.isAirspaceVisible(drawContext)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public Position getReferencePosition() {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(2 * this.legs.size());
        for (Box box : this.legs) {
            LatLon[] latLonArray = box.getLocations();
            arrayList.add(latLonArray[0]);
            arrayList.add(latLonArray[1]);
        }
        return this.computeReferencePosition(arrayList, this.getAltitudes());
    }

    @Override
    protected Extent computeExtent(DrawContext drawContext) {
        if (this.isLegsOutOfDate()) {
            this.doUpdateLegs();
        }
        return super.computeExtent(drawContext);
    }

    @Override
    protected Extent computeExtent(Globe globe, double d) {
        List<Box> list = this.getLegs();
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 0) {
            return list.get(0).computeExtent(globe, d);
        }
        ArrayList<gov.nasa.worldwind.geom.Box> arrayList = new ArrayList<gov.nasa.worldwind.geom.Box>();
        for (Box box : list) {
            arrayList.add(box.computeExtent(globe, d));
        }
        return gov.nasa.worldwind.geom.Box.union(arrayList);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        return null;
    }

    @Override
    protected void invalidateAirspaceData() {
        super.invalidateAirspaceData();
        for (Box box : this.legs) {
            box.invalidateAirspaceData();
        }
    }

    @Override
    protected void doMoveTo(Globe globe, Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Box box : this.legs) {
            box.doMoveTo(globe, position, position2);
        }
        this.invalidateAirspaceData();
        this.setLegsOutOfDate(true);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Box box : this.legs) {
            box.doMoveTo(position, position2);
        }
        this.invalidateAirspaceData();
        this.setLegsOutOfDate(true);
    }

    protected boolean isLegsOutOfDate() {
        return this.legsOutOfDate;
    }

    protected void setLegsOutOfDate(boolean bl) {
        this.legsOutOfDate = bl;
    }

    protected void doUpdateLegs() {
        for (Box box : this.legs) {
            if (box == null) continue;
            box.setEnableCaps(true);
            box.setEnableDepthOffset(this.isEnableDepthOffset());
            box.setCornerAzimuths(null, null, null, null);
        }
        for (int i = 0; i < this.legs.size() - 1; ++i) {
            Box box;
            box = this.legs.get(i);
            Box box2 = this.legs.get(i + 1);
            if (box == null || box2 == null || !this.mustJoinLegs(box, box2)) continue;
            this.joinLegs(box, box2);
        }
        this.setLegsOutOfDate(false);
    }

    protected boolean mustJoinLegs(Box box, Box box2) {
        return box.getLocations()[1].equals(box2.getLocations()[0]) && Arrays.equals(box.getAltitudes(), box2.getAltitudes()) && Arrays.equals(box.isTerrainConforming(), box2.isTerrainConforming());
    }

    protected void joinLegs(Box box, Box box2) {
        boolean bl;
        LatLon[] latLonArray = box.getLocations();
        LatLon[] latLonArray2 = box2.getLocations();
        Angle[] angleArray = box.getCornerAzimuths();
        Angle[] angleArray2 = box2.getCornerAzimuths();
        Angle angle = LatLon.greatCircleAzimuth(latLonArray[1], latLonArray[0]);
        Angle angle2 = LatLon.greatCircleAzimuth(latLonArray2[0], latLonArray2[1]);
        Angle angle3 = angle.angularDistanceTo(angle2);
        Angle angle4 = angle2.subtract(angle).normalize();
        Angle angle5 = Angle.mix(0.5, angle, angle2);
        Angle angle6 = angle5.add(Angle.POS180).normalize();
        boolean bl2 = bl = angle4.compareTo(Angle.ZERO) > 0;
        if (angle3.compareTo(this.getSmallAngleThreshold()) > 0) {
            Angle angle7 = bl ? angle5 : angle6;
            Angle angle8 = bl ? angle6 : angle5;
            boolean bl3 = !Arrays.equals(box.getWidths(), box2.getWidths());
            box.setEnableEndCap(bl3 || this.isEnableInnerCaps());
            box2.setEnableStartCap(bl3 || this.isEnableInnerCaps());
            box.setCornerAzimuths(angleArray[0], angleArray[1], angle7, angle8);
            box2.setCornerAzimuths(angle7, angle8, angleArray2[2], angleArray2[3]);
        } else if (bl) {
            box.setEnableEndCap(true);
            box2.setEnableStartCap(true);
            box.setCornerAzimuths(angleArray[0], angleArray[1], angle5, angleArray[3]);
            box2.setCornerAzimuths(angle5, angleArray2[1], angleArray2[2], angleArray2[3]);
        } else {
            box.setEnableEndCap(true);
            box2.setEnableStartCap(true);
            box.setCornerAzimuths(angleArray[0], angleArray[1], angleArray[2], angle5);
            box2.setCornerAzimuths(angleArray2[0], angle5, angleArray2[2], angleArray2[3]);
        }
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        this.determineActiveAttributes(drawContext);
        if (this.isLegsOutOfDate()) {
            this.doUpdateLegs();
        }
        for (Box box : this.legs) {
            box.setAttributes(this.getActiveAttributes());
            box.setDelegateOwner(this.getDelegateOwner() != null ? this.getDelegateOwner() : this);
            box.preRender(drawContext);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.isAirspaceVisible(drawContext)) {
            return;
        }
        for (Box box : this.legs) {
            box.render(drawContext);
        }
    }

    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsBoolean(stateObject, "enableInnerCaps", this.isEnableInnerCaps());
        restorableSupport.addStateValueAsBoolean(stateObject, "enableCenterLine", this.isEnableCenterLine());
        restorableSupport.addStateValueAsDouble(stateObject, "smallAngleThresholdDegrees", this.getSmallAngleThreshold().degrees);
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "legs");
        for (Box box : this.legs) {
            RestorableSupport.StateObject stateObject3 = restorableSupport.addStateObject(stateObject2, "leg");
            box.doGetRestorableState(restorableSupport, stateObject3);
        }
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2;
        Double d;
        super.doRestoreState(restorableSupport, stateObject);
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableInnerCaps");
        if (bl != null) {
            this.setEnableInnerCaps(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableCenterLine")) != null) {
            this.setEnableCenterLine(bl);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "smallAngleThresholdDegrees")) != null) {
            this.setSmallAngleThreshold(Angle.fromDegrees(d));
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "legs")) == null) {
            return;
        }
        RestorableSupport.StateObject[] stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "leg");
        if (stateObjectArray == null || stateObjectArray.length == 0) {
            return;
        }
        ArrayList<Box> arrayList = new ArrayList<Box>(stateObjectArray.length);
        for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
            if (stateObject3 == null) continue;
            Box box = new Box();
            box.doRestoreState(restorableSupport, stateObject3);
            arrayList.add(box);
        }
        this.setLegs(arrayList);
    }
}

