/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.JarRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public abstract class URLRetriever
extends WWObjectImpl
implements Retriever {
    public static final String EXTRACT_ZIP_ENTRY = "URLRetriever.ExtractZipEntry";
    protected volatile String state = "gov.nasa.worldwind.RetrieverStatusNotStarted";
    protected volatile int contentLength = 0;
    protected AtomicInteger contentLengthRead = new AtomicInteger(0);
    protected volatile String contentType;
    protected AtomicLong expiration = new AtomicLong(0L);
    protected volatile ByteBuffer byteBuffer;
    protected volatile URLConnection connection;
    protected final URL url;
    protected final RetrievalPostProcessor postProcessor;
    protected int connectTimeout = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.URLConnectTimeout", 8000);
    protected int readTimeout = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.URLReadTimeout", 5000);
    protected int staleRequestLimit = -1;
    protected long submitTime;
    protected long beginTime;
    protected long endTime;

    public static URLRetriever createRetriever(URL uRL, RetrievalPostProcessor retrievalPostProcessor) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = uRL.getProtocol();
        if ("http".equalsIgnoreCase(string) || "https".equalsIgnoreCase(string)) {
            return new HTTPRetriever(uRL, retrievalPostProcessor);
        }
        if ("jar".equalsIgnoreCase(string)) {
            return new JarRetriever(uRL, retrievalPostProcessor);
        }
        return null;
    }

    public URLRetriever(URL uRL, RetrievalPostProcessor retrievalPostProcessor) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.url = uRL;
        this.postProcessor = retrievalPostProcessor;
    }

    public final URL getUrl() {
        return this.url;
    }

    @Override
    public final int getContentLength() {
        return this.contentLength;
    }

    protected void setContentLengthRead(int n) {
        this.contentLengthRead.set(n);
    }

    @Override
    public final int getContentLengthRead() {
        return this.contentLengthRead.get();
    }

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public long getExpirationTime() {
        return this.expiration.get();
    }

    @Override
    public final ByteBuffer getBuffer() {
        return this.byteBuffer;
    }

    @Override
    public final String getName() {
        return this.url.toString();
    }

    public final URL getURL() {
        return this.url;
    }

    @Override
    public final String getState() {
        return this.state;
    }

    protected final URLConnection getConnection() {
        return this.connection;
    }

    public final RetrievalPostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    @Override
    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    @Override
    public int getStaleRequestLimit() {
        return this.staleRequestLimit;
    }

    @Override
    public void setStaleRequestLimit(int n) {
        this.staleRequestLimit = n;
    }

    @Override
    public final void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    @Override
    public long getSubmitTime() {
        return this.submitTime;
    }

    @Override
    public void setSubmitTime(long l) {
        this.submitTime = l;
    }

    @Override
    public long getBeginTime() {
        return this.beginTime;
    }

    @Override
    public void setBeginTime(long l) {
        this.beginTime = l;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(long l) {
        this.endTime = l;
    }

    @Override
    public final Retriever call() throws Exception {
        if (this.interrupted()) {
            return this;
        }
        try {
            this.setState("gov.nasa.worldwind.RetrieverStatusStarted");
            if (!this.interrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusConnecting");
                this.connection = this.openConnection();
            }
            if (!this.interrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusReading");
                this.byteBuffer = this.read();
            }
            if (!this.interrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusSuccessful");
            }
            WorldWind.getNetworkStatus().logAvailableHost(this.url);
        }
        catch (UnknownHostException unknownHostException) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            WorldWind.getNetworkStatus().logUnavailableHost(this.url);
            throw unknownHostException;
        }
        catch (SocketException socketException) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            WorldWind.getNetworkStatus().logUnavailableHost(this.url);
            throw socketException;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.interrupted();
        }
        catch (Exception exception) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            if (!(exception instanceof SocketTimeoutException)) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("URLRetriever.ErrorAttemptingToRetrieve", this.url.toString()), exception);
            }
            throw exception;
        }
        finally {
            this.end();
        }
        return this;
    }

    protected void setState(String string) {
        String string2 = this.state;
        this.state = string;
        this.firePropertyChange("gov.nasa.worldwind.avkey.RetrieverState", string2, this.state);
    }

    protected boolean interrupted() {
        if (Thread.currentThread().isInterrupted()) {
            this.setState("gov.nasa.worldwind.RetrieverStatusInterrupted");
            String string = Logging.getMessage("URLRetriever.RetrievalInterruptedFor", this.url.toString());
            Logging.logger().fine(string);
            return true;
        }
        return false;
    }

    protected URLConnection openConnection() throws IOException {
        Object object;
        try {
            object = WWIO.configureProxy();
            this.connection = object != null ? this.url.openConnection((Proxy)object) : this.url.openConnection();
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("URLRetriever.ErrorOpeningConnection", this.url.toString()), iOException);
            throw iOException;
        }
        if (this.connection == null) {
            object = Logging.getMessage("URLRetriever.NullReturnedFromOpenConnection", this.url);
            Logging.logger().severe((String)object);
            throw new IllegalStateException((String)object);
        }
        if (this.connection instanceof HttpsURLConnection) {
            this.configureSSLContext((HttpsURLConnection)this.connection);
        }
        this.connection.setConnectTimeout(this.connectTimeout);
        this.connection.setReadTimeout(this.readTimeout);
        return this.connection;
    }

    protected void configureSSLContext(HttpsURLConnection httpsURLConnection) {
        SSLContext sSLContext = (SSLContext)WorldWind.getValue("gov.nasa.worldwind.avkey.HTTP.SSLContext");
        if (sSLContext != null) {
            httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
        }
    }

    protected void end() throws Exception {
        try {
            if (this.postProcessor != null) {
                this.byteBuffer = this.postProcessor.run(this);
            }
        }
        catch (Exception exception) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            Logging.logger().log(Level.SEVERE, Logging.getMessage("Retriever.ErrorPostProcessing", this.url.toString()), exception);
            throw exception;
        }
    }

    protected ByteBuffer read() throws Exception {
        try {
            ByteBuffer byteBuffer = this.doRead(this.connection);
            if (byteBuffer == null) {
                this.contentLength = 0;
            }
            return byteBuffer;
        }
        catch (Exception exception) {
            if (!(exception instanceof SocketTimeoutException || exception instanceof UnknownHostException || exception instanceof SocketException)) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("URLRetriever.ErrorReadingFromConnection", this.url.toString()), exception);
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer doRead(URLConnection uRLConnection) throws Exception {
        ByteBuffer byteBuffer;
        if (uRLConnection == null) {
            String string = Logging.getMessage("nullValue.ConnectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.contentLength = this.connection.getContentLength();
        InputStream inputStream = null;
        try {
            inputStream = this.connection.getInputStream();
            if (inputStream == null) {
                Logging.logger().log(Level.SEVERE, "URLRetriever.InputStreamFromConnectionNull", uRLConnection.getURL());
                ByteBuffer byteBuffer2 = null;
                return byteBuffer2;
            }
            this.expiration.set(this.getExpiration(uRLConnection));
            this.contentType = uRLConnection.getContentType();
            byteBuffer = this.contentType != null && this.contentType.equalsIgnoreCase("application/zip") && !WWUtil.isEmpty(this.getValue(EXTRACT_ZIP_ENTRY)) ? this.readZipStream(inputStream, uRLConnection.getURL()) : this.readNonSpecificStream(inputStream, uRLConnection);
        }
        finally {
            WWIO.closeStream(inputStream, uRLConnection.getURL().toString());
        }
        return byteBuffer;
    }

    protected ByteBuffer readNonSpecificStream(InputStream inputStream, URLConnection uRLConnection) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("URLRetriever.InputStreamNullFor", uRLConnection.getURL());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.contentLength < 1) {
            return this.readNonSpecificStreamUnknownLength(inputStream);
        }
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.contentLength);
        int n = 0;
        while (!this.interrupted() && n >= 0 && n < byteBuffer.limit()) {
            int n2 = readableByteChannel.read(byteBuffer);
            if (n2 > 0) {
                n += n2;
                this.contentLengthRead.getAndAdd(n2);
            }
            if (n2 >= 0) continue;
            throw new WWRuntimeException("Premature end of stream from server.");
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    protected ByteBuffer readNonSpecificStreamUnknownLength(InputStream inputStream) throws IOException {
        int n = (int)Math.ceil(Math.pow(2.0, 15.0));
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        int n2 = 0;
        int n3 = 0;
        while (!this.interrupted() && n2 >= 0) {
            n2 = readableByteChannel.read(byteBuffer);
            if (n2 > 0) {
                n3 += n2;
                this.contentLengthRead.getAndAdd(n2);
            }
            if (n2 <= 0 || byteBuffer.hasRemaining()) continue;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.limit() + n);
            byteBuffer2.put(byteBuffer.rewind());
            byteBuffer = byteBuffer2;
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    protected ByteBuffer readZipStream(InputStream inputStream, URL uRL) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null) {
            Logging.logger().severe(Logging.getMessage("URLRetriever.NoZipEntryFor") + uRL);
            return null;
        }
        ByteBuffer byteBuffer = null;
        if (zipEntry.getSize() > 0L) {
            byteBuffer = ByteBuffer.allocate((int)zipEntry.getSize());
            byte[] byArray = new byte[8192];
            while (byteBuffer.hasRemaining()) {
                int n = zipInputStream.read(byArray);
                if (n <= 0) continue;
                byteBuffer.put(byArray, 0, n);
                this.contentLengthRead.getAndAdd(byteBuffer.position() + 1);
            }
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    protected long getExpiration(URLConnection uRLConnection) {
        Long l;
        Pattern pattern;
        Matcher matcher;
        String string = uRLConnection.getHeaderField("cache-control");
        if (string != null && (matcher = (pattern = Pattern.compile("max-age=(\\d+)")).matcher(string)).find() && (l = WWUtil.makeLong(matcher.group(1))) != null) {
            return l * 1000L + System.currentTimeMillis();
        }
        long l2 = uRLConnection.getExpiration();
        long l3 = uRLConnection.getDate();
        if (l3 > 0L && l2 > l3) {
            return System.currentTimeMillis() + (l2 - l3);
        }
        return l2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        URLRetriever uRLRetriever = (URLRetriever)object;
        return !(this.url == null ? uRLRetriever.url != null : !this.url.toString().contentEquals(uRLRetriever.url.toString()));
    }

    public int hashCode() {
        int n = this.url != null ? this.url.hashCode() : 0;
        return n;
    }

    public String toString() {
        return this.getName() != null ? this.getName() : super.toString();
    }
}

