/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology;

import gov.nasa.worldwind.symbology.IconRetriever;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public abstract class AbstractIconRetriever
implements IconRetriever {
    protected String retrieverPath;

    public AbstractIconRetriever(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.retrieverPath = string;
    }

    public String getRetrieverPath() {
        return this.retrieverPath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractIconRetriever abstractIconRetriever = (AbstractIconRetriever)object;
        return this.retrieverPath != null ? this.retrieverPath.equals(abstractIconRetriever.retrieverPath) : abstractIconRetriever.retrieverPath == null;
    }

    public int hashCode() {
        return this.retrieverPath != null ? this.retrieverPath.hashCode() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage readImage(String string) {
        InputStream inputStream;
        StringBuilder stringBuilder;
        block7: {
            BufferedImage bufferedImage;
            block6: {
                if (string == null) {
                    String string2 = Logging.getMessage("nullValue.PathIsNull");
                    Logging.logger().severe(string2);
                    throw new IllegalArgumentException(string2);
                }
                stringBuilder = new StringBuilder();
                stringBuilder.append(WWIO.stripTrailingSeparator(this.getRetrieverPath()));
                stringBuilder.append("/");
                stringBuilder.append(WWIO.stripLeadingSeparator(string));
                inputStream = null;
                URL uRL = WWIO.makeURL(stringBuilder.toString());
                if (uRL == null) break block6;
                BufferedImage bufferedImage2 = ImageIO.read(uRL);
                WWIO.closeStream(inputStream, stringBuilder.toString());
                return bufferedImage2;
            }
            try {
                inputStream = WWIO.openFileOrResourceStream(stringBuilder.toString(), this.getClass());
                if (inputStream == null) break block7;
                bufferedImage = ImageIO.read(inputStream);
            }
            catch (Exception exception) {
                try {
                    String string3 = Logging.getMessage("generic.ExceptionWhileReading", stringBuilder.toString());
                    Logging.logger().fine(string3);
                }
                catch (Throwable throwable) {
                    WWIO.closeStream(inputStream, stringBuilder.toString());
                    throw throwable;
                }
                WWIO.closeStream(inputStream, stringBuilder.toString());
            }
            WWIO.closeStream(inputStream, stringBuilder.toString());
            return bufferedImage;
        }
        WWIO.closeStream(inputStream, stringBuilder.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage drawImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Graphics2D graphics2D = null;
        try {
            graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return bufferedImage2;
    }

    protected void multiply(BufferedImage bufferedImage, Color color) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n == 0 || n2 == 0) {
            return;
        }
        int[] nArray = new int[n];
        int n3 = color.getRGB();
        float f = (float)(n3 >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(n3 >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(n3 >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(n3 & 0xFF) / 255.0f;
        for (int i = 0; i < n2; ++i) {
            bufferedImage.getRGB(0, i, n, 1, nArray, 0, n);
            for (int j = 0; j < n; ++j) {
                int n4 = nArray[j];
                float f5 = (float)(n4 >> 24 & 0xFF) / 255.0f;
                float f6 = (float)(n4 >> 16 & 0xFF) / 255.0f;
                float f7 = (float)(n4 >> 8 & 0xFF) / 255.0f;
                float f8 = (float)(n4 & 0xFF) / 255.0f;
                int n5 = (int)((double)(f * f5 * 255.0f) + 0.5);
                int n6 = (int)((double)(f2 * f6 * 255.0f) + 0.5);
                int n7 = (int)((double)(f3 * f7 * 255.0f) + 0.5);
                int n8 = (int)((double)(f4 * f8 * 255.0f) + 0.5);
                nArray[j] = (n5 & 0xFF) << 24 | (n6 & 0xFF) << 16 | (n7 & 0xFF) << 8 | n8 & 0xFF;
            }
            bufferedImage.setRGB(0, i, n, 1, nArray, 0, n);
        }
    }

    protected void replaceColor(BufferedImage bufferedImage, Color color) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n == 0 || n2 == 0) {
            return;
        }
        int[] nArray = new int[n];
        int n3 = color.getRGB();
        float f = (float)(n3 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(n3 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(n3 & 0xFF) / 255.0f;
        for (int i = 0; i < n2; ++i) {
            bufferedImage.getRGB(0, i, n, 1, nArray, 0, n);
            for (int j = 0; j < n; ++j) {
                int n4 = nArray[j];
                float f4 = (float)(n4 >> 24 & 0xFF) / 255.0f;
                int n5 = (int)((double)(f4 * 255.0f) + 0.5);
                int n6 = (int)((double)(f * 255.0f) + 0.5);
                int n7 = (int)((double)(f2 * 255.0f) + 0.5);
                int n8 = (int)((double)(f3 * 255.0f) + 0.5);
                nArray[j] = (n5 & 0xFF) << 24 | (n6 & 0xFF) << 16 | (n7 & 0xFF) << 8 | n8 & 0xFF;
            }
            bufferedImage.setRGB(0, i, n, 1, nArray, 0, n);
        }
    }
}

