/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.drag.DragContext;
import gov.nasa.worldwind.drag.Draggable;
import gov.nasa.worldwind.drag.DraggableSupport;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.AbstractTacticalSymbol;
import gov.nasa.worldwind.symbology.BasicTacticalGraphicAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphic;
import gov.nasa.worldwind.symbology.TacticalGraphicAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTacticalGraphic
extends AVListImpl
implements TacticalGraphic,
Renderable,
Draggable {
    protected static final Material DEFAULT_HIGHLIGHT_MATERIAL = Material.WHITE;
    protected static final double DEFAULT_LABEL_INTERIOR_OPACITY = 0.7;
    protected String text;
    protected boolean highlighted;
    protected boolean visible = true;
    protected boolean showTextModifiers = true;
    protected boolean showGraphicModifiers = true;
    protected boolean dragEnabled = true;
    protected DraggableSupport draggableSupport = null;
    protected boolean showHostileIndicator = true;
    protected boolean showLocation = true;
    protected Object delegateOwner;
    protected UnitsFormat unitsFormat = AbstractTacticalSymbol.DEFAULT_UNITS_FORMAT;
    protected TacticalGraphicAttributes normalAttributes;
    protected TacticalGraphicAttributes highlightAttributes;
    protected Offset labelOffset;
    protected List<TacticalGraphicLabel> labels;
    protected AVList modifiers;
    protected long frameTimestamp = -1L;
    protected TacticalGraphicAttributes activeOverrides = new BasicTacticalGraphicAttributes();
    protected ShapeAttributes activeShapeAttributes = new BasicShapeAttributes();
    protected boolean mustCreateLabels = true;

    protected abstract void doRenderGraphic(DrawContext var1);

    protected abstract void applyDelegateOwner(Object var1);

    @Override
    public Object getModifier(String string) {
        return this.modifiers != null ? this.modifiers.getValue(string) : null;
    }

    @Override
    public void setModifier(String string, Object object) {
        if (this.modifiers == null) {
            this.modifiers = new AVListImpl();
        }
        this.modifiers.setValue(string, object);
        this.onModifierChanged();
    }

    @Override
    public boolean isShowTextModifiers() {
        return this.showTextModifiers;
    }

    @Override
    public void setShowTextModifiers(boolean bl) {
        this.showTextModifiers = bl;
    }

    @Override
    public boolean isShowGraphicModifiers() {
        return this.showGraphicModifiers;
    }

    @Override
    public void setShowGraphicModifiers(boolean bl) {
        this.showGraphicModifiers = bl;
    }

    @Override
    public boolean isShowHostileIndicator() {
        return this.showHostileIndicator;
    }

    @Override
    public void setShowHostileIndicator(boolean bl) {
        this.showHostileIndicator = bl;
        this.onModifierChanged();
    }

    @Override
    public boolean isShowLocation() {
        return this.showLocation;
    }

    @Override
    public void setShowLocation(boolean bl) {
        this.showLocation = bl;
        this.onModifierChanged();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String string) {
        this.text = string;
        this.onModifierChanged();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public TacticalGraphicAttributes getAttributes() {
        return this.normalAttributes;
    }

    @Override
    public void setAttributes(TacticalGraphicAttributes tacticalGraphicAttributes) {
        this.normalAttributes = tacticalGraphicAttributes;
    }

    @Override
    public TacticalGraphicAttributes getHighlightAttributes() {
        return this.highlightAttributes;
    }

    @Override
    public void setHighlightAttributes(TacticalGraphicAttributes tacticalGraphicAttributes) {
        this.highlightAttributes = tacticalGraphicAttributes;
    }

    @Override
    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    @Override
    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    @Override
    public UnitsFormat getUnitsFormat() {
        return this.unitsFormat;
    }

    @Override
    public void setUnitsFormat(UnitsFormat unitsFormat) {
        if (unitsFormat == null) {
            String string = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.unitsFormat = unitsFormat;
    }

    @Override
    public Offset getLabelOffset() {
        return this.labelOffset;
    }

    @Override
    public void setLabelOffset(Offset offset) {
        this.labelOffset = offset;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        List<Position> list = Position.computeShiftedPositions(position2, position, this.getPositions());
        if (list != null) {
            this.setPositions(list);
        }
    }

    @Override
    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    @Override
    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    @Override
    public void drag(DragContext dragContext) {
        if (!this.dragEnabled) {
            return;
        }
        if (this.draggableSupport == null) {
            this.draggableSupport = new DraggableSupport(this, 1);
        }
        this.doDrag(dragContext);
    }

    protected void doDrag(DragContext dragContext) {
        this.draggableSupport.dragGlobeSizeConstant(dragContext);
    }

    @Override
    public void render(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        this.determinePerFrameAttributes(drawContext);
        this.doRenderGraphic(drawContext);
        if (this.isShowTextModifiers()) {
            this.doRenderTextModifiers(drawContext);
        }
        if (this.isShowGraphicModifiers()) {
            this.doRenderGraphicModifiers(drawContext);
        }
    }

    protected void determinePerFrameAttributes(DrawContext drawContext) {
        long l = drawContext.getFrameTimeStamp();
        if (this.frameTimestamp != l) {
            if (this.mustCreateLabels) {
                if (this.labels != null) {
                    this.labels.clear();
                }
                this.createLabels();
                this.mustCreateLabels = false;
            }
            this.determineActiveAttributes();
            this.determineDelegateOwner();
            this.computeGeometry(drawContext);
            this.frameTimestamp = l;
        }
    }

    protected void doRenderTextModifiers(DrawContext drawContext) {
        if (this.labels == null) {
            return;
        }
        for (TacticalGraphicLabel tacticalGraphicLabel : this.labels) {
            tacticalGraphicLabel.render(drawContext);
        }
    }

    protected void doRenderGraphicModifiers(DrawContext drawContext) {
    }

    protected void onModifierChanged() {
        this.mustCreateLabels = true;
    }

    protected void determineLabelPositions(DrawContext drawContext) {
    }

    protected void createLabels() {
    }

    protected TacticalGraphicLabel addLabel(String string) {
        if (this.labels == null) {
            this.labels = new ArrayList<TacticalGraphicLabel>();
        }
        TacticalGraphicLabel tacticalGraphicLabel = new TacticalGraphicLabel();
        tacticalGraphicLabel.setText(string);
        tacticalGraphicLabel.setDelegateOwner(this.getActiveDelegateOwner());
        tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Center");
        this.labels.add(tacticalGraphicLabel);
        return tacticalGraphicLabel;
    }

    protected void computeGeometry(DrawContext drawContext) {
        this.determineLabelPositions(drawContext);
    }

    protected void determineDelegateOwner() {
        Object object = this.getActiveDelegateOwner();
        if (this.labels != null) {
            for (TacticalGraphicLabel tacticalGraphicLabel : this.labels) {
                tacticalGraphicLabel.setDelegateOwner(object);
            }
        }
        this.applyDelegateOwner(object);
    }

    protected Object getActiveDelegateOwner() {
        Object object = this.getDelegateOwner();
        return object != null ? object : this;
    }

    protected void determineActiveAttributes() {
        this.applyDefaultAttributes(this.activeShapeAttributes);
        if (this.isHighlighted()) {
            TacticalGraphicAttributes tacticalGraphicAttributes = this.getHighlightAttributes();
            if (tacticalGraphicAttributes != null) {
                this.activeOverrides.copy(tacticalGraphicAttributes);
                this.applyOverrideAttributes(tacticalGraphicAttributes, this.activeShapeAttributes);
            } else {
                this.activeShapeAttributes.setOutlineMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
                this.activeShapeAttributes.setInteriorMaterial(DEFAULT_HIGHLIGHT_MATERIAL);
                this.activeShapeAttributes.setInteriorOpacity(1.0);
                this.activeShapeAttributes.setOutlineOpacity(1.0);
            }
        } else {
            TacticalGraphicAttributes tacticalGraphicAttributes = this.getAttributes();
            if (tacticalGraphicAttributes != null) {
                this.activeOverrides.copy(tacticalGraphicAttributes);
                this.applyOverrideAttributes(tacticalGraphicAttributes, this.activeShapeAttributes);
            }
        }
        this.applyLabelAttributes();
    }

    protected void applyLabelAttributes() {
        if (WWUtil.isEmpty(this.labels)) {
            return;
        }
        Material material = this.getLabelMaterial();
        Font font = this.activeOverrides.getTextModifierFont();
        if (font == null) {
            font = TacticalGraphicLabel.DEFAULT_FONT;
        }
        double d = this.getActiveShapeAttributes().getInteriorOpacity();
        double d2 = this.computeLabelInteriorOpacity(d);
        for (TacticalGraphicLabel tacticalGraphicLabel : this.labels) {
            tacticalGraphicLabel.setMaterial(material);
            tacticalGraphicLabel.setFont(font);
            tacticalGraphicLabel.setOpacity(d);
            tacticalGraphicLabel.setInteriorOpacity(d2);
        }
        Object object = this.getLabelOffset();
        if (object == null) {
            object = this.getDefaultLabelOffset();
        }
        this.labels.get(0).setOffset((Offset)object);
    }

    protected double computeLabelInteriorOpacity(double d) {
        return d * 0.7;
    }

    protected Offset getDefaultLabelOffset() {
        return TacticalGraphicLabel.DEFAULT_OFFSET;
    }

    protected TacticalGraphicAttributes getActiveOverrideAttributes() {
        return this.activeOverrides;
    }

    protected ShapeAttributes getActiveShapeAttributes() {
        return this.activeShapeAttributes;
    }

    protected Material getLabelMaterial() {
        Material material = this.activeOverrides.getTextModifierMaterial();
        if (material != null) {
            return material;
        }
        return this.activeShapeAttributes.getOutlineMaterial();
    }

    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
    }

    protected void applyOverrideAttributes(TacticalGraphicAttributes tacticalGraphicAttributes, ShapeAttributes shapeAttributes) {
        Double d;
        Material material = tacticalGraphicAttributes.getInteriorMaterial();
        if (material != null) {
            shapeAttributes.setInteriorMaterial(material);
        }
        if ((material = tacticalGraphicAttributes.getOutlineMaterial()) != null) {
            shapeAttributes.setOutlineMaterial(material);
        }
        if ((d = tacticalGraphicAttributes.getInteriorOpacity()) != null) {
            shapeAttributes.setInteriorOpacity(d);
        }
        if ((d = tacticalGraphicAttributes.getOutlineOpacity()) != null) {
            shapeAttributes.setOutlineOpacity(d);
        }
        if ((d = tacticalGraphicAttributes.getOutlineWidth()) != null) {
            shapeAttributes.setOutlineWidth(d);
        }
    }
}

