/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.AbstractTacticalSymbol;
import gov.nasa.worldwind.symbology.SymbologyConstants;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525IconRetriever;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525ModifierRetriever;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525UnitsFormat;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525Util;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.UnitsFormat;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MilStd2525TacticalSymbol
extends AbstractTacticalSymbol {
    public static final UnitsFormat DEFAULT_UNITS_FORMAT = new MilStd2525UnitsFormat();
    protected static final Font DEFAULT_FRAME_SHAPE_FONT = Font.decode("Arial-BOLD-24");
    protected static final Map<String, String> symbolEchelonMap = new HashMap<String, String>();
    protected static final Set<String> exerciseSymbols = new HashSet<String>();
    protected SymbolCode symbolCode;
    protected boolean isGroundSymbol;
    protected boolean useGroundHeadingIndicator;

    public MilStd2525TacticalSymbol(String string, Position position) {
        super(position);
        this.init(string, null);
    }

    public MilStd2525TacticalSymbol(String string, Position position, AVList aVList) {
        super(position);
        this.init(string, aVList);
    }

    protected void init(String string, AVList aVList) {
        this.symbolCode = new SymbolCode(string);
        SymbolCode.parseSymbolModifierCode(this.symbolCode.getSymbolModifier(), this.modifiers);
        if (aVList != null) {
            this.modifiers.setValues(aVList);
        }
        String string2 = Configuration.getStringValue("gov.nasa.worldwind.avkey.MilStd2525IconRetrieverPath", "https://worldwind.arc.nasa.gov/milstd2525c/rev1/");
        this.setIconRetriever(new MilStd2525IconRetriever(string2));
        this.setModifierRetriever(new MilStd2525ModifierRetriever(string2));
        this.setShowHostileIndicator(false);
        this.initIconLayout();
        this.setUnitsFormat(DEFAULT_UNITS_FORMAT);
    }

    @Override
    public String getIdentifier() {
        return this.symbolCode.toString();
    }

    public String getStatus() {
        return this.symbolCode.getStatus();
    }

    public void setStatus(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!SymbologyConstants.STATUS_ALL.contains(string.toUpperCase())) {
            String string3 = Logging.getMessage("Symbology.InvalidStatus", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.symbolCode.setStatus(string);
    }

    public boolean isShowFrame() {
        Object object = this.modifiers.getValue("gov.nasa.worldwind.symbology.ShowFrame");
        return object == null || object.equals(Boolean.TRUE);
    }

    public void setShowFrame(boolean bl) {
        this.modifiers.setValue("gov.nasa.worldwind.symbology.ShowFrame", bl);
    }

    public boolean isShowFill() {
        Object object = this.modifiers.getValue("gov.nasa.worldwind.symbology.ShowFill");
        return object == null || object.equals(Boolean.TRUE);
    }

    public void setShowFill(boolean bl) {
        this.modifiers.setValue("gov.nasa.worldwind.symbology.ShowFill", bl);
    }

    public boolean isShowIcon() {
        Object object = this.modifiers.getValue("gov.nasa.worldwind.symbology.ShowIcon");
        return object == null || object.equals(Boolean.TRUE);
    }

    public void setShowIcon(boolean bl) {
        this.modifiers.setValue("gov.nasa.worldwind.symbology.ShowIcon", bl);
    }

    protected void initIconLayout() {
        MilStd2525Util.SymbolInfo symbolInfo = MilStd2525Util.computeTacticalSymbolInfo(this.getIdentifier());
        if (symbolInfo == null) {
            return;
        }
        this.iconOffset = symbolInfo.iconOffset;
        this.iconSize = symbolInfo.iconSize;
        if (symbolInfo.offset != null) {
            this.setOffset(symbolInfo.offset);
        }
        if (symbolInfo.isGroundSymbol) {
            this.isGroundSymbol = true;
            this.useGroundHeadingIndicator = symbolInfo.offset == null;
            this.setAltitudeMode(1);
        }
    }

    @Override
    protected AVList assembleIconRetrieverParameters(AVList aVList) {
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        super.assembleIconRetrieverParameters(aVList);
        Object object = this.modifiers.getValue("gov.nasa.worldwind.symbology.ShowFill");
        if (object != null) {
            aVList.setValue("gov.nasa.worldwind.symbology.ShowFill", object);
        }
        if ((object = this.modifiers.getValue("gov.nasa.worldwind.symbology.ShowFrame")) != null) {
            aVList.setValue("gov.nasa.worldwind.symbology.ShowFrame", object);
        }
        if ((object = this.modifiers.getValue("gov.nasa.worldwind.symbology.ShowIcon")) != null) {
            aVList.setValue("gov.nasa.worldwind.symbology.ShowIcon", object);
        }
        return aVList;
    }

    @Override
    protected void applyImplicitModifiers(AVList aVList) {
        boolean bl;
        String string;
        String string2 = this.symbolCode.toMaskedString().toLowerCase();
        String string3 = this.symbolCode.getStandardIdentity();
        if (!aVList.hasKey("B") && (string = symbolEchelonMap.get(string2)) != null) {
            aVList.setValue("B", string);
        }
        if (!aVList.hasKey("E")) {
            if (exerciseSymbols.contains(string2)) {
                aVList.setValue("E", "X");
            } else if (string3 != null && (string3.equalsIgnoreCase("G") || string3.equalsIgnoreCase("W") || string3.equalsIgnoreCase("D") || string3.equalsIgnoreCase("L") || string3.equalsIgnoreCase("M"))) {
                aVList.setValue("E", "X");
            } else if (string3 != null && string3.equalsIgnoreCase("J")) {
                aVList.setValue("E", "J");
            } else if (string3 != null && string3.equalsIgnoreCase("K")) {
                aVList.setValue("E", "K");
            }
        }
        boolean bl2 = bl = "H".equalsIgnoreCase(string3) || "S".equalsIgnoreCase(string3) || "J".equalsIgnoreCase(string3) || "K".equalsIgnoreCase(string3);
        if (!aVList.hasKey("ENY") && this.isShowHostileIndicator() && bl) {
            aVList.setValue("ENY", "ENY");
        }
        if (!aVList.hasKey("Y") && this.isShowLocation()) {
            aVList.setValue("Y", this.getFormattedPosition());
        }
        if (!aVList.hasKey("X") && this.isShowLocation()) {
            Position position = this.getPosition();
            UnitsFormat unitsFormat = this.getUnitsFormat();
            int n = this.getAltitudeMode();
            Object object = n == 1 ? "GL" : (n == 2 ? unitsFormat.eyeAltitude(position.getElevation()) + " AGL" : unitsFormat.eyeAltitude(position.getElevation()) + " AMSL");
            aVList.setValue("X", object);
        }
    }

    @Override
    protected void layoutGraphicModifiers(DrawContext drawContext, AVList aVList, AbstractTacticalSymbol.OrderedSymbol orderedSymbol) {
        this.currentGlyphs.clear();
        this.currentLines.clear();
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Width", this.iconRect.width);
        String string = this.getModifierCode(aVList, "AB");
        if (string != null) {
            this.addGlyph(drawContext, Offset.TOP_CENTER, Offset.BOTTOM_CENTER, string, aVListImpl, null, orderedSymbol);
        }
        if ((string = this.getModifierCode(aVList, "AC")) != null) {
            this.addGlyph(drawContext, Offset.TOP_CENTER, Offset.BOTTOM_CENTER, string, null, "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative", orderedSymbol);
        }
        if ((string = this.getModifierCode(aVList, "D")) != null) {
            this.addGlyph(drawContext, Offset.TOP_CENTER, Offset.BOTTOM_CENTER, string, null, "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative", orderedSymbol);
        } else {
            string = this.getModifierCode(aVList, "B");
            if (string != null) {
                this.addGlyph(drawContext, Offset.TOP_CENTER, Offset.BOTTOM_CENTER, string, null, "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative", orderedSymbol);
            }
        }
        string = this.getModifierCode(aVList, "R");
        if (string != null) {
            this.addGlyph(drawContext, Offset.BOTTOM_CENTER, Offset.TOP_CENTER, string, null, "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative", orderedSymbol);
        }
        if ((string = this.getModifierCode(aVList, "AG")) != null) {
            this.addGlyph(drawContext, Offset.BOTTOM_CENTER, Offset.TOP_CENTER, string, null, "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative", orderedSymbol);
        }
        if (this.mustUseAlternateOperationalCondition(aVList)) {
            string = this.getModifierCode(aVList, "gov.nasa.worldwind.symbology.OperationalConditionAlternate");
            if (string != null) {
                this.addGlyph(drawContext, Offset.BOTTOM_CENTER, Offset.TOP_CENTER, string, aVListImpl, "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative", orderedSymbol);
            }
        } else {
            string = this.getModifierCode(aVList, "gov.nasa.worldwind.symbology.OperationalCondition");
            if (string != null) {
                this.addGlyph(drawContext, Offset.CENTER, Offset.CENTER, string, null, null, orderedSymbol);
            }
        }
    }

    protected boolean mustUseAlternateOperationalCondition(AVList aVList) {
        return "E".equalsIgnoreCase(this.symbolCode.getScheme()) || aVList.hasKey("gov.nasa.worldwind.symbology.OperationalConditionAlternate");
    }

    @Override
    protected void layoutDynamicModifiers(DrawContext drawContext, AVList aVList, AbstractTacticalSymbol.OrderedSymbol orderedSymbol) {
        this.currentLines.clear();
        if (!this.isShowGraphicModifiers()) {
            return;
        }
        Object object = this.getModifier("Q");
        if (object != null && object instanceof Angle) {
            double d = this.iconRect.getHeight();
            Object object2 = this.getModifier("AJ");
            if (object2 != null && object2 instanceof Number) {
                d *= ((Number)object2).doubleValue();
            }
            if (this.useGroundHeadingIndicator) {
                List<? extends Point2D> list = MilStd2525Util.computeGroundHeadingIndicatorPoints(drawContext, orderedSymbol.placePoint, (Angle)object, d, this.iconRect.getHeight());
                this.addLine(drawContext, Offset.BOTTOM_CENTER, list, "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative", list.size() - 1, orderedSymbol);
            } else {
                List<? extends Point2D> list = MilStd2525Util.computeCenterHeadingIndicatorPoints(drawContext, orderedSymbol.placePoint, (Angle)object, d);
                this.addLine(drawContext, Offset.CENTER, list, null, 0, orderedSymbol);
            }
        }
    }

    @Override
    protected void layoutTextModifiers(DrawContext drawContext, AVList aVList, AbstractTacticalSymbol.OrderedSymbol orderedSymbol) {
        this.currentLabels.clear();
        StringBuilder stringBuilder = new StringBuilder();
        Font font = this.getActiveAttributes().getTextModifierFont();
        Font font2 = this.getActiveAttributes().getTextModifierFont();
        if (font2 == null) {
            font2 = DEFAULT_FRAME_SHAPE_FONT;
        }
        this.appendTextModifier(stringBuilder, aVList, "C", 9);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.TOP_CENTER, Offset.BOTTOM_CENTER, stringBuilder.toString(), font, null, "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative", orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "AA", 9);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.CENTER, Offset.CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "E", null);
        String string = this.getReinforcedReducedModifier(aVList, "F");
        if (string != null) {
            stringBuilder.append(stringBuilder.length() > 0 ? " " : "").append(string);
        }
        if (stringBuilder.length() > 0) {
            Offset offset = Offset.fromFraction(1.0, 1.1);
            this.addLabel(drawContext, offset, Offset.LEFT_CENTER, stringBuilder.toString(), font2, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "G", 20);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.fromFraction(1.0, 0.8), Offset.LEFT_CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "H", 20);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.fromFraction(1.0, 0.5), Offset.LEFT_CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "M", 21);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.fromFraction(1.0, 0.2), Offset.LEFT_CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "J", 2);
        this.appendTextModifier(stringBuilder, aVList, "K", 3);
        this.appendTextModifier(stringBuilder, aVList, "L", 1);
        this.appendTextModifier(stringBuilder, aVList, "ENY", 3);
        this.appendTextModifier(stringBuilder, aVList, "P", 5);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.fromFraction(1.0, -0.1), Offset.LEFT_CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "W", 16);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.fromFraction(0.0, 1.1), Offset.RIGHT_CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "X", 14);
        this.appendTextModifier(stringBuilder, aVList, "Y", 19);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.fromFraction(0.0, 0.8), Offset.RIGHT_CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "V", 24);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.fromFraction(0.0, 0.5), Offset.RIGHT_CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "T", 21);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.fromFraction(0.0, 0.2), Offset.RIGHT_CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
        this.appendTextModifier(stringBuilder, aVList, "Z", 8);
        if (stringBuilder.length() > 0) {
            this.addLabel(drawContext, Offset.fromFraction(0.0, -0.1), Offset.RIGHT_CENTER, stringBuilder.toString(), font, null, null, orderedSymbol);
            stringBuilder.delete(0, stringBuilder.length());
        }
    }

    @Override
    protected int getMaxLabelLines(AVList aVList) {
        int n = 0;
        if (aVList.hasKey("W")) {
            ++n;
        }
        if (aVList.hasKey("X") || aVList.hasKey("Y")) {
            ++n;
        }
        if (aVList.hasKey("V")) {
            ++n;
        }
        if (aVList.hasKey("T")) {
            ++n;
        }
        if (aVList.hasKey("Z")) {
            ++n;
        }
        int n2 = 0;
        if (aVList.hasKey("E") || aVList.hasKey("F")) {
            ++n2;
        }
        if (aVList.hasKey("G")) {
            ++n2;
        }
        if (aVList.hasKey("H")) {
            ++n2;
        }
        if (aVList.hasKey("M")) {
            ++n2;
        }
        if (aVList.hasKey("K") || aVList.hasKey("L") || aVList.hasKey("ENY") || aVList.hasKey("P")) {
            ++n2;
        }
        return Math.max(n, n2);
    }

    protected String getModifierCode(AVList aVList, String string) {
        return SymbolCode.composeSymbolModifierCode(this.symbolCode, aVList, string);
    }

    protected String getReinforcedReducedModifier(AVList aVList, String string) {
        Object object = aVList.getValue(string);
        if (object != null && object.toString().equalsIgnoreCase("R")) {
            return "+";
        }
        if (object != null && object.toString().equalsIgnoreCase("D")) {
            return "-";
        }
        if (object != null && object.toString().equalsIgnoreCase("RD")) {
            return "+-";
        }
        return null;
    }

    protected void appendTextModifier(StringBuilder stringBuilder, AVList aVList, String string, Integer n) {
        int n2;
        Object object = aVList.getValue(string);
        if (WWUtil.isEmpty(object)) {
            return;
        }
        String string2 = object.toString();
        int n3 = n2 = n != null && n < string2.length() ? n.intValue() : string2.length();
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string2, 0, n2);
    }

    @Override
    protected void computeTransform(DrawContext drawContext, AbstractTacticalSymbol.OrderedSymbol orderedSymbol) {
        super.computeTransform(drawContext, orderedSymbol);
        if (this.getOffset() == null && this.iconRect != null && orderedSymbol.layoutRect != null && this.isGroundSymbol) {
            orderedSymbol.dx = -this.iconRect.getCenterX();
            orderedSymbol.dy = -orderedSymbol.layoutRect.getMinY();
        } else if (this.getOffset() == null && this.iconRect != null) {
            orderedSymbol.dx = -this.iconRect.getCenterX();
            orderedSymbol.dy = -this.iconRect.getCenterY();
        }
    }

    static {
        symbolEchelonMap.put("e-o-bj---------", "A");
        exerciseSymbols.add("s-u-wmgx-------");
        exerciseSymbols.add("s-u-wmmx-------");
        exerciseSymbols.add("s-u-wmfx-------");
        exerciseSymbols.add("s-u-wmx--------");
        exerciseSymbols.add("s-u-wmsx-------");
    }
}

