/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.SurfaceCircle;
import gov.nasa.worldwind.symbology.TacticalCircle;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;
import java.util.Iterator;

public abstract class AbstractCircularGraphic
extends AbstractMilStd2525TacticalGraphic
implements TacticalCircle,
PreRenderable {
    protected SurfaceCircle circle = this.createShape();

    public AbstractCircularGraphic(String string) {
        super(string);
    }

    @Override
    public double getRadius() {
        return this.circle.getRadius();
    }

    @Override
    public void setRadius(double d) {
        this.circle.setRadius(d);
        this.onModifierChanged();
        this.reset();
    }

    @Override
    public Position getPosition() {
        return this.getReferencePosition();
    }

    @Override
    public void setPosition(Position position) {
        this.moveTo(position);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.circle.setCenter(iterator.next());
        this.reset();
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("AM".equals(string) && object instanceof Double) {
            this.setRadius((Double)object);
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public Object getModifier(String string) {
        if ("AM".equals(string)) {
            return this.getRadius();
        }
        return super.getModifier(string);
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(new Position(this.circle.getCenter(), 0.0));
    }

    @Override
    public Position getReferencePosition() {
        return this.circle.getReferencePosition();
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        this.determineActiveAttributes();
        this.circle.preRender(drawContext);
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        this.circle.render(drawContext);
    }

    protected void reset() {
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        Object object = this.getDelegateOwner();
        if (object == null) {
            object = this;
        }
        this.circle.setDelegateOwner(object);
        if (this.labels != null) {
            for (TacticalGraphicLabel tacticalGraphicLabel : this.labels) {
                tacticalGraphicLabel.setDelegateOwner(object);
            }
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        this.circle.setDelegateOwner(object);
    }

    protected SurfaceCircle createShape() {
        SurfaceCircle surfaceCircle = new SurfaceCircle();
        surfaceCircle.setDelegateOwner(this.getActiveDelegateOwner());
        surfaceCircle.setAttributes(this.activeShapeAttributes);
        return surfaceCircle;
    }
}

