/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BasicArea;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AirfieldZone
extends BasicArea {
    protected List<Path> airfieldPaths;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-GAZ--------");
    }

    public AirfieldZone(String string) {
        super(string);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        super.setPositions(iterable);
        this.airfieldPaths = null;
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        super.doRenderGraphic(drawContext);
        for (Path path : this.airfieldPaths) {
            path.render(drawContext);
        }
    }

    @Override
    protected String createLabelText() {
        return "";
    }

    @Override
    protected void makeShapes(DrawContext drawContext) {
        if (this.airfieldPaths == null) {
            this.airfieldPaths = this.createAirfieldPaths(drawContext);
        }
    }

    protected List<Path> createAirfieldPaths(DrawContext drawContext) {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        List<Sector> list = this.polygon.getSectors(drawContext);
        if (list == null) {
            return Collections.emptyList();
        }
        Sector sector = list.get(0);
        LatLon latLon = sector.getCentroid();
        Angle angle = sector.getDeltaLon().divide(6.0);
        LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, Angle.POS90, angle);
        LatLon latLon3 = LatLon.greatCircleEndPosition(latLon, Angle.NEG90, angle);
        Path path = new Path(new Position(latLon2, 0.0), new Position(latLon3, 0.0));
        this.configurePath(path);
        arrayList.add(path);
        latLon2 = LatLon.greatCircleEndPosition(latLon, Angle.fromDegrees(50.0), angle);
        latLon3 = LatLon.greatCircleEndPosition(latLon, Angle.fromDegrees(-130.0), angle);
        path = new Path(new Position(latLon2, 0.0), new Position(latLon3, 0.0));
        this.configurePath(path);
        arrayList.add(path);
        return arrayList;
    }

    protected void configurePath(Path path) {
        path.setDelegateOwner(this);
        path.setFollowTerrain(true);
        path.setAltitudeMode(1);
        path.setAttributes(this.activeShapeAttributes);
    }
}

