/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BasicArea;
import java.util.Arrays;
import java.util.List;

public class AviationZone
extends BasicArea {
    protected static final Offset LABEL_OFFSET = new Offset(-0.5, -0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-AAR--------", "G-G-AAF--------", "G-G-AAH--------", "G-G-AAM--------", "G-G-AAML-------", "G-G-AAMH-------");
    }

    public AviationZone(String string) {
        super(string);
        this.setShowHostileIndicator(false);
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        return LABEL_OFFSET;
    }

    @Override
    protected String getLabelAlignment() {
        return "gov.nasa.worldwind.avkey.Left";
    }

    @Override
    protected String createLabelText() {
        return this.doCreateLabelText(true);
    }

    protected String doCreateLabelText(boolean bl) {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getGraphicLabel());
        stringBuilder.append("\n");
        Object object = this.getModifier("T");
        if (object != null) {
            stringBuilder.append(object);
            stringBuilder.append("\n");
        }
        if (bl) {
            objectArray = TacticalGraphicUtil.getAltitudeRange(this);
            if (objectArray[0] != null) {
                stringBuilder.append("MIN ALT: ");
                stringBuilder.append(objectArray[0]);
                stringBuilder.append("\n");
            }
            if (objectArray[1] != null) {
                stringBuilder.append("MAX ALT: ");
                stringBuilder.append(objectArray[1]);
                stringBuilder.append("\n");
            }
        }
        if ((objectArray = TacticalGraphicUtil.getDateRange(this))[0] != null) {
            stringBuilder.append("TIME FROM: ");
            stringBuilder.append(objectArray[0]);
            stringBuilder.append("\n");
        }
        if (objectArray[1] != null) {
            stringBuilder.append("TIME TO: ");
            stringBuilder.append(objectArray[1]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getGraphicLabel() {
        String string = this.maskedSymbolCode;
        if ("G-G-AAR--------".equalsIgnoreCase(string)) {
            return "ROZ";
        }
        if ("G-G-AAF--------".equalsIgnoreCase(string)) {
            return "SHORADEZ";
        }
        if ("G-G-AAH--------".equalsIgnoreCase(string)) {
            return "HIDACZ";
        }
        if ("G-G-AAM--------".equalsIgnoreCase(string)) {
            return "MEZ";
        }
        if ("G-G-AAML-------".equalsIgnoreCase(string)) {
            return "LOMEZ";
        }
        if ("G-G-AAMH-------".equalsIgnoreCase(string)) {
            return "HIMEZ";
        }
        return "";
    }
}

