/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.symbology.TacticalGraphic;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.CircularFireSupportArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.IrregularFireSupportArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.RectangularFireSupportArea;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;

public class FireSupportTextBuilder {
    public String[] createText(TacticalGraphic tacticalGraphic) {
        String[] stringArray;
        if (tacticalGraphic == null) {
            String string = Logging.getMessage("nullValue.GraphicIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        SymbolCode symbolCode = new SymbolCode(tacticalGraphic.getIdentifier());
        String string = symbolCode.toMaskedString();
        if ("G-F-ATC--------".equalsIgnoreCase(string)) {
            stringArray = new String[]{tacticalGraphic.getText()};
        } else if ("G-F-ATB--------".equalsIgnoreCase(string)) {
            stringArray = new String[]{"BOMB"};
        } else if ("G-F-ACT--------".equalsIgnoreCase(string)) {
            stringArray = new String[]{"TGMF"};
        } else {
            String string2;
            boolean bl = this.isShowSeparateTimeLabel(string);
            if (this.isAirspaceCoordinationArea(string)) {
                string2 = this.createAirspaceCoordinationText(tacticalGraphic);
            } else {
                boolean bl2 = !bl;
                boolean bl3 = this.isShowAltitude(string);
                string2 = this.createMainText(tacticalGraphic, string, bl2, bl3);
            }
            if (bl) {
                String string3 = this.createTimeRangeText(tacticalGraphic);
                stringArray = new String[]{string2, string3};
            } else {
                stringArray = new String[]{string2};
            }
        }
        return stringArray;
    }

    protected boolean isShowSeparateTimeLabel(String string) {
        return CircularFireSupportArea.getGraphicsWithTimeLabel().contains(string) || RectangularFireSupportArea.getGraphicsWithTimeLabel().contains(string) || IrregularFireSupportArea.getGraphicsWithTimeLabel().contains(string);
    }

    protected boolean isShowAltitude(String string) {
        return "G-F-AKPR-------".equalsIgnoreCase(string) || "G-F-AKPC-------".equalsIgnoreCase(string) || "G-F-AKPI-------".equalsIgnoreCase(string);
    }

    protected boolean isAirspaceCoordinationArea(String string) {
        return "G-F-ACAI-------".equalsIgnoreCase(string) || "G-F-ACAR-------".equalsIgnoreCase(string) || "G-F-ACAC-------".equalsIgnoreCase(string);
    }

    protected String createMainText(TacticalGraphic tacticalGraphic, String string, boolean bl, boolean bl2) {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getGraphicLabel(string)).append("\n");
        String string2 = tacticalGraphic.getText();
        if (!WWUtil.isEmpty(string2)) {
            stringBuilder.append(string2).append("\n");
        }
        if (bl) {
            objectArray = TacticalGraphicUtil.getDateRange(tacticalGraphic);
            if (objectArray[0] != null) {
                stringBuilder.append(objectArray[0]);
                stringBuilder.append("-");
            }
            if (objectArray[1] != null) {
                stringBuilder.append(objectArray[1]);
            }
        }
        if (bl2 && (objectArray = TacticalGraphicUtil.getAltitudeRange(tacticalGraphic))[0] != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(objectArray[0]);
        }
        return stringBuilder.toString();
    }

    protected String createTimeRangeText(TacticalGraphic tacticalGraphic) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = TacticalGraphicUtil.getDateRange(tacticalGraphic);
        if (objectArray[0] != null) {
            stringBuilder.append(objectArray[0]);
            stringBuilder.append("-\n");
        }
        if (objectArray[1] != null) {
            stringBuilder.append(objectArray[1]);
        }
        return stringBuilder.toString();
    }

    protected String getGraphicLabel(String string) {
        if ("G-F-ACFR-------".equalsIgnoreCase(string) || "G-F-ACFC-------".equalsIgnoreCase(string) || "G-F-ACFI-------".equalsIgnoreCase(string)) {
            return "FFA";
        }
        if ("G-F-ACRR-------".equalsIgnoreCase(string) || "G-F-ACRC-------".equalsIgnoreCase(string) || "G-F-ACRI-------".equalsIgnoreCase(string)) {
            return "RFA";
        }
        if ("G-F-ACSR-------".equalsIgnoreCase(string) || "G-F-ACSC-------".equalsIgnoreCase(string) || "G-F-ACSI-------".equalsIgnoreCase(string)) {
            return "FSA";
        }
        if ("G-F-ACER-------".equalsIgnoreCase(string) || "G-F-ACEC-------".equalsIgnoreCase(string) || "G-F-ACEI-------".equalsIgnoreCase(string)) {
            return "SENSOR\nZONE";
        }
        if ("G-F-ACDR-------".equalsIgnoreCase(string) || "G-F-ACDC-------".equalsIgnoreCase(string) || "G-F-ACDI-------".equalsIgnoreCase(string)) {
            return "DA";
        }
        if ("G-F-ACZR-------".equalsIgnoreCase(string) || "G-F-ACZC-------".equalsIgnoreCase(string) || "G-F-ACDI-------".equalsIgnoreCase(string)) {
            return "ZOR";
        }
        if ("G-F-ACBR-------".equalsIgnoreCase(string) || "G-F-ACBC-------".equalsIgnoreCase(string) || "G-F-ACBI-------".equalsIgnoreCase(string)) {
            return "TBA";
        }
        if ("G-F-ACVR-------".equalsIgnoreCase(string) || "G-F-ACVC-------".equalsIgnoreCase(string) || "G-F-ACVI-------".equalsIgnoreCase(string)) {
            return "TVAR";
        }
        if ("G-F-AZIR-------".equalsIgnoreCase(string) || "G-F-AZII-------".equalsIgnoreCase(string)) {
            return "ATI ZONE";
        }
        if ("G-F-AZXR-------".equalsIgnoreCase(string) || "G-F-AZXI-------".equalsIgnoreCase(string)) {
            return "CFF ZONE";
        }
        if ("G-F-AZCR-------".equalsIgnoreCase(string) || "G-F-AZCI-------".equalsIgnoreCase(string)) {
            return "CENSOR ZONE";
        }
        if ("G-F-AZFR-------".equalsIgnoreCase(string) || "G-F-AZFI-------".equalsIgnoreCase(string)) {
            return "CF ZONE";
        }
        if ("G-F-ACNR-------".equalsIgnoreCase(string) || "G-F-ACNC-------".equalsIgnoreCase(string) || "G-F-ACNI-------".equalsIgnoreCase(string)) {
            return "NFA";
        }
        if ("G-F-AKBR-------".equalsIgnoreCase(string) || "G-F-AKBC-------".equalsIgnoreCase(string) || "G-F-AKBI-------".equalsIgnoreCase(string)) {
            return "BKB";
        }
        if ("G-F-AKPR-------".equalsIgnoreCase(string) || "G-F-AKPC-------".equalsIgnoreCase(string) || "G-F-AKPI-------".equalsIgnoreCase(string)) {
            return "PKB";
        }
        return "";
    }

    protected String createAirspaceCoordinationText(TacticalGraphic tacticalGraphic) {
        Object[] objectArray;
        Object[] objectArray2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ACA\n");
        Object object = tacticalGraphic.getText();
        if (object != null) {
            stringBuilder.append(object);
            stringBuilder.append("\n");
        }
        if ((objectArray2 = TacticalGraphicUtil.getAltitudeRange(tacticalGraphic))[0] != null) {
            stringBuilder.append("MIN ALT: ");
            stringBuilder.append(objectArray2[0]);
            stringBuilder.append("\n");
        }
        if (objectArray2[1] != null) {
            stringBuilder.append("MAX ALT: ");
            stringBuilder.append(objectArray2[1]);
            stringBuilder.append("\n");
        }
        if ((object = tacticalGraphic.getModifier("H")) != null) {
            stringBuilder.append("Grids: ");
            stringBuilder.append(object);
            stringBuilder.append("\n");
        }
        if ((objectArray = TacticalGraphicUtil.getDateRange(tacticalGraphic))[0] != null) {
            stringBuilder.append("EFF: ");
            stringBuilder.append(objectArray[0]);
            stringBuilder.append("\n");
        }
        if (objectArray[1] != null) {
            stringBuilder.append("     ");
            stringBuilder.append(objectArray[1]);
        }
        return stringBuilder.toString();
    }
}

