/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.AbstractAxisArrow;
import gov.nasa.worldwind.util.WWUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class AdvanceForFeint
extends AbstractAxisArrow {
    protected static final double DASHED_LINE_DISTANCE = 0.2;
    protected ShapeAttributes dashedAttributes = new BasicShapeAttributes();

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-PA---------");
    }

    public AdvanceForFeint(String string) {
        super(string, 2);
        this.paths[1].setAttributes(this.dashedAttributes);
    }

    @Override
    protected double createArrowHeadPositions(List<Position> list, List<Position> list2, List<Position> list3, Globe globe) {
        double d = super.createArrowHeadPositions(list, list2, list3, globe);
        if (list3 == null || list3.size() != 3) {
            throw new IllegalStateException();
        }
        Iterator iterator = this.positions.iterator();
        Position position = (Position)iterator.next();
        Position position2 = (Position)iterator.next();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computePointFromPosition(position2);
        Vec4 vec43 = globe.computePointFromPosition(list3.get(0));
        Vec4 vec44 = globe.computePointFromPosition(list3.get(2));
        Vec4 vec45 = vec43.subtract3(vec44).multiply3(0.2);
        vec43 = vec43.add3(vec45);
        vec44 = vec44.subtract3(vec45);
        vec45 = vec4.subtract3(vec43).multiply3(0.2);
        vec43 = vec43.add3(vec45);
        vec45 = vec4.subtract3(vec44).multiply3(0.2);
        vec44 = vec44.add3(vec45);
        List<Position> list4 = Arrays.asList(globe.computePositionFromPoint(vec43), position, globe.computePositionFromPoint(vec44));
        this.paths[1].setPositions(new ArrayList<Position>(list4));
        double d2 = vec45.getLength3();
        vec45 = vec42.subtract3(vec4);
        vec4 = vec4.add3(vec45.normalize3().multiply3(d2));
        list3.set(1, globe.computePositionFromPoint(vec4));
        return d;
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        this.dashedAttributes.copy(this.getActiveShapeAttributes());
        this.dashedAttributes.setOutlineStipplePattern(this.getOutlineStipplePattern());
        this.dashedAttributes.setOutlineStippleFactor(this.getOutlineStippleFactor());
    }

    @Override
    protected void createLabels() {
        String string = this.getText();
        if (!WWUtil.isEmpty(string)) {
            this.addLabel(string);
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (WWUtil.isEmpty(this.labels)) {
            return;
        }
        Iterator iterator = this.positions.iterator();
        Position position = (Position)iterator.next();
        Position position2 = (Position)iterator.next();
        LatLon latLon = LatLon.interpolate(0.25, position2, position);
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(new Position(latLon, 0.0));
        ((TacticalGraphicLabel)this.labels.get(0)).setOrientationPosition(position);
    }
}

