/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.AbstractTacticalSymbol;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.SymbologyConstants;
import gov.nasa.worldwind.symbology.TacticalGraphicAttributes;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525PointGraphicRetriever;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.util.Logging;
import java.awt.Font;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ForwardEdgeOfBattleArea
extends AbstractMilStd2525TacticalGraphic {
    protected static final Offset LEFT_CENTER = Offset.fromFraction(-0.1, 0.5);
    protected static final Offset RIGHT_CENTER = Offset.fromFraction(1.1, 0.5);
    protected FEBASymbol symbol1;
    protected FEBASymbol symbol2;
    protected TacticalSymbolAttributes activeSymbolAttributes = new BasicTacticalSymbolAttributes();

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-DLF--------");
    }

    public ForwardEdgeOfBattleArea(String string) {
        super(string);
        this.init(string);
    }

    protected void init(String string) {
        this.symbol1 = new FEBASymbol(string);
        this.symbol2 = new FEBASymbol(string);
        this.symbol1.setAttributes(this.activeSymbolAttributes);
        this.symbol2.setAttributes(this.activeSymbolAttributes);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            this.symbol1.setPosition(iterator.next());
            this.symbol2.setPosition(iterator.next());
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        Position position = this.symbol1.getPosition();
        Position position2 = this.symbol2.getPosition();
        if (position != null && position2 != null) {
            return Arrays.asList(position, position2);
        }
        return Collections.emptyList();
    }

    @Override
    public void setStatus(String string) {
        super.setStatus(string);
        this.symbol1.setStatus(string);
        this.symbol2.setStatus(string);
    }

    @Override
    public Position getReferencePosition() {
        return this.symbol1.getPosition();
    }

    @Override
    public void setShowTextModifiers(boolean bl) {
        super.setShowTextModifiers(bl);
        this.symbol1.setShowTextModifiers(bl);
        this.symbol2.setShowTextModifiers(bl);
    }

    @Override
    protected void computeGeometry(DrawContext drawContext) {
        boolean bl;
        super.computeGeometry(drawContext);
        Position position = this.symbol1.getPosition();
        Position position2 = this.symbol2.getPosition();
        if (position == null || position2 == null) {
            return;
        }
        Vec4 vec4 = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), 0.0);
        Vec4 vec42 = drawContext.getView().project(vec4);
        Vec4 vec43 = drawContext.computeTerrainPoint(position2.getLatitude(), position2.getLongitude(), 0.0);
        Vec4 vec44 = drawContext.getView().project(vec43);
        boolean bl2 = bl = vec42.x < vec44.x;
        if (bl) {
            this.symbol1.setTextAlign("gov.nasa.worldwind.avkey.Right");
            this.symbol2.setTextAlign("gov.nasa.worldwind.avkey.Left");
        } else {
            this.symbol1.setTextAlign("gov.nasa.worldwind.avkey.Left");
            this.symbol2.setTextAlign("gov.nasa.worldwind.avkey.Right");
        }
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        this.symbol1.render(drawContext);
        this.symbol2.render(drawContext);
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        this.symbol1.setDelegateOwner(object);
        this.symbol2.setDelegateOwner(object);
    }

    @Override
    protected void determineActiveAttributes() {
        if (this.isHighlighted()) {
            TacticalGraphicAttributes tacticalGraphicAttributes = this.getHighlightAttributes();
            if (tacticalGraphicAttributes != null) {
                this.applyAttributesToSymbol(tacticalGraphicAttributes, this.activeSymbolAttributes);
            }
        } else {
            TacticalGraphicAttributes tacticalGraphicAttributes = this.getAttributes();
            if (tacticalGraphicAttributes != null) {
                this.applyAttributesToSymbol(tacticalGraphicAttributes, this.activeSymbolAttributes);
            }
        }
    }

    protected void applyAttributesToSymbol(TacticalGraphicAttributes tacticalGraphicAttributes, TacticalSymbolAttributes tacticalSymbolAttributes) {
        Material material;
        Font font;
        Double d = tacticalGraphicAttributes.getInteriorOpacity();
        if (d != null) {
            tacticalSymbolAttributes.setOpacity(d);
        }
        if ((font = tacticalGraphicAttributes.getTextModifierFont()) != null) {
            tacticalSymbolAttributes.setTextModifierFont(font);
        }
        if ((material = tacticalGraphicAttributes.getTextModifierMaterial()) != null) {
            tacticalSymbolAttributes.setTextModifierMaterial(material);
        }
    }

    protected static class FEBASymbol
    extends AbstractTacticalSymbol {
        protected String symbolCode;
        protected boolean leftAlign;

        protected FEBASymbol(String string) {
            this.symbolCode = string;
            this.setAltitudeMode(1);
            String string2 = Configuration.getStringValue("gov.nasa.worldwind.avkey.MilStd2525IconRetrieverPath", "https://worldwind.arc.nasa.gov/milstd2525c/rev1/");
            this.setIconRetriever(new MilStd2525PointGraphicRetriever(string2));
        }

        @Override
        public String getIdentifier() {
            return this.symbolCode;
        }

        public void setTextAlign(String string) {
            this.leftAlign = "gov.nasa.worldwind.avkey.Left".equals(string);
        }

        @Override
        protected void layoutTextModifiers(DrawContext drawContext, AVList aVList, AbstractTacticalSymbol.OrderedSymbol orderedSymbol) {
            this.currentLabels.clear();
            Font font = this.getActiveAttributes().getTextModifierFont();
            Offset offset = this.leftAlign ? RIGHT_CENTER : LEFT_CENTER;
            Offset offset2 = this.leftAlign ? LEFT_CENTER : RIGHT_CENTER;
            this.addLabel(drawContext, offset, offset2, this.getText(), font, null, null, orderedSymbol);
        }

        public void setStatus(String string) {
            if (string == null) {
                String string2 = Logging.getMessage("nullValue.StringIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (!SymbologyConstants.STATUS_ALL.contains(string.toUpperCase())) {
                String string3 = Logging.getMessage("Symbology.InvalidStatus", string);
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            SymbolCode symbolCode = new SymbolCode(this.symbolCode);
            symbolCode.setStatus(string);
            this.symbolCode = symbolCode.toString();
        }

        protected String getText() {
            return "FEBA";
        }

        @Override
        protected int getMaxLabelLines(AVList aVList) {
            return 1;
        }
    }
}

