/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.BasicFactory;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.ogc.OGCCapabilities;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Capabilities;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.terrain.LocalRasterServerElevationModel;
import gov.nasa.worldwind.terrain.WCSElevationModel;
import gov.nasa.worldwind.terrain.WMSBasicElevationModel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class BasicElevationModelFactory
extends BasicFactory {
    @Override
    public Object createFromConfigSource(Object object, AVList aVList) {
        ElevationModel elevationModel = (ElevationModel)super.createFromConfigSource(object, aVList);
        if (elevationModel == null) {
            String string = Logging.getMessage("generic.UnrecognizedDocument", object);
            throw new WWUnrecognizedException(string);
        }
        return elevationModel;
    }

    @Override
    protected ElevationModel doCreateFromCapabilities(OGCCapabilities oGCCapabilities, AVList aVList) {
        String string = oGCCapabilities.getServiceInformation().getServiceName();
        if (string == null || !string.equalsIgnoreCase("OGC:WMS") && !string.equalsIgnoreCase("WMS")) {
            String string2 = Logging.getMessage("WMS.NotWMSService", string != null ? string : "null");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames") == null) {
            List<WMSLayerCapabilities> list = ((WMSCapabilities)oGCCapabilities).getNamedLayers();
            if (list == null || list.size() == 0 || list.get(0) == null) {
                String string3 = Logging.getMessage("WMS.NoLayersFound");
                Logging.logger().severe(string3);
                throw new IllegalStateException(string3);
            }
            aVList.setValue("gov.nasa.worldwind.avkey.LayerNames", list.get(0).getName());
        }
        return new WMSBasicElevationModel((WMSCapabilities)oGCCapabilities, aVList);
    }

    @Override
    protected Object doCreateFromCapabilities(WCS100Capabilities wCS100Capabilities, AVList aVList) {
        return new WCSElevationModel(wCS100Capabilities, aVList);
    }

    @Override
    protected ElevationModel doCreateFromElement(Element element, AVList aVList) throws Exception {
        Element element2 = WWXML.getElement(element, ".", null);
        if (element2 == null) {
            return null;
        }
        String string = WWXML.getText(element2, "@href");
        if (string != null && string.length() > 0) {
            return (ElevationModel)this.createFromConfigSource(string, aVList);
        }
        Element[] elementArray = WWXML.getElements(element2, "./ElevationModel", null);
        String string2 = WWXML.getText(element2, "@modelType");
        if (string2 != null && string2.equalsIgnoreCase("compound")) {
            return this.createCompoundModel(elementArray, aVList);
        }
        String string3 = WWXML.getUnqualifiedName(element);
        if (elementArray != null && elementArray.length > 0) {
            return this.createCompoundModel(elementArray, aVList);
        }
        if (string3 != null && string3.equals("ElevationModel")) {
            return this.createNonCompoundModel(element, aVList);
        }
        return null;
    }

    protected CompoundElevationModel createCompoundModel(Element[] elementArray, AVList aVList) {
        CompoundElevationModel compoundElevationModel = new CompoundElevationModel();
        if (elementArray == null || elementArray.length == 0) {
            return compoundElevationModel;
        }
        for (Element element : elementArray) {
            try {
                ElevationModel elevationModel = this.doCreateFromElement(element, aVList);
                if (elevationModel == null) continue;
                compoundElevationModel.addElevationModel(elevationModel);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("ElevationModel.ExceptionCreatingElevationModel");
                Logging.logger().log(Level.WARNING, string, exception);
            }
        }
        return compoundElevationModel;
    }

    protected ElevationModel createNonCompoundModel(Element element, AVList aVList) {
        BasicElevationModel basicElevationModel;
        String string = WWXML.getText(element, "Service/@serviceName");
        if (string.equals("Offline")) {
            basicElevationModel = new BasicElevationModel(element, aVList);
        } else if (string.equals("WWTileService")) {
            basicElevationModel = new BasicElevationModel(element, aVList);
        } else if (string.equals("OGC:WMS")) {
            basicElevationModel = new WMSBasicElevationModel(element, aVList);
        } else if (string.equals("OGC:WCS")) {
            basicElevationModel = new WCSElevationModel(element, aVList);
        } else if ("LocalRasterServer".equals(string)) {
            basicElevationModel = new LocalRasterServerElevationModel(element, aVList);
        } else {
            String string2 = Logging.getMessage("generic.UnrecognizedServiceName", string);
            throw new WWUnrecognizedException(string2);
        }
        return basicElevationModel;
    }
}

