/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.RectangularTessellator;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SectorGeometryList
extends ArrayList<SectorGeometry> {
    protected Sector sector;
    protected PickSupport pickSupport = new PickSupport();
    protected HashMap<SectorGeometry, ArrayList<Point>> pickSectors = new HashMap();

    public SectorGeometryList() {
    }

    public SectorGeometryList(SectorGeometryList sectorGeometryList) {
        super(sectorGeometryList);
    }

    public Sector getSector() {
        return this.sector;
    }

    public void setSector(Sector sector) {
        this.sector = sector;
    }

    public void beginRendering(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getGlobe().getTessellator() instanceof RectangularTessellator) {
            ((RectangularTessellator)drawContext.getGlobe().getTessellator()).beginRendering(drawContext);
        }
    }

    public void endRendering(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getGlobe().getTessellator() instanceof RectangularTessellator) {
            ((RectangularTessellator)drawContext.getGlobe().getTessellator()).endRendering(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (point == null) {
            return;
        }
        this.pickSupport.clearPickList();
        this.pickSupport.beginPicking(drawContext);
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glShadeModel(7424);
        try {
            SectorGeometry sectorGeometry2;
            this.beginRendering(drawContext);
            for (SectorGeometry sectorGeometry2 : this) {
                Color color = drawContext.getUniquePickColor();
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                sectorGeometry2.render(drawContext);
                this.pickSupport.addPickableObject(color.getRGB(), sectorGeometry2, Position.ZERO, true);
            }
            PickedObject pickedObject = this.pickSupport.getTopObject(drawContext, point);
            if (pickedObject == null || pickedObject.getObject() == null) {
                return;
            }
            this.beginSectorGeometryPicking(drawContext);
            sectorGeometry2 = (SectorGeometry)pickedObject.getObject();
            sectorGeometry2.pick(drawContext, point);
        }
        finally {
            this.endSectorGeometryPicking(drawContext);
            this.endRendering(drawContext);
            gL2.glShadeModel(7425);
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.clearPickList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PickedObject> pick(DrawContext drawContext, List<Point> list) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (list == null || list.size() < 1) {
            return null;
        }
        this.pickSupport.clearPickList();
        this.pickSupport.beginPicking(drawContext);
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glShadeModel(7424);
        try {
            Object object;
            ArrayList<Object> arrayList;
            Object object2;
            this.beginRendering(drawContext);
            for (SectorGeometry object42 : this) {
                Color color = drawContext.getUniquePickColor();
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                object42.render(drawContext);
                this.pickSupport.addPickableObject(color.getRGB(), object42, Position.ZERO, true);
            }
            this.pickSectors.clear();
            for (Point point : list) {
                PickedObject pickedObject = this.pickSupport.getTopObject(drawContext, point);
                if (pickedObject == null || pickedObject.getObject() == null) continue;
                object2 = (SectorGeometry)pickedObject.getObject();
                if (!this.pickSectors.containsKey(object2)) {
                    arrayList = new ArrayList();
                    this.pickSectors.put((SectorGeometry)object2, arrayList);
                } else {
                    arrayList = this.pickSectors.get(object2);
                }
                arrayList.add(point);
            }
            if (this.pickSectors.size() < 1) {
                object = null;
                return object;
            }
            this.beginSectorGeometryPicking(drawContext);
            object = new ArrayList();
            for (Map.Entry<SectorGeometry, ArrayList<Point>> entry : this.pickSectors.entrySet()) {
                object2 = entry.getValue();
                arrayList = entry.getKey().pick(drawContext, (List<? extends Point>)object2);
                if (arrayList == null) continue;
                for (ArrayList<Object> arrayList2 : arrayList) {
                    if (arrayList2 == null) continue;
                    ((ArrayList)object).add(arrayList2);
                }
            }
            Object object3 = object;
            return object3;
        }
        finally {
            this.endSectorGeometryPicking(drawContext);
            this.endRendering(drawContext);
            gL2.glShadeModel(7425);
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.clearPickList();
        }
    }

    protected void beginSectorGeometryPicking(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glDepthFunc(515);
        if (drawContext.getGLRuntimeCapabilities().isVMwareSVGA3D()) {
            gL.glDepthMask(false);
            gL.glEnable(32823);
            gL.glPolygonOffset(-1.0f, -1.0f);
        }
    }

    protected void endSectorGeometryPicking(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glDepthFunc(513);
        if (drawContext.getGLRuntimeCapabilities().isVMwareSVGA3D()) {
            gL.glDepthMask(true);
            gL.glDisable(32823);
            gL.glPolygonOffset(0.0f, 0.0f);
        }
    }

    public Vec4 getSurfacePoint(Position position) {
        return this.getSurfacePoint(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    public Vec4 getSurfacePoint(LatLon latLon) {
        return this.getSurfacePoint(latLon.getLatitude(), latLon.getLongitude(), 0.0);
    }

    public Vec4 getSurfacePoint(Angle angle, Angle angle2) {
        return this.getSurfacePoint(angle, angle2, 0.0);
    }

    public Vec4 getSurfacePoint(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < this.size(); ++i) {
            Vec4 vec4;
            SectorGeometry sectorGeometry = (SectorGeometry)this.get(i);
            if (!sectorGeometry.getSector().contains(angle, angle2) || (vec4 = sectorGeometry.getSurfacePoint(angle, angle2, d)) == null) continue;
            return vec4;
        }
        return null;
    }

    public Intersection[] intersect(Line line) {
        Intersection[] intersectionArray;
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<SectorGeometry> arrayList = new ArrayList<SectorGeometry>(this);
        ArrayList<Intersection> arrayList2 = new ArrayList<Intersection>();
        for (SectorGeometry object2 : arrayList) {
            if (!object2.getExtent().intersects(line) || (intersectionArray = object2.intersect(line)) == null) continue;
            arrayList2.addAll(Arrays.asList(intersectionArray));
        }
        int n = arrayList2.size();
        if (n == 0) {
            return null;
        }
        intersectionArray = new Intersection[n];
        arrayList2.toArray(intersectionArray);
        final Vec4 vec4 = line.getOrigin();
        Arrays.sort(intersectionArray, new Comparator<Intersection>(){

            @Override
            public int compare(Intersection intersection, Intersection intersection2) {
                if (intersection == null && intersection2 == null) {
                    return 0;
                }
                if (intersection2 == null) {
                    return -1;
                }
                if (intersection == null) {
                    return 1;
                }
                Vec4 vec43 = intersection.getIntersectionPoint();
                Vec4 vec42 = intersection2.getIntersectionPoint();
                double d = vec4.distanceTo3(vec43);
                double d2 = vec4.distanceTo3(vec42);
                return Double.compare(d, d2);
            }
        });
        return intersectionArray;
    }

    public Intersection[] intersect(double d, Sector sector) {
        Intersection[] intersectionArray;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<SectorGeometry> arrayList = new ArrayList<SectorGeometry>(this);
        ArrayList<Intersection> arrayList2 = new ArrayList<Intersection>();
        for (SectorGeometry sectorGeometry : arrayList) {
            if (!sector.intersects(sectorGeometry.getSector()) || (intersectionArray = sectorGeometry.intersect(d)) == null) continue;
            arrayList2.addAll(Arrays.asList(intersectionArray));
        }
        int n = arrayList2.size();
        if (n == 0) {
            return null;
        }
        intersectionArray = new Intersection[n];
        arrayList2.toArray(intersectionArray);
        return intersectionArray;
    }
}

