/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.ogc.gml.GMLRectifiedGrid;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Capabilities;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100DescribeCoverage;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.terrain.WMSBasicElevationModel;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WCSElevationModel
extends BasicElevationModel {
    public WCSElevationModel(Element element, AVList aVList) {
        super(WCSElevationModel.wcsGetParamsFromDocument(element, aVList));
    }

    public WCSElevationModel(WCS100Capabilities wCS100Capabilities, AVList aVList) {
        super(WCSElevationModel.wcsGetParamsFromCapsDoc(wCS100Capabilities, aVList));
    }

    public WCSElevationModel(String string) {
        super(WCSElevationModel.wcsRestorableStateToParams(string));
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected static AVList wcsGetParamsFromDocument(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        DataConfigurationUtils.getWCSConfigParams(element, aVList);
        BasicElevationModel.getBasicElevationModelConfigParams(element, aVList);
        WCSElevationModel.wcsSetFallbacks(aVList);
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(aVList.getStringValue("gov.nasa.worldwind.avkey.WCSVersion"), aVList));
        return aVList;
    }

    protected static AVList wcsGetParamsFromCapsDoc(WCS100Capabilities wCS100Capabilities, AVList aVList) {
        int n;
        if (wCS100Capabilities == null) {
            String string = Logging.getMessage("nullValue.WCSCapabilities");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ElevationModelConfigParams");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        WCS100DescribeCoverage wCS100DescribeCoverage = (WCS100DescribeCoverage)aVList.getValue("gov.nasa.worldwind.avkey.Document");
        if (wCS100DescribeCoverage == null) {
            String string = Logging.getMessage("nullValue.WCSDescribeCoverage");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        WCSElevationModel.getWCSElevationModelConfigParams(wCS100Capabilities, wCS100DescribeCoverage, aVList);
        WCSElevationModel.wcsSetFallbacks(aVList);
        WCSElevationModel.determineNumLevels(wCS100DescribeCoverage, aVList);
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(wCS100Capabilities.getVersion(), aVList));
        if (aVList.getValue("gov.nasa.worldwind.avkey.ElevationExtremesFileKey") == null && (n = ((Integer)aVList.getValue("gov.nasa.worldwind.avkey.NumLevels")).intValue()) >= 6) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationExtremesFileKey", "config/SRTM30Plus_ExtremeElevations_5.bil");
        }
        return aVList;
    }

    protected static void wcsSetFallbacks(AVList aVList) {
        if (aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta") == null) {
            Angle angle = Angle.fromDegrees(20.0);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(angle, angle));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 150);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 150);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".tif");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.MissingDataFlag") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", -9999.0);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", 18);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ElevationMinKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", -11000.0);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ElevationMaxKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", 8850.0);
        }
    }

    protected static void determineNumLevels(WCS100DescribeCoverage wCS100DescribeCoverage, AVList aVList) {
        List<GMLRectifiedGrid> list = wCS100DescribeCoverage.getCoverageOfferings().get(0).getDomainSet().getSpatialDomain().getRectifiedGrids();
        if (list.size() < 1 || list.get(0).getOffsetVectors().size() < 2) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", 18);
            return;
        }
        double d = Math.abs(list.get((int)0).getOffsetVectors().get((int)0).x);
        double d2 = Math.abs(list.get((int)0).getOffsetVectors().get((int)1).y);
        double d3 = Math.min(d, d2);
        int n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey");
        LatLon latLon = (LatLon)aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta");
        double d4 = Math.log(latLon.getLatitude().degrees / (d3 * (double)n)) / Math.log(2.0);
        aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", (int)(Math.ceil(d4) + 1.0));
    }

    public static AVList getWCSElevationModelConfigParams(WCS100Capabilities wCS100Capabilities, WCS100DescribeCoverage wCS100DescribeCoverage, AVList aVList) {
        DataConfigurationUtils.getWCSConfigParameters(wCS100Capabilities, wCS100DescribeCoverage, aVList);
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey") == null) {
            Logging.logger().warning(Logging.getMessage("WCS.NoCoverageName"));
            throw new WWRuntimeException(Logging.getMessage("WCS.NoCoverageName"));
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey") == null) {
            Logging.logger().warning(Logging.getMessage("WCS.NoGetCoverageURL"));
            throw new WWRuntimeException(Logging.getMessage("WCS.NoGetCoverageURL"));
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey") == null) {
            Logging.logger().warning(Logging.getMessage("nullValue.DataCacheIsNull"));
            throw new WWRuntimeException(Logging.getMessage("nullValue.DataCacheIsNull"));
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            Logging.logger().severe("WCS.NoImageFormats");
            throw new WWRuntimeException(Logging.getMessage("WCS.NoImageFormats"));
        }
        if (aVList.getValue("gov.nasa.worldwind.avKey.Sector") == null) {
            Logging.logger().severe("WCS.NoLonLatEnvelope");
            throw new WWRuntimeException(Logging.getMessage("WCS.NoLonLatEnvelope"));
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.CoordinateSystem") == null) {
            String string = Logging.getMessage("WCS.RequiredCRSNotSupported", "EPSG:4326");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        return aVList;
    }

    @Override
    protected Document createConfigurationDocument(AVList aVList) {
        Document document = super.createConfigurationDocument(aVList);
        if (document == null || document.getDocumentElement() == null) {
            return document;
        }
        DataConfigurationUtils.createWCSLayerConfigElements(aVList, document.getDocumentElement());
        return document;
    }

    @Override
    public void composeElevations(Sector sector, List<? extends LatLon> list, int n, double[] dArray) throws Exception {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < list.size() || n > list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        WMSBasicElevationModel.ElevationCompositionTile elevationCompositionTile = new WMSBasicElevationModel.ElevationCompositionTile(sector, this.getLevels().getLastLevel(), n, list.size() / n);
        this.downloadElevations(elevationCompositionTile);
        elevationCompositionTile.setElevations(this.readElevations(elevationCompositionTile.getFile().toURI().toURL()), this);
        for (int i = 0; i < list.size(); ++i) {
            double d;
            LatLon latLon = list.get(i);
            if (latLon == null || (d = this.lookupElevation(latLon.getLatitude(), latLon.getLongitude(), elevationCompositionTile)) == this.getMissingDataSignal()) continue;
            dArray[i] = d;
        }
    }

    protected void downloadElevations(WMSBasicElevationModel.ElevationCompositionTile elevationCompositionTile) throws Exception {
        URL uRL = elevationCompositionTile.getResourceURL();
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new WMSBasicElevationModel.CompositionRetrievalPostProcessor(elevationCompositionTile.getFile()));
        hTTPRetriever.setConnectTimeout(10000);
        hTTPRetriever.setReadTimeout(60000);
        hTTPRetriever.call();
    }

    @Override
    public void getRestorableStateForAVPair(String string, Object object, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (object instanceof URLBuilder) {
            restorableSupport.addStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.WCSVersion", ((URLBuilder)object).serviceVersion);
        } else if (!(object instanceof WCS100DescribeCoverage)) {
            super.getRestorableStateForAVPair(string, object, restorableSupport, stateObject);
        }
    }

    protected static AVList wcsRestorableStateToParams(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        WCSElevationModel.wcsRestoreStateForParams(restorableSupport, null, aVListImpl);
        return aVListImpl;
    }

    protected static void wcsRestoreStateForParams(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject, AVList aVList) {
        WCSElevationModel.restoreStateForParams(restorableSupport, null, aVList);
        String string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.ImageFormat");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.Title")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.Title", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DisplayName")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
        }
        RestorableSupport.adjustTitleAndDisplayName(aVList);
        string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.CoverageIdentifiers");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.CoverageIdentifiers", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.WCSVersion")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(string, aVList));
        }
    }

    protected static class URLBuilder
    implements TileUrlBuilder {
        protected final String layerNames;
        private final String imageFormat;
        protected final String serviceVersion;
        protected String URLTemplate = null;

        protected URLBuilder(String string, AVList aVList) {
            this.serviceVersion = string;
            this.layerNames = aVList.getStringValue("gov.nasa.worldwind.avkey.CoverageIdentifiers");
            this.imageFormat = aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat");
        }

        @Override
        public URL getURL(Tile tile, String string) throws MalformedURLException {
            StringBuffer stringBuffer;
            if (this.URLTemplate == null) {
                stringBuffer = new StringBuffer(tile.getLevel().getService());
                if (!stringBuffer.toString().toLowerCase().contains("service=wcs")) {
                    stringBuffer.append("service=WCS");
                }
                stringBuffer.append("&request=GetCoverage");
                stringBuffer.append("&version=");
                stringBuffer.append(this.serviceVersion);
                stringBuffer.append("&crs=EPSG:4326");
                stringBuffer.append("&coverage=");
                stringBuffer.append(this.layerNames);
                stringBuffer.append("&format=");
                if (string == null) {
                    stringBuffer.append(this.imageFormat);
                } else {
                    stringBuffer.append(string);
                }
                this.URLTemplate = stringBuffer.toString();
            } else {
                stringBuffer = new StringBuffer(this.URLTemplate);
            }
            stringBuffer.append("&width=");
            stringBuffer.append(tile.getWidth());
            stringBuffer.append("&height=");
            stringBuffer.append(tile.getHeight());
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            stringBuffer.append(sector.getMinLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMinLatitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLatitude().getDegrees());
            stringBuffer.append("&");
            return new URL(stringBuffer.toString().replace(" ", "%20"));
        }
    }
}

