/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.Movable2;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.drag.DragContext;
import gov.nasa.worldwind.drag.Draggable;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;

public class BasicDragger
implements SelectListener {
    protected WorldWindow wwd;
    protected boolean dragging = false;
    protected DragContext dragContext;
    protected Vec4 dragRefObjectPoint;
    protected Point dragRefCursorPoint;
    protected double dragRefAltitude;

    public BasicDragger(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
    }

    public BasicDragger(WorldWindow worldWindow, boolean bl) {
        this(worldWindow);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isUseTerrain() {
        return false;
    }

    public void setUseTerrain(boolean bl) {
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.dragContext.setDragState("gov.nasa.worldwind.avkey.DragEnded");
            this.fireDrag((DragSelectEvent)selectEvent);
            this.dragContext = null;
            this.dragging = false;
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            if (this.dragContext == null) {
                this.dragContext = new DragContext();
            }
            this.dragContext.setPoint(selectEvent.getPickPoint());
            this.dragContext.setPreviousPoint(((DragSelectEvent)selectEvent).getPreviousPickPoint());
            this.dragContext.setView(this.wwd.getView());
            this.dragContext.setGlobe(this.wwd.getModel().getGlobe());
            this.dragContext.setSceneController(this.wwd.getSceneController());
            if (this.dragging) {
                this.dragContext.setDragState("gov.nasa.worldwind.avkey.DragChange");
                this.fireDrag((DragSelectEvent)selectEvent);
            } else {
                this.dragContext.setDragState("gov.nasa.worldwind.avkey.DragBegin");
                this.dragContext.setInitialPoint(((DragSelectEvent)selectEvent).getPreviousPickPoint());
                this.dragging = true;
                this.fireDrag((DragSelectEvent)selectEvent);
            }
        }
        selectEvent.consume();
    }

    protected void fireDrag(DragSelectEvent dragSelectEvent) {
        if (dragSelectEvent == null || dragSelectEvent.getTopObject() == null) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = dragSelectEvent.getTopObject();
        if (object instanceof Draggable) {
            ((Draggable)object).drag(this.dragContext);
        } else if (object instanceof Movable2 || object instanceof Movable) {
            this.dragLegacy(dragSelectEvent);
        }
    }

    protected void dragLegacy(SelectEvent selectEvent) {
        DragSelectEvent dragSelectEvent = (DragSelectEvent)selectEvent;
        Object object = dragSelectEvent.getTopObject();
        if (object == null) {
            return;
        }
        View view = this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        Position position = null;
        if (object instanceof Movable2) {
            position = ((Movable2)object).getReferencePosition();
        } else if (object instanceof Movable) {
            position = ((Movable)object).getReferencePosition();
        }
        if (position == null) {
            return;
        }
        Vec4 vec4 = globe.computePointFromPosition(position);
        if (this.dragContext.getDragState().equals("gov.nasa.worldwind.avkey.DragBegin")) {
            this.dragRefObjectPoint = view.project(vec4);
            this.dragRefCursorPoint = dragSelectEvent.getPreviousPickPoint();
            this.dragRefAltitude = globe.computePositionFromPoint(vec4).getElevation();
        }
        int n = dragSelectEvent.getPickPoint().x - this.dragRefCursorPoint.x;
        int n2 = dragSelectEvent.getPickPoint().y - this.dragRefCursorPoint.y;
        double d = this.dragRefObjectPoint.x + (double)n;
        double d2 = (double)selectEvent.getMouseEvent().getComponent().getSize().height - this.dragRefObjectPoint.y + (double)n2 - 1.0;
        Line line = view.computeRayFromScreenPoint(d, d2);
        Position position2 = null;
        Intersection[] intersectionArray = globe.intersect(line, this.dragRefAltitude);
        if (intersectionArray != null) {
            position2 = globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
        }
        if (position2 != null) {
            Position position3 = new Position(position2, position.getElevation());
            if (object instanceof Movable2) {
                ((Movable2)object).moveTo(globe, position3);
            } else {
                ((Movable)object).moveTo(position3);
            }
        }
    }
}

