/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.BitSetQuadTreeFilter;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class BasicQuadTree<T>
extends BitSetQuadTreeFilter
implements Iterable<T> {
    protected ArrayList<double[]> levelZeroCells;
    protected Map<String, List<T>> items;
    protected T currentItem;
    protected String currentName;
    protected HashMap<String, T> nameMap = new HashMap();
    protected boolean allowDuplicates = true;

    public BasicQuadTree(int n, Sector sector, Map<String, List<T>> hashMap) {
        super(n, null);
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.makeLevelZeroCells(sector);
        this.items = hashMap != null ? hashMap : new HashMap();
    }

    public BasicQuadTree(int n, Sector sector, Map<String, List<T>> hashMap, boolean bl) {
        this(n, sector, hashMap);
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.allowDuplicates = bl;
        this.makeLevelZeroCells(sector);
        this.items = hashMap != null ? hashMap : new HashMap();
    }

    protected void makeLevelZeroCells(Sector sector) {
        Sector[] sectorArray = sector.subdivide();
        this.levelZeroCells = new ArrayList(4);
        this.levelZeroCells.add(sectorArray[0].asDegreesArray());
        this.levelZeroCells.add(sectorArray[1].asDegreesArray());
        this.levelZeroCells.add(sectorArray[3].asDegreesArray());
        this.levelZeroCells.add(sectorArray[2].asDegreesArray());
    }

    public synchronized boolean hasItems() {
        return !this.items.isEmpty();
    }

    public synchronized boolean contains(T t) {
        if (t == null) {
            return false;
        }
        for (Map.Entry<String, List<T>> entry : this.items.entrySet()) {
            List<T> list = entry.getValue();
            if (list == null || !list.contains(t)) continue;
            return true;
        }
        return false;
    }

    public synchronized void add(T t, double[] dArray, String string) {
        this.addItem(t, dArray, string);
    }

    public synchronized void add(T t, double[] dArray) {
        this.addItem(t, dArray, null);
    }

    protected void addItem(T t, double[] dArray, String string) {
        if (t == null) {
            String string2 = Logging.getMessage("nullValue.ItemIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (dArray == null) {
            String string3 = Logging.getMessage("nullValue.CoordinatesAreNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.currentItem = t;
        this.currentName = string;
        this.start();
        for (int i = 0; i < this.levelZeroCells.size(); ++i) {
            this.testAndDo(0, i, this.levelZeroCells.get(i), dArray);
        }
    }

    public synchronized void remove(T t) {
        if (t == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, List<T>> entry : this.items.entrySet()) {
            List<T> list = entry.getValue();
            if (list == null) continue;
            if (list.contains(t)) {
                list.remove(t);
            }
            if (list.size() != 0) continue;
            arrayList.add(entry.getKey());
        }
        for (String string : arrayList) {
            this.bits.clear(Integer.parseInt(string));
        }
    }

    public synchronized void removeByName(String string) {
        T t = this.getByName(string);
        this.nameMap.remove(string);
        if (t == null) {
            return;
        }
        for (Map.Entry<String, List<T>> entry : this.items.entrySet()) {
            List<T> list = entry.getValue();
            if (list == null || !list.contains(t)) continue;
            list.remove(t);
        }
    }

    public synchronized void clear() {
        this.items.clear();
        this.bits.clear();
    }

    public synchronized T getByName(String string) {
        return string != null ? (T)this.nameMap.get(string) : null;
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<List<T>> mapIterator;
            private Iterator<T> listIterator;
            private T nextItem;
            {
                this.mapIterator = BasicQuadTree.this.items.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.nextItem != null) {
                    return true;
                }
                this.moveToNextItem();
                return this.nextItem != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Iteration has no more elements.");
                }
                Object t = this.nextItem;
                this.nextItem = null;
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove() operations is not supported by this Iterator.");
            }

            private void moveToNextItem() {
                if (this.listIterator != null && this.listIterator.hasNext()) {
                    this.nextItem = this.listIterator.next();
                    return;
                }
                this.listIterator = null;
                while (this.mapIterator.hasNext()) {
                    if (this.mapIterator.hasNext()) {
                        this.listIterator = this.mapIterator.next().iterator();
                    }
                    if (this.listIterator == null || !this.listIterator.hasNext()) continue;
                    this.nextItem = this.listIterator.next();
                    return;
                }
            }
        };
    }

    public synchronized Set<T> getItemsAtLocation(LatLon latLon, Set<T> set) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BitSetQuadTreeFilter.FindIntersectingBitsOp findIntersectingBitsOp = new BitSetQuadTreeFilter.FindIntersectingBitsOp(this);
        List<Integer> list = findIntersectingBitsOp.getOnBits(this.levelZeroCells, latLon.asDegreesArray(), new ArrayList<Integer>());
        return this.buildItemSet(list, set);
    }

    public synchronized Set<T> getItemsAtLocation(Iterable<LatLon> iterable, Set<T> set) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BitSetQuadTreeFilter.FindIntersectingBitsOp findIntersectingBitsOp = new BitSetQuadTreeFilter.FindIntersectingBitsOp(this);
        List<Integer> list = new ArrayList<Integer>();
        for (LatLon latLon : iterable) {
            if (latLon == null) continue;
            list = findIntersectingBitsOp.getOnBits(this.levelZeroCells, latLon.asDegreesArray(), list);
        }
        return this.buildItemSet(list, set);
    }

    public synchronized Set<T> getItemsInRegion(Sector sector, Set<T> set) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BitSetQuadTreeFilter.FindIntersectingBitsOp findIntersectingBitsOp = new BitSetQuadTreeFilter.FindIntersectingBitsOp(this);
        List<Integer> list = findIntersectingBitsOp.getOnBits(this.levelZeroCells, sector, new ArrayList<Integer>());
        return this.buildItemSet(list, set);
    }

    public Set<T> getItemsInRegions(Iterable<Sector> iterable, Set<T> set) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.SectorListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BitSetQuadTreeFilter.FindIntersectingBitsOp findIntersectingBitsOp = new BitSetQuadTreeFilter.FindIntersectingBitsOp(this);
        List<Integer> list = new ArrayList<Integer>();
        for (Sector sector : iterable) {
            if (sector == null) continue;
            list = findIntersectingBitsOp.getOnBits(this.levelZeroCells, sector, list);
        }
        return this.buildItemSet(list, set);
    }

    public synchronized Set<T> getItemsInRegions(SectorGeometryList sectorGeometryList, Set<T> set) {
        if (sectorGeometryList == null) {
            String string = Logging.getMessage("nullValue.SectorGeometryListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BitSetQuadTreeFilter.FindIntersectingBitsOp findIntersectingBitsOp = new BitSetQuadTreeFilter.FindIntersectingBitsOp(this);
        List<Integer> list = new ArrayList<Integer>();
        for (SectorGeometry sectorGeometry : sectorGeometryList) {
            if (sectorGeometry == null) continue;
            list = findIntersectingBitsOp.getOnBits(this.levelZeroCells, sectorGeometry.getSector(), list);
        }
        return this.buildItemSet(list, set);
    }

    protected Set<T> buildItemSet(List<Integer> list, Set<T> set) {
        if (set == null) {
            set = new HashSet<T>();
        }
        if (list == null) {
            return set;
        }
        for (Integer n : list) {
            List<T> list2 = this.items.get(n.toString());
            if (list2 == null) continue;
            for (T t : list2) {
                set.add(t);
            }
        }
        return set;
    }

    @Override
    protected boolean doOperation(int n, int n2, double[] dArray, double[] dArray2) {
        int n3 = this.computeBitPosition(n, n2);
        this.bits.set(n3);
        if (n < this.maxLevel) {
            return true;
        }
        String string = Integer.toString(n3);
        List<T> list = this.items.get(string);
        if (list == null) {
            list = new ArrayList<T>();
            this.items.put(string, list);
        }
        list.add(this.currentItem);
        if (this.currentName != null) {
            this.nameMap.put(this.currentName, this.currentItem);
        }
        if (!this.allowDuplicates) {
            this.stop();
        }
        return false;
    }
}

