/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWBufferUtil;

public abstract class BufferFactory {
    private final boolean allocateDirect;

    protected BufferFactory(boolean bl) {
        this.allocateDirect = bl;
    }

    protected BufferFactory() {
        this(true);
    }

    public boolean isAllocateDirect() {
        return this.allocateDirect;
    }

    public abstract BufferWrapper newBuffer(int var1);

    public static class DoubleBufferFactory
    extends BufferFactory {
        public DoubleBufferFactory(boolean bl) {
            super(bl);
        }

        public DoubleBufferFactory() {
        }

        @Override
        public BufferWrapper newBuffer(int n) {
            if (n < 0) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return WWBufferUtil.newDoubleBufferWrapper(n, this.isAllocateDirect());
        }
    }

    public static class FloatBufferFactory
    extends BufferFactory {
        public FloatBufferFactory(boolean bl) {
            super(bl);
        }

        public FloatBufferFactory() {
        }

        @Override
        public BufferWrapper newBuffer(int n) {
            if (n < 0) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return WWBufferUtil.newFloatBufferWrapper(n, this.isAllocateDirect());
        }
    }

    public static class IntBufferFactory
    extends BufferFactory {
        public IntBufferFactory(boolean bl) {
            super(bl);
        }

        public IntBufferFactory() {
        }

        @Override
        public BufferWrapper newBuffer(int n) {
            if (n < 0) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return WWBufferUtil.newIntBufferWrapper(n, this.isAllocateDirect());
        }
    }

    public static class ShortBufferFactory
    extends BufferFactory {
        public ShortBufferFactory(boolean bl) {
            super(bl);
        }

        public ShortBufferFactory() {
        }

        @Override
        public BufferWrapper newBuffer(int n) {
            if (n < 0) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return WWBufferUtil.newShortBufferWrapper(n, this.isAllocateDirect());
        }
    }

    public static class ByteBufferFactory
    extends BufferFactory {
        public ByteBufferFactory(boolean bl) {
            super(bl);
        }

        public ByteBufferFactory() {
        }

        @Override
        public BufferWrapper newBuffer(int n) {
            if (n < 0) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return WWBufferUtil.newByteBufferWrapper(n, this.isAllocateDirect());
        }
    }
}

