/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;

public class ClippingTessellator {
    protected GLUtessellator tessellator;
    protected double[] clipDegrees;
    protected double[] prevCoord = new double[2];
    protected int prevClipCode;

    public ClippingTessellator(GLUtessellator gLUtessellator, Sector sector) {
        if (gLUtessellator == null) {
            String string = Logging.getMessage("nullValue.TessellatorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tessellator = gLUtessellator;
        this.clipDegrees = sector.asDegreesArray();
    }

    public void beginContour() {
        GLU.gluTessBeginContour(this.tessellator);
        this.prevClipCode = -1;
    }

    public void endContour() {
        GLU.gluTessEndContour(this.tessellator);
    }

    public void addVertex(double d, double d2) {
        int n = this.clipCode(d, d2);
        if (this.prevClipCode > 0 && n != this.prevClipCode) {
            this.doAddVertex(this.prevCoord[0], this.prevCoord[1]);
        }
        if (n == 0 || n != this.prevClipCode) {
            this.doAddVertex(d, d2);
        }
        this.prevCoord[0] = d;
        this.prevCoord[1] = d2;
        this.prevClipCode = n;
    }

    protected void doAddVertex(double d, double d2) {
        double[] dArray = new double[]{d2, d, 0.0};
        GLU.gluTessVertex(this.tessellator, dArray, 0, dArray);
    }

    protected int clipCode(double d, double d2) {
        int n = 0;
        n |= d < this.clipDegrees[0] ? 1 : 0;
        n |= d > this.clipDegrees[1] ? 16 : 0;
        n |= d2 < this.clipDegrees[2] ? 256 : 0;
        return n |= d2 > this.clipDegrees[3] ? 4096 : 0;
    }
}

