/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Capabilities;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100CoverageOffering;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100DescribeCoverage;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100LonLatEnvelope;
import gov.nasa.worldwind.ogc.wcs.wcs100.WCS100Values;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerStyle;
import gov.nasa.worldwind.terrain.AbstractElevationModel;
import gov.nasa.worldwind.util.DataConfigurationFilter;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.wms.CapabilitiesRequest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.xml.stream.events.XMLEvent;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataConfigurationUtils {
    protected static final String DATE_TIME_PATTERN = "dd MM yyyy HH:mm:ss z";
    protected static final String DEFAULT_TEXTURE_FORMAT = "image/dds";

    public static boolean isDataConfig(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (AbstractLayer.isLayerConfigDocument(element)) {
            return true;
        }
        if (AbstractElevationModel.isElevationModelConfigDocument(element)) {
            return true;
        }
        if (DataConfigurationUtils.isInstalledDataDescriptorConfigDocument(element)) {
            return true;
        }
        return DataConfigurationUtils.isWWDotNetLayerSetConfigDocument(element);
    }

    public static Document convertToStandardDataConfigDocument(Document document) {
        if (document == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return null;
        }
        if (DataConfigurationUtils.isInstalledDataDescriptorConfigDocument(element)) {
            return DataConfigurationUtils.transformInstalledDataDescriptorConfigDocument(element);
        }
        if (DataConfigurationUtils.isWWDotNetLayerSetConfigDocument(element)) {
            return DataConfigurationUtils.transformWWDotNetLayerSetConfigDocument(element);
        }
        return document;
    }

    public static String getDataConfigDisplayName(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (AbstractLayer.isLayerConfigDocument(element) || AbstractElevationModel.isElevationModelConfigDocument(element)) {
            return WWXML.getText(element, "DisplayName");
        }
        if (DataConfigurationUtils.isInstalledDataDescriptorConfigDocument(element)) {
            return WWXML.getText(element, "property[@name=\"dataSet\"]/property[@name=\"gov.nasa.worldwind.avkey.DatasetNameKey\"]");
        }
        if (DataConfigurationUtils.isWWDotNetLayerSetConfigDocument(element)) {
            return WWXML.getText(element, "QuadTileSet/Name");
        }
        return null;
    }

    public static String getDataConfigType(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (AbstractLayer.isLayerConfigDocument(element)) {
            return "Layer";
        }
        if (AbstractElevationModel.isElevationModelConfigDocument(element)) {
            return "ElevationModel";
        }
        if (DataConfigurationUtils.isInstalledDataDescriptorConfigDocument(element)) {
            String string = WWXML.getText(element, "property[@name=\"dataSet\"]/property[@name=\"gov.nasa.worldwind.avkey.DataType\"]", null);
            if (string != null && string.equals("gov.nasa.worldwind.avkey.TiledElevations")) {
                return "ElevationModel";
            }
            return "Layer";
        }
        if (DataConfigurationUtils.isWWDotNetLayerSetConfigDocument(element)) {
            return "Layer";
        }
        return null;
    }

    public static String getDataConfigFilename(AVList aVList, String string) {
        if (aVList == null) {
            String string2 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = aVList.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey");
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        String string4 = aVList.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey");
        if (string4 == null || string4.length() == 0) {
            string4 = aVList.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "DataConfiguration";
        }
        string4 = WWIO.replaceIllegalFileNameCharacters(string4);
        return string3 + File.separator + string4 + (string != null ? string : "");
    }

    public static AVList getDataConfigCacheName(String string, AVList aVList) {
        String string2;
        if (string == null || string.length() == 0) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        if (((string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) == null || string2.length() == 0) && (string2 = WWIO.getParentFilePath(string)) != null && string2.length() > 0) {
            string2 = string2.replaceAll("\\\\", "/");
            aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string2);
        }
        return aVList;
    }

    public static boolean hasDataConfigFile(FileStore fileStore, String string, boolean bl, long l) {
        if (fileStore == null) {
            String string2 = Logging.getMessage("nullValue.FileStoreIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        URL uRL = DataConfigurationUtils.findExistingDataConfigFile(fileStore, string);
        if (uRL != null && !WWIO.isFileOutOfDate(uRL, l)) {
            return true;
        }
        if (uRL != null && bl) {
            fileStore.removeFile(uRL);
            String string4 = Logging.getMessage("generic.DataFileExpired", uRL);
            Logging.logger().fine(string4);
        }
        return false;
    }

    public static URL findExistingDataConfigFile(FileStore fileStore, String string) {
        if (fileStore == null) {
            String string2 = Logging.getMessage("nullValue.FileStoreIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        URL uRL = fileStore.findFile(string, false);
        if (uRL != null) {
            return uRL;
        }
        String string4 = WWIO.getParentFilePath(string);
        if (string4 == null || string4.length() == 0) {
            return null;
        }
        String[] stringArray = fileStore.listFileNames(string4, new DataConfigurationFilter());
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return fileStore.findFile(stringArray[0], false);
    }

    public static ScheduledExecutorService createResourceRetrievalService(final String string) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setPriority(1);
                if (string != null) {
                    thread.setName(string);
                }
                return thread;
            }
        };
        return Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public static Element createWMSLayerConfigElements(AVList aVList, Element element) {
        Element element2;
        String string;
        if (aVList == null) {
            String string2 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        XPath xPath = WWXML.makeXPath();
        Element element3 = WWXML.getElement(element, "Service", xPath);
        if (element3 == null) {
            element3 = WWXML.appendElementPath(element, "Service");
        }
        if ((string = AVListImpl.getStringValue(aVList, "gov.nasa.worldwind.avkey.ServiceName", "OGC:WMS")) != null && string.length() > 0) {
            WWXML.setTextAttribute(element3, "serviceName", string);
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.WMSVersion")) != null && string.length() > 0) {
            WWXML.setTextAttribute(element3, "version", string);
        }
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.LayerNames", element3, "LayerNames");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.StyleNames", element3, "StyleNames");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.GetMapURL", element3, "GetMapURL");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.GetCapabilitiesURL", element3, "GetCapabilitiesURL");
        string = aVList.getStringValue("gov.nasa.worldwind.avkey.GetMapURL");
        if (string != null && string.length() > 0 && (element2 = WWXML.getElement(element3, "URL", xPath)) != null) {
            element3.removeChild(element2);
        }
        return element;
    }

    public static Element createWCSLayerConfigElements(AVList aVList, Element element) {
        Element element2;
        String string;
        if (aVList == null) {
            String string2 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (element == null) {
            String string3 = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        XPath xPath = WWXML.makeXPath();
        Element element3 = WWXML.getElement(element, "Service", xPath);
        if (element3 == null) {
            element3 = WWXML.appendElementPath(element, "Service");
        }
        if ((string = AVListImpl.getStringValue(aVList, "gov.nasa.worldwind.avkey.ServiceName", "OGC:WCS")) != null && string.length() > 0) {
            WWXML.setTextAttribute(element3, "serviceName", string);
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.WCSVersion")) != null && string.length() > 0) {
            WWXML.setTextAttribute(element3, "version", string);
        }
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.CoverageIdentifiers", element3, "CoverageIdentifiers");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.GetCoverageURL", element3, "GetCoverageURL");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.GetCapabilitiesURL", element3, "GetCapabilitiesURL");
        string = aVList.getStringValue("gov.nasa.worldwind.avkey.GetCoverageURL");
        if (string != null && string.length() > 0 && (element2 = WWXML.getElement(element3, "URL", xPath)) != null) {
            element3.removeChild(element2);
        }
        return element;
    }

    public static AVList getWMSLayerConfigParams(Element element, AVList aVList) {
        String string;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.WMSVersion", "Service/@version", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.LayerNames", "Service/LayerNames", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.StyleNames", "Service/StyleNames", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.GetMapURL", "Service/GetMapURL", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.GetCapabilitiesURL", "Service/GetCapabilitiesURL", xPath);
        aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", aVList.getValue("gov.nasa.worldwind.avkey.GetMapURL"));
        String string3 = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey");
        if (string3 != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", WWXML.fixGetMapString(string3));
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        }
        return aVList;
    }

    public static AVList getWCSConfigParams(Element element, AVList aVList) {
        String string;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.WCSVersion", "Service/@version", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.CoverageIdentifiers", "Service/CoverageIdentifiers", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.GetCoverageURL", "Service/GetCoverageURL", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.GetCapabilitiesURL", "Service/GetCapabilitiesURL", xPath);
        aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", aVList.getValue("gov.nasa.worldwind.avkey.GetCoverageURL"));
        String string3 = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey");
        if (string3 != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", WWXML.fixGetMapString(string3));
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.CoverageIdentifiers")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        }
        return aVList;
    }

    public static AVList getWMSLayerConfigParams(WMSCapabilities wMSCapabilities, String[] stringArray, AVList aVList) {
        Object uRISyntaxException;
        Object object;
        String string2;
        if (wMSCapabilities == null) {
            String string2 = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        String string5 = aVList.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
        if (string4 == null || string4.length() == 0) {
            String string6 = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        String[] stringArray2 = string4.split(",");
        if (stringArray2 == null || stringArray2.length == 0) {
            String string7 = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        String string8 = aVList.getStringValue("gov.nasa.worldwind.avkey.CoordinateSystem");
        if (WWUtil.isEmpty(string8)) {
            for (String string2 : stringArray2) {
                object = wMSCapabilities.getLayerByName(string2);
                if (object == null) {
                    Logging.logger().warning(Logging.getMessage("WMS.LayerNameMissing", string2));
                    continue;
                }
                if (((WMSLayerCapabilities)object).hasCoordinateSystem("EPSG:4326")) {
                    string8 = "EPSG:4326";
                    break;
                }
                if (!((WMSLayerCapabilities)object).hasCoordinateSystem("CRS:84")) continue;
                string8 = "CRS:84";
                break;
            }
            if (!WWUtil.isEmpty(string8)) {
                aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", string8);
            }
        }
        aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", DataConfigurationUtils.makeTitle(wMSCapabilities, string4, string5));
        aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string4);
        Long l = wMSCapabilities.getLayerLatestLastUpdateTime(stringArray2);
        if (l != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        }
        String string3 = wMSCapabilities.getRequestURL("GetMap", "http", "get");
        if (aVList.getValue("gov.nasa.worldwind.avkey.GetMapURL") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.GetMapURL", string3);
        }
        if ((string3 = aVList.getStringValue("gov.nasa.worldwind.avkey.GetMapURL")) == null || string3.length() == 0) {
            Logging.logger().severe("WMS.RequestMapURLMissing");
            throw new WWRuntimeException(Logging.getMessage("WMS.RequestMapURLMissing"));
        }
        String string6 = wMSCapabilities.getRequestURL("GetCapabilities", "http", "get");
        if (aVList.getValue("gov.nasa.worldwind.avkey.GetCapabilitiesURL") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.GetCapabilitiesURL", string6);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", aVList.getValue("gov.nasa.worldwind.avkey.GetMapURL"));
        string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey");
        if (string2 != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", WWXML.fixGetMapString(string2));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ServiceName") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceName", "OGC:WMS");
        }
        object = wMSCapabilities.getVersion();
        if (aVList.getValue("gov.nasa.worldwind.avkey.WMSVersion") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.WMSVersion", object);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey") == null) {
            try {
                uRISyntaxException = new URI(string3);
                String string12 = WWIO.formPath(((URI)uRISyntaxException).getAuthority(), ((URI)uRISyntaxException).getPath(), string4, string5);
                aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string12);
            }
            catch (URISyntaxException uRISyntaxException2) {
                String string7 = Logging.getMessage("WMS.RequestMapURLBad", string3);
                Logging.logger().log(java.util.logging.Level.SEVERE, string7, uRISyntaxException2);
                throw new WWRuntimeException(string7);
            }
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            uRISyntaxException = DataConfigurationUtils.chooseImageFormat(wMSCapabilities.getImageFormats().toArray(), stringArray);
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", uRISyntaxException);
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            Logging.logger().severe("WMS.NoImageFormats");
            throw new WWRuntimeException(Logging.getMessage("WMS.NoImageFormats"));
        }
        uRISyntaxException = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (uRISyntaxException == null) {
            for (String string9 : stringArray2) {
                Sector sector = wMSCapabilities.getLayerByName(string9).getGeographicBoundingBox();
                if (sector == null) {
                    Logging.logger().log(java.util.logging.Level.SEVERE, "WMS.NoGeographicBoundingBoxForLayer", string9);
                    continue;
                }
                uRISyntaxException = Sector.union((Sector)uRISyntaxException, sector);
            }
            if (uRISyntaxException == null) {
                Logging.logger().severe("WMS.NoGeographicBoundingBox");
                throw new WWRuntimeException(Logging.getMessage("WMS.NoGeographicBoundingBox"));
            }
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", uRISyntaxException);
        }
        return aVList;
    }

    public static AVList getWCSConfigParameters(WCS100Capabilities wCS100Capabilities, WCS100DescribeCoverage wCS100DescribeCoverage, AVList aVList) {
        Double d;
        WCS100Values wCS100Values;
        Object object;
        Object object2;
        Object object3;
        String string;
        if (wCS100Capabilities == null) {
            String string2 = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (wCS100DescribeCoverage == null) {
            String string3 = Logging.getMessage("nullValue.WCSDescribeCoverage");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        WCS100CoverageOffering wCS100CoverageOffering = wCS100DescribeCoverage.getCoverageOfferings().get(0);
        aVList.setValue("gov.nasa.worldwind.avkey.ServiceName", "OGC:WCS");
        aVList.setValue("gov.nasa.worldwind.avkey.WCSVersion", wCS100Capabilities.getVersion() != null ? wCS100Capabilities.getVersion() : "1.0.0");
        aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", wCS100CoverageOffering.getLabel());
        aVList.setValue("gov.nasa.worldwind.avkey.CoverageIdentifiers", wCS100CoverageOffering.getName());
        aVList.setValue("gov.nasa.worldwind.avkey.GetCoverageURL", wCS100Capabilities.getCapability().getGetOperationAddress("GetCoverage"));
        aVList.setValue("gov.nasa.worldwind.avkey.GetCapabilitiesURL", wCS100Capabilities.getCapability().getGetOperationAddress("GetCapabilities"));
        aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", aVList.getValue("gov.nasa.worldwind.avkey.GetCoverageURL"));
        String string5 = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey");
        if (string5 != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", WWXML.fixGetMapString(string5));
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.CoverageIdentifiers")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey") == null) {
            try {
                object3 = new URI(aVList.getStringValue("gov.nasa.worldwind.avkey.GetCoverageURL"));
                object2 = WWIO.formPath(((URI)object3).getAuthority(), ((URI)object3).getPath(), aVList.getStringValue("gov.nasa.worldwind.avkey.CoverageIdentifiers"));
                aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", object2);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string6 = Logging.getMessage("WCS.RequestMapURLBad", aVList.getStringValue("gov.nasa.worldwind.avkey.GetCoverageURL"));
                Logging.logger().log(java.util.logging.Level.SEVERE, string6, uRISyntaxException);
                throw new WWRuntimeException(string6);
            }
        }
        object3 = wCS100CoverageOffering.getSupportedFormats().getStrings().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (((String)object2).toLowerCase().contains("image/tiff")) {
                aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", object2);
                break;
            }
            if (!((String)object2).toLowerCase().contains("tiff")) continue;
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", object2);
            break;
        }
        if ((object3 = wCS100CoverageOffering.getLonLatEnvelope()) != null) {
            object2 = ((WCS100LonLatEnvelope)object3).getPositions().get(0).getPos2();
            object = ((WCS100LonLatEnvelope)object3).getPositions().get(1).getPos2();
            if (object2 != null && object != null) {
                aVList.setValue("gov.nasa.worldwind.avKey.Sector", Sector.fromDegreesAndClamp((double)object2[1], object[1], (double)object2[0], object[0]));
            }
        }
        object2 = "EPSG:4326";
        object = null;
        if (wCS100CoverageOffering.getSupportedCRSs() != null) {
            if (wCS100CoverageOffering.getSupportedCRSs().getRequestResponseCRSs().contains(object2)) {
                object = object2;
            } else if (wCS100CoverageOffering.getSupportedCRSs().getRequestCRSs().contains(object2) && wCS100CoverageOffering.getSupportedCRSs().getResponseCRSs().contains(object2)) {
                object = object2;
            }
        }
        if (object != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", object);
        }
        if ((wCS100Values = wCS100CoverageOffering.getRangeSet().getRangeSet().getNullValues()) != null && wCS100Values.getSingleValues() != null && wCS100Values.getSingleValues().size() > 0 && (d = wCS100Values.getSingleValues().get(0).getSingleValue()) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", d);
        }
        return aVList;
    }

    public static URL getOGCGetCapabilitiesURL(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.GetCapabilitiesURL");
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceName");
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        try {
            if (string2.equals("OGC:WMS")) {
                string2 = "WMS";
                CapabilitiesRequest capabilitiesRequest = new CapabilitiesRequest(new URI(string), string2);
                return capabilitiesRequest.getUri().toURL();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            String string3 = Logging.getMessage("generic.URIInvalid", string);
            Logging.logger().log(java.util.logging.Level.SEVERE, string3, uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            String string4 = Logging.getMessage("generic.URIInvalid", string);
            Logging.logger().log(java.util.logging.Level.SEVERE, string4, malformedURLException);
        }
        return null;
    }

    public static String[] getOGCLayerNames(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        if (string == null || string.length() == 0) {
            return null;
        }
        return string.split(",");
    }

    protected static String chooseImageFormat(Object[] objectArray, String[] stringArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        if (stringArray == null || stringArray.length == 0) {
            return objectArray[0].toString();
        }
        for (String string : stringArray) {
            for (Object object : objectArray) {
                if (!object.toString().equalsIgnoreCase(string)) continue;
                return object.toString();
            }
        }
        return objectArray[0].toString();
    }

    protected static String makeTitle(WMSCapabilities wMSCapabilities, String string, String string2) {
        String[] stringArray = string.split(",");
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            WMSLayerStyle wMSLayerStyle;
            String string4;
            WMSLayerCapabilities wMSLayerCapabilities;
            String string5;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((string5 = (wMSLayerCapabilities = wMSCapabilities.getLayerByName(string4 = stringArray[i])).getTitle()) != null ? string5 : string4);
            if (stringArray2 == null || stringArray2.length <= i || (wMSLayerStyle = wMSLayerCapabilities.getStyleByName(string3 = stringArray2[i])) == null) continue;
            stringBuilder.append(" : ");
            String string6 = wMSLayerStyle.getTitle();
            stringBuilder.append(string6 != null ? string6 : string3);
        }
        return stringBuilder.toString();
    }

    public static Element createLevelSetConfigElements(AVList aVList, Element element) {
        Element element2;
        Integer n;
        Object object;
        Object object2;
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (element == null) {
            String string = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.DatasetNameKey", element, "DatasetName");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.DataCacheNameKey", element, "DataCacheName");
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey");
        if (string != null && string.length() > 0) {
            object2 = WWXML.getElement(element, "Service", null);
            if (object2 == null) {
                object2 = WWXML.appendElementPath(element, "Service");
            }
            WWXML.appendText((Element)object2, "URL", string);
        }
        WWXML.checkAndAppendLongElement(aVList, "gov.nasa.worldwind.avkey.ExpiryTime", element, "LastUpdate");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.FormatSuffixKey", element, "FormatSuffix");
        object2 = AVListImpl.getIntegerValue(aVList, "gov.nasa.worldwind.avkey.NumLevels");
        if (object2 != null) {
            object = WWXML.appendElementPath(element, "NumLevels");
            WWXML.setIntegerAttribute((Element)object, "count", (Integer)object2);
            n = AVListImpl.getIntegerValue(aVList, "gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
            WWXML.setIntegerAttribute((Element)object, "numEmpty", n);
            string = aVList.getStringValue("gov.nasa.worldwind.avkey.InactiveLevels");
            if (string != null && string.length() > 0) {
                WWXML.setTextAttribute((Element)object, "inactive", string);
            }
        }
        WWXML.checkAndAppendSectorElement(aVList, "gov.nasa.worldwind.avKey.Sector", element, "Sector");
        WWXML.checkAndAppendSectorResolutionElement(aVList, "gov.nasa.worldwind.avkey.SectorResolutionLimits", element, "SectorResolutionLimit");
        WWXML.checkAndAppendLatLonElement(aVList, "gov.nasa.worldwind.avkey.TileOrigin", element, "TileOrigin/LatLon");
        object = AVListImpl.getIntegerValue(aVList, "gov.nasa.worldwind.avkey.TileWidthKey");
        n = AVListImpl.getIntegerValue(aVList, "gov.nasa.worldwind.avkey.TileHeightKey");
        if (object != null && n != null) {
            element2 = WWXML.appendElementPath(element, "TileSize/Dimension");
            WWXML.setIntegerAttribute(element2, "width", (Integer)object);
            WWXML.setIntegerAttribute(element2, "height", n);
        }
        WWXML.checkAndAppendLatLonElement(aVList, "gov.nasa.worldwind.avkey.LevelZeroTileDelta", element, "LevelZeroTileDelta/LatLon");
        if (aVList.getValue("gov.nasa.worldwind.avkey.MaxAbsentTileAttempts") != null || aVList.getValue("gov.nasa.worldwind.avkey.MinAbsentTileCheckInterval") != null) {
            element2 = WWXML.getElement(element, "AbsentTiles", null);
            if (element2 == null) {
                element2 = WWXML.appendElementPath(element, "AbsentTiles");
            }
            WWXML.checkAndAppendIntegerlement(aVList, "gov.nasa.worldwind.avkey.MaxAbsentTileAttempts", element2, "MaxAttempts");
            WWXML.checkAndAppendTimeElement(aVList, "gov.nasa.worldwind.avkey.MinAbsentTileCheckInterval", element2, "MinCheckInterval/Time");
        }
        return element;
    }

    public static AVList getLevelSetConfigParams(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.DatasetNameKey", "DatasetName", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.DataCacheNameKey", "DataCacheName", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ServiceURLKey", "Service/URL", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ServiceName", "Service/@serviceName", xPath);
        WWXML.checkAndSetLongParam(element, aVList, "gov.nasa.worldwind.avkey.ExpiryTime", "ExpiryTime", xPath);
        WWXML.checkAndSetDateTimeParam(element, aVList, "gov.nasa.worldwind.avkey.ExpiryTime", "LastUpdate", DATE_TIME_PATTERN, xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.FormatSuffixKey", "FormatSuffix", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.NumLevels", "NumLevels/@count", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.NumEmptyLevels", "NumLevels/@numEmpty", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.InactiveLevels", "NumLevels/@inactive", xPath);
        WWXML.checkAndSetSectorParam(element, aVList, "gov.nasa.worldwind.avKey.Sector", "Sector", xPath);
        WWXML.checkAndSetSectorResolutionParam(element, aVList, "gov.nasa.worldwind.avkey.SectorResolutionLimits", "SectorResolutionLimit", xPath);
        WWXML.checkAndSetLatLonParam(element, aVList, "gov.nasa.worldwind.avkey.TileOrigin", "TileOrigin/LatLon", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.TileWidthKey", "TileSize/Dimension/@width", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.TileHeightKey", "TileSize/Dimension/@height", xPath);
        WWXML.checkAndSetLatLonParam(element, aVList, "gov.nasa.worldwind.avkey.LevelZeroTileDelta", "LevelZeroTileDelta/LatLon", xPath);
        WWXML.checkAndSetIntegerParam(element, aVList, "gov.nasa.worldwind.avkey.MaxAbsentTileAttempts", "AbsentTiles/MaxAttempts", xPath);
        WWXML.checkAndSetTimeParamAsInteger(element, aVList, "gov.nasa.worldwind.avkey.MinAbsentTileCheckInterval", "AbsentTiles/MinCheckInterval/Time", xPath);
        return aVList;
    }

    public static AVList getLevelSetConfigParams(LevelSet levelSet, AVList aVList) {
        LatLon latLon;
        LatLon latLon2;
        LevelSet.SectorResolution[] sectorResolutionArray;
        Sector sector;
        long l;
        Object object;
        if (levelSet == null) {
            String string = Logging.getMessage("nullValue.LevelSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        Level level = levelSet.getFirstLevel();
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey");
        if ((string == null || string.length() == 0) && (string = level.getDataset()) != null && string.length() > 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        }
        if (((string = aVList.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) == null || string.length() == 0) && (string = level.getCacheName()) != null && string.length() > 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string);
        }
        if (((string = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey")) == null || string.length() == 0) && (string = level.getService()) != null && string.length() > 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", string);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.ExpiryTime")) == null && (l = level.getExpiryTime()) > 0L) {
            aVList.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        }
        if (((string = aVList.getStringValue("gov.nasa.worldwind.avkey.FormatSuffixKey")) == null || string.length() == 0) && (string = level.getFormatSuffix()) != null && string.length() > 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", string);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.NumLevels")) == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", levelSet.getNumLevels());
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels")) == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", DataConfigurationUtils.getNumEmptyLevels(levelSet));
        }
        if (((string = aVList.getStringValue("gov.nasa.worldwind.avkey.InactiveLevels")) == null || string.length() == 0) && (string = DataConfigurationUtils.getInactiveLevels(levelSet)) != null && string.length() > 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.InactiveLevels", string);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null && (sector = levelSet.getSector()) != null) {
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.SectorResolutionLimits")) == null && (sectorResolutionArray = levelSet.getSectorLevelLimits()) != null && sectorResolutionArray.length > 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.SectorResolutionLimits", sectorResolutionArray);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.TileOrigin")) == null && (latLon2 = levelSet.getTileOrigin()) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileOrigin", latLon2);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey")) == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", level.getTileWidth());
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey")) == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", level.getTileHeight());
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta")) == null && (latLon = levelSet.getLevelZeroTileDelta()) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon);
        }
        return aVList;
    }

    protected static int getNumEmptyLevels(LevelSet levelSet) {
        int n;
        for (n = 0; n < levelSet.getNumLevels() && levelSet.getLevel(n).isEmpty(); ++n) {
        }
        return n;
    }

    protected static String getInactiveLevels(LevelSet levelSet) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < levelSet.getNumLevels(); ++i) {
            if (levelSet.getLevel(i).isActive()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(i);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    public static boolean isInstalledDataDescriptorConfigDocument(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Element[] elementArray = WWXML.getElements(element, "/dataDescriptor", null);
        return elementArray != null && elementArray.length > 0;
    }

    public static Document transformInstalledDataDescriptorConfigDocument(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        Element[] elementArray = WWXML.getElements(element, "/dataDescriptor/property[@name=\"dataSet\"]", xPath);
        if (elementArray == null || elementArray.length == 0) {
            return null;
        }
        Document document = WWXML.createDocumentBuilder(true).newDocument();
        DataConfigurationUtils.transformDataDescriptorDataSet(elementArray[0], document, xPath);
        return document;
    }

    protected static void transformDataDescriptorDataSet(Element element, Document document, XPath xPath) {
        String string = WWXML.getText(element, "property[@name=\"gov.nasa.worldwind.avkey.DataType\"]", xPath);
        if (string != null && string.equals("gov.nasa.worldwind.avkey.TiledElevations")) {
            Element element2 = WWXML.setDocumentElement(document, "ElevationModel");
            WWXML.setIntegerAttribute(element2, "version", 1);
            DataConfigurationUtils.transformDataDescriptorCommonElements(element, element2, xPath);
            DataConfigurationUtils.transformDataDescriptorElevationModelElements(element, element2, xPath);
        } else {
            Element element3 = WWXML.setDocumentElement(document, "Layer");
            WWXML.setIntegerAttribute(element3, "version", 1);
            WWXML.setTextAttribute(element3, "layerType", "TiledImageLayer");
            DataConfigurationUtils.transformDataDescriptorCommonElements(element, element3, xPath);
            DataConfigurationUtils.transformDataDescriptorLayerElements(element, element3, xPath);
        }
    }

    protected static void transformDataDescriptorCommonElements(Element element, Element element2, XPath xPath) {
        LatLon latLon;
        Sector sector;
        Object object;
        String string = WWXML.getText(element, "property[@name=\"gov.nasa.worldwind.avkey.DatasetNameKey\"]", xPath);
        if (string != null && string.length() != 0) {
            WWXML.appendText(element2, "DisplayName", string);
            WWXML.appendText(element2, "DatasetName", string);
        }
        Element element3 = WWXML.appendElementPath(element2, "Service");
        WWXML.setTextAttribute(element3, "serviceName", "Offline");
        string = WWXML.getText(element, "property[@name=\"gov.nasa.worldwind.avkey.FormatSuffixKey\"]", xPath);
        if (string != null && string.length() != 0) {
            WWXML.appendText(element2, "FormatSuffix", string);
            object = WWIO.makeMimeTypeForSuffix(string);
            if (object != null && ((String)object).length() != 0) {
                WWXML.appendText(element2, "ImageFormat", (String)object);
                WWXML.appendText(element2, "AvailableImageFormats/ImageFormat", (String)object);
            }
        }
        object = WWXML.getInteger(element, "property[@name=\"gov.nasa.worldwind.avkey.NumLevels\"]", xPath);
        Integer n = WWXML.getInteger(element, "property[@name=\"gov.nasa.worldwind.avkey.NumEmptyLevels\"]", xPath);
        if (object != null) {
            element3 = WWXML.appendElementPath(element2, "NumLevels");
            WWXML.setIntegerAttribute(element3, "count", (Integer)object);
            WWXML.setIntegerAttribute(element3, "numEmpty", n != null ? n : 0);
        }
        if ((sector = DataConfigurationUtils.getDataDescriptorSector(element, "property[@name=\"gov.nasa.worldwind.avKey.Sector\"]", xPath)) != null) {
            WWXML.appendSector(element2, "Sector", sector);
        }
        if ((latLon = DataConfigurationUtils.getDataDescriptorLatLon(element, "property[@name=\"gov.nasa.worldwind.avkey.TileOrigin\"]", xPath)) != null) {
            WWXML.appendLatLon(element2, "TileOrigin/LatLon", latLon);
        }
        if ((latLon = DataConfigurationUtils.getDataDescriptorLatLon(element, "property[@name=\"gov.nasa.worldwind.avkey.LevelZeroTileDelta\"]", xPath)) != null) {
            WWXML.appendLatLon(element2, "LevelZeroTileDelta/LatLon", latLon);
        }
        Integer n2 = WWXML.getInteger(element, "property[@name=\"gov.nasa.worldwind.avkey.TileWidthKey\"]", xPath);
        Integer n3 = WWXML.getInteger(element, "property[@name=\"gov.nasa.worldwind.avkey.TileHeightKey\"]", xPath);
        if (n2 != null && n3 != null) {
            element3 = WWXML.appendElementPath(element2, "TileSize/Dimension");
            WWXML.setIntegerAttribute(element3, "width", n2);
            WWXML.setIntegerAttribute(element3, "height", n3);
        }
    }

    protected static void transformDataDescriptorElevationModelElements(Element element, Element element2, XPath xPath) {
        Double d;
        String string;
        Element element3 = WWXML.appendElementPath(element2, "DataType");
        String string2 = WWXML.getText(element, "property[@name=\"gov.nasa.worldwind.avkey.PixelType\"]", xPath);
        if (string2 != null && string2.length() != 0) {
            WWXML.setTextAttribute(element3, "type", WWXML.dataTypeAsText(string2));
        }
        if ((string = WWXML.getText(element, "property[@name=\"gov.nasa.worldwind.avkey.ByteOrder\"]", xPath)) != null && string.length() != 0) {
            WWXML.setTextAttribute(element3, "byteOrder", WWXML.byteOrderAsText(string));
        }
        if ((d = WWXML.getDouble(element, "property[@name=\"gov.nasa.worldwind.avkey.MissingDataValue\"]", xPath)) != null) {
            element3 = WWXML.appendElementPath(element2, "MissingData");
            WWXML.setDoubleAttribute(element3, "signal", d);
        }
        WWXML.appendBoolean(element2, "NetworkRetrievalEnabled", false);
    }

    protected static void transformDataDescriptorLayerElements(Element element, Element element2, XPath xPath) {
        WWXML.appendText(element2, "TextureFormat", DEFAULT_TEXTURE_FORMAT);
        WWXML.appendBoolean(element2, "NetworkRetrievalEnabled", false);
        WWXML.appendBoolean(element2, "UseMipMaps", true);
        WWXML.appendBoolean(element2, "UseTransparentTextures", true);
    }

    protected static LatLon getDataDescriptorLatLon(Element element, String string, XPath xPath) {
        Element element2;
        Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
        if (element2 == null) {
            return null;
        }
        Double d = WWXML.getDouble(element2, "property[@name=\"latitudeDegrees\"]", xPath);
        Double d2 = WWXML.getDouble(element2, "property[@name=\"longitudeDegrees\"]", xPath);
        if (d == null || d2 == null) {
            return null;
        }
        return LatLon.fromDegrees(d, d2);
    }

    protected static Sector getDataDescriptorSector(Element element, String string, XPath xPath) {
        Element element2;
        Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
        if (element2 == null) {
            return null;
        }
        Double d = WWXML.getDouble(element2, "property[@name=\"minLatitudeDegrees\"]", xPath);
        Double d2 = WWXML.getDouble(element2, "property[@name=\"maxLatitudeDegrees\"]", xPath);
        Double d3 = WWXML.getDouble(element2, "property[@name=\"minLongitudeDegrees\"]", xPath);
        Double d4 = WWXML.getDouble(element2, "property[@name=\"maxLongitudeDegrees\"]", xPath);
        if (d == null || d2 == null || d3 == null || d4 == null) {
            return null;
        }
        return Sector.fromDegrees(d, d2, d3, d4);
    }

    public static boolean isWWDotNetLayerSetConfigDocument(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        Element[] elementArray = WWXML.getElements(element, "/LayerSet", xPath);
        return elementArray != null && elementArray.length > 0;
    }

    public static boolean isWWDotNetLayerSetConfigEvent(XMLEvent xMLEvent) {
        if (xMLEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!xMLEvent.isStartElement()) {
            return false;
        }
        String string = WWXML.getUnqalifiedName(xMLEvent.asStartElement());
        return string != null && string.equals("LayerSet");
    }

    public static AVList getWWDotNetLayerSetConfigParams(Element element, AVList aVList) {
        Object object;
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        Element element2 = WWXML.getElement(element, "QuadTileSet", xPath);
        if (element2 == null) {
            return aVList;
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        WWXML.checkAndSetStringParam(element2, aVList, "gov.nasa.worldwind.avkey.DisplayName", "Name", xPath);
        WWXML.checkAndSetStringParam(element2, aVList, "gov.nasa.worldwind.avkey.DatasetNameKey", "Name", xPath);
        if (aVList.getValue("gov.nasa.worldwind.avkey.Opacity") == null && (object = WWXML.getDouble(element2, "Opacity", xPath)) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.Opacity", (Double)object / 255.0);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ServiceName") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceName", "Offline");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null && (object = WWXML.getText(element2, "ImageAccessor/ImageFileExtension", xPath)) != null && ((String)object).length() != 0) {
            if (!((String)object).startsWith(".")) {
                object = "." + (String)object;
            }
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", object);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") != null && (object = WWIO.makeMimeTypeForSuffix(aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey").toString())) != null) {
            if (aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", object);
            }
            if (aVList.getValue("gov.nasa.worldwind.avkey.AvailableImageFormats") == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.AvailableImageFormats", new String[]{object});
            }
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TextureFormat") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TextureFormat", DEFAULT_TEXTURE_FORMAT);
        }
        WWXML.checkAndSetIntegerParam(element2, aVList, "gov.nasa.worldwind.avkey.NumLevels", "ImageAccessor/NumberLevels", xPath);
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        }
        if (aVList.getValue("gov.nasa.worldwind.avKey.Sector") == null && (object = DataConfigurationUtils.getWWDotNetLayerSetSector(element2, "BoundingBox", xPath)) != null) {
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", object);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileOrigin") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileOrigin", new LatLon(Angle.NEG90, Angle.NEG180));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta") == null && (object = DataConfigurationUtils.getWWDotNetLayerSetLatLon(element2, "ImageAccessor/LevelZeroTileSizeDegrees", xPath)) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", object);
        }
        if ((object = WWXML.getInteger(element2, "ImageAccessor/TextureSizePixels", xPath)) != null) {
            if (aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey") == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", object);
            }
            if (aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey") == null) {
                aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", object);
            }
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NetworkRetrievalEnabled") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NetworkRetrievalEnabled", false);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.UseMipMaps") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.UseMipMaps", true);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.UseTransparentTextures") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.UseTransparentTextures", true);
        }
        return aVList;
    }

    public static Document transformWWDotNetLayerSetConfigDocument(Element element) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        Element[] elementArray = WWXML.getElements(element, "/LayerSet/QuadTileSet", xPath);
        if (elementArray == null || elementArray.length == 0) {
            return null;
        }
        Document document = WWXML.createDocumentBuilder(true).newDocument();
        DataConfigurationUtils.transformWWDotNetLayerSet(elementArray[0], document, xPath);
        return document;
    }

    protected static void transformWWDotNetLayerSet(Element element, Document document, XPath xPath) {
        Element element2 = WWXML.setDocumentElement(document, "Layer");
        WWXML.setIntegerAttribute(element2, "version", 1);
        WWXML.setTextAttribute(element2, "layerType", "TiledImageLayer");
        DataConfigurationUtils.transformWWDotNetQuadTileSet(element, element2, xPath);
    }

    protected static void transformWWDotNetQuadTileSet(Element element, Element element2, XPath xPath) {
        Integer n;
        Sector sector;
        Object object;
        Double d;
        Object object2 = WWXML.getText(element, "Name", xPath);
        if (object2 != null && ((String)object2).length() != 0) {
            WWXML.appendText(element2, "DisplayName", (String)object2);
            WWXML.appendText(element2, "DatasetName", (String)object2);
        }
        if ((d = WWXML.getDouble(element, "Opacity", xPath)) != null) {
            WWXML.appendDouble(element2, "Opacity", d / 255.0);
        }
        Element element3 = WWXML.appendElementPath(element2, "Service");
        WWXML.setTextAttribute(element3, "serviceName", "Offline");
        object2 = WWXML.getText(element, "ImageAccessor/ImageFileExtension", xPath);
        if (object2 != null && ((String)object2).length() != 0) {
            if (!((String)object2).startsWith(".")) {
                object2 = "." + (String)object2;
            }
            WWXML.appendText(element2, "FormatSuffix", (String)object2);
            object = WWIO.makeMimeTypeForSuffix((String)object2);
            if (object != null && ((String)object).length() != 0) {
                WWXML.appendText(element2, "ImageFormat", (String)object);
                WWXML.appendText(element2, "AvailableImageFormats/ImageFormat", (String)object);
            }
        }
        WWXML.appendText(element2, "TextureFormat", DEFAULT_TEXTURE_FORMAT);
        object = WWXML.getInteger(element, "ImageAccessor/NumberLevels", xPath);
        if (object != null) {
            element3 = WWXML.appendElementPath(element2, "NumLevels");
            WWXML.setIntegerAttribute(element3, "count", (Integer)object);
            WWXML.setIntegerAttribute(element3, "numEmpty", 0);
        }
        if ((sector = DataConfigurationUtils.getWWDotNetLayerSetSector(element, "BoundingBox", xPath)) != null) {
            WWXML.appendSector(element2, "Sector", sector);
        }
        WWXML.appendLatLon(element2, "TileOrigin/LatLon", new LatLon(Angle.NEG90, Angle.NEG180));
        LatLon latLon = DataConfigurationUtils.getWWDotNetLayerSetLatLon(element, "ImageAccessor/LevelZeroTileSizeDegrees", xPath);
        if (latLon != null) {
            WWXML.appendLatLon(element2, "LevelZeroTileDelta/LatLon", latLon);
        }
        if ((n = WWXML.getInteger(element, "ImageAccessor/TextureSizePixels", xPath)) != null) {
            element3 = WWXML.appendElementPath(element2, "TileSize/Dimension");
            WWXML.setIntegerAttribute(element3, "width", n);
            WWXML.setIntegerAttribute(element3, "height", n);
        }
        WWXML.appendBoolean(element2, "NetworkRetrievalEnabled", false);
        WWXML.appendBoolean(element2, "UseMipMaps", true);
        WWXML.appendBoolean(element2, "UseTransparentTextures", true);
    }

    protected static LatLon getWWDotNetLayerSetLatLon(Element element, String string, XPath xPath) {
        Double d = WWXML.getDouble(element, string, xPath);
        if (d == null) {
            return null;
        }
        return LatLon.fromDegrees(d, d);
    }

    protected static Sector getWWDotNetLayerSetSector(Element element, String string, XPath xPath) {
        Element element2;
        Element element3 = element2 = string == null ? element : WWXML.getElement(element, string, xPath);
        if (element2 == null) {
            return null;
        }
        Double d = WWXML.getDouble(element2, "South/Value", xPath);
        Double d2 = WWXML.getDouble(element2, "North/Value", xPath);
        Double d3 = WWXML.getDouble(element2, "West/Value", xPath);
        Double d4 = WWXML.getDouble(element2, "East/Value", xPath);
        if (d == null || d2 == null || d3 == null || d4 == null) {
            return null;
        }
        return Sector.fromDegrees(d, d2, d3, d4);
    }
}

