/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

public class GLUTessellatorSupport {
    protected GLUtessellator tess;

    public GLUtessellator getGLUtessellator() {
        return this.tess;
    }

    public void beginTessellation(GLUtessellatorCallback gLUtessellatorCallback, Vec4 vec4) {
        if (gLUtessellatorCallback == null) {
            String string = Logging.getMessage("nullValue.CallbackIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.NormalIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tess = GLU.gluNewTess();
        GLU.gluTessNormal(this.tess, vec4.x, vec4.y, vec4.z);
        GLU.gluTessCallback(this.tess, 100100, gLUtessellatorCallback);
        GLU.gluTessCallback(this.tess, 100101, gLUtessellatorCallback);
        GLU.gluTessCallback(this.tess, 100102, gLUtessellatorCallback);
        GLU.gluTessCallback(this.tess, 100105, gLUtessellatorCallback);
    }

    public void endTessellation() {
        GLU.gluTessCallback(this.tess, 100100, null);
        GLU.gluTessCallback(this.tess, 100101, null);
        GLU.gluTessCallback(this.tess, 100102, null);
        GLU.gluTessCallback(this.tess, 100105, null);
        this.tess = null;
    }

    public static GLUtessellatorCallback createOGLDrawPrimitivesCallback(GL2 gL2) {
        if (gL2 == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new OGLDrawPrimitivesCallback(gL2);
    }

    public static String convertGLUTessErrorToString(int n) {
        switch (n) {
            case 100151: {
                return "missing begin polygon";
            }
            case 100153: {
                return "missing end polygon";
            }
            case 100152: {
                return "missing begin contour";
            }
            case 100154: {
                return "missing end contour";
            }
            case 100155: {
                return "coordinate too large";
            }
            case 100156: {
                return "need combine callback";
            }
        }
        return "unknown";
    }

    protected static class OGLDrawPrimitivesCallback
    extends GLUtessellatorCallbackAdapter {
        protected final GL2 gl;

        public OGLDrawPrimitivesCallback(GL2 gL2) {
            if (gL2 == null) {
                String string = Logging.getMessage("nullValue.GLIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.gl = gL2;
        }

        @Override
        public void begin(int n) {
            this.gl.glBegin(n);
        }

        @Override
        public void vertex(Object object) {
            double[] dArray = (double[])object;
            this.gl.glVertex3f((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        }

        @Override
        public void end() {
            this.gl.glEnd();
        }

        @Override
        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            objectArray2[0] = dArray;
        }
    }

    public static class RecursiveCallback
    extends GLUtessellatorCallbackAdapter {
        protected GLUtessellator tess;

        public RecursiveCallback(GLUtessellator gLUtessellator) {
            if (gLUtessellator == null) {
                String string = Logging.getMessage("nullValue.TessellatorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.tess = gLUtessellator;
        }

        @Override
        public void begin(int n) {
            GLU.gluTessBeginContour(this.tess);
        }

        @Override
        public void vertex(Object object) {
            GLU.gluTessVertex(this.tess, (double[])object, 0, object);
        }

        @Override
        public void end() {
            GLU.gluTessEndContour(this.tess);
        }

        @Override
        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            objectArray2[0] = dArray;
        }

        @Override
        public void error(int n) {
            String string = GLUTessellatorSupport.convertGLUTessErrorToString(n);
            String string2 = Logging.getMessage("generic.ExceptionWhileTessellating", string);
            Logging.logger().severe(string2);
        }
    }

    public static class CollectPrimitivesCallback
    extends GLUtessellatorCallbackAdapter {
        protected List<Integer> triangles = new ArrayList<Integer>();
        protected List<Integer> lines = new ArrayList<Integer>();
        protected IntBuffer triangleBuffer = IntBuffer.allocate(0);
        protected IntBuffer lineBuffer = IntBuffer.allocate(0);
        protected int error = 0;
        protected int index = 0;
        protected VertexData[] vertices = new VertexData[]{null, null, null};
        protected boolean[] edgeFlags = new boolean[]{true, true, true};
        protected boolean edgeFlag = true;

        public IntBuffer getTriangleIndices() {
            return this.triangleBuffer.flip();
        }

        public IntBuffer getLineIndices() {
            return this.lineBuffer.flip();
        }

        public int getError() {
            return this.error;
        }

        public void attach(GLUtessellator gLUtessellator) {
            GLU.gluTessCallback(gLUtessellator, 100100, this);
            GLU.gluTessCallback(gLUtessellator, 100102, this);
            GLU.gluTessCallback(gLUtessellator, 100101, this);
            GLU.gluTessCallback(gLUtessellator, 100104, this);
            GLU.gluTessCallback(gLUtessellator, 100103, this);
        }

        public void reset() {
            this.triangles.clear();
            this.lines.clear();
            this.triangleBuffer.clear();
            this.lineBuffer.clear();
            this.error = 0;
            this.index = 0;
            this.edgeFlag = true;
        }

        @Override
        public void begin(int n) {
            if (n != 4) {
                String string = Logging.getMessage("generic.UnexpectedPrimitiveType", n);
                Logging.logger().warning(string);
            }
        }

        @Override
        public void end() {
            this.triangleBuffer = IntBuffer.allocate(this.triangles.size());
            for (Integer n : this.triangles) {
                this.triangleBuffer.put(n);
            }
            this.lineBuffer = IntBuffer.allocate(this.lines.size());
            for (Integer n : this.lines) {
                this.lineBuffer.put(n);
            }
        }

        @Override
        public void vertex(Object object) {
            this.vertices[this.index] = (VertexData)object;
            this.edgeFlags[this.index] = this.edgeFlag;
            ++this.index;
            if (this.index == 3) {
                VertexData vertexData = this.vertices[0];
                VertexData vertexData2 = this.vertices[1];
                VertexData vertexData3 = this.vertices[2];
                this.triangles.add(vertexData.index);
                this.triangles.add(vertexData2.index);
                this.triangles.add(vertexData3.index);
                if (this.edgeFlags[0] && (vertexData.edgeFlag || vertexData2.edgeFlag)) {
                    this.lines.add(vertexData.index);
                    this.lines.add(vertexData2.index);
                }
                if (this.edgeFlags[1] && (vertexData2.edgeFlag || vertexData3.edgeFlag)) {
                    this.lines.add(vertexData2.index);
                    this.lines.add(vertexData3.index);
                }
                if (this.edgeFlags[2] && (vertexData3.edgeFlag || vertexData.edgeFlag)) {
                    this.lines.add(vertexData3.index);
                    this.lines.add(vertexData.index);
                }
                this.index = 0;
            }
        }

        @Override
        public void edgeFlag(boolean bl) {
            this.edgeFlag = bl;
        }

        @Override
        public void error(int n) {
            this.error = n;
        }
    }

    public static class VertexData {
        public final int index;
        public final boolean edgeFlag;

        public VertexData(int n, boolean bl) {
            this.index = n;
            this.edgeFlag = bl;
        }
    }

    public static class CollectIndexListsCallback
    extends GLUtessellatorCallbackAdapter {
        protected int numIndices;
        protected int currentType;
        protected List<Integer> currentPrim;
        protected List<List<Integer>> prims = new ArrayList<List<Integer>>();
        protected List<Integer> primTypes = new ArrayList<Integer>();

        public List<List<Integer>> getPrims() {
            return this.prims;
        }

        public List<Integer> getPrimTypes() {
            return this.primTypes;
        }

        public int getNumIndices() {
            return this.numIndices;
        }

        @Override
        public void begin(int n) {
            this.currentType = n;
            this.currentPrim = new ArrayList<Integer>();
        }

        @Override
        public void vertex(Object object) {
            this.currentPrim.add((Integer)object);
            ++this.numIndices;
        }

        @Override
        public void end() {
            this.primTypes.add(this.currentType);
            this.prims.add(this.currentPrim);
            this.currentPrim = null;
        }

        @Override
        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            objectArray2[0] = objectArray[0];
        }
    }
}

