/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.opengl.GL2;

public class OGLStackHandler {
    private boolean attribsPushed;
    private boolean clientAttribsPushed;
    private boolean modelviewPushed;
    private boolean projectionPushed;
    private boolean texturePushed;

    public void clear() {
        this.attribsPushed = false;
        this.clientAttribsPushed = false;
        this.modelviewPushed = false;
        this.projectionPushed = false;
        this.texturePushed = false;
    }

    public boolean isActive() {
        return this.attribsPushed || this.clientAttribsPushed || this.modelviewPushed || this.projectionPushed || this.texturePushed;
    }

    public void pushAttrib(GL2 gL2, int n) {
        gL2.glPushAttrib(n);
        this.attribsPushed = true;
    }

    public void pushClientAttrib(GL2 gL2, int n) {
        gL2.glPushClientAttrib(n);
        this.clientAttribsPushed = true;
    }

    public void pushModelview(GL2 gL2) {
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        this.modelviewPushed = true;
    }

    public void pushProjection(GL2 gL2) {
        gL2.glMatrixMode(5889);
        gL2.glPushMatrix();
        this.projectionPushed = true;
    }

    public void pushTexture(GL2 gL2) {
        gL2.glMatrixMode(5890);
        gL2.glPushMatrix();
        this.texturePushed = true;
    }

    public void pop(GL2 gL2) {
        if (this.attribsPushed) {
            gL2.glPopAttrib();
            this.attribsPushed = false;
        }
        if (this.clientAttribsPushed) {
            gL2.glPopClientAttrib();
            this.clientAttribsPushed = false;
        }
        if (this.modelviewPushed) {
            gL2.glMatrixMode(5888);
            gL2.glPopMatrix();
            this.modelviewPushed = false;
        }
        if (this.projectionPushed) {
            gL2.glMatrixMode(5889);
            gL2.glPopMatrix();
            this.projectionPushed = false;
        }
        if (this.texturePushed) {
            gL2.glMatrixMode(5890);
            gL2.glPopMatrix();
            this.texturePushed = false;
        }
    }

    public void pushModelviewIdentity(GL2 gL2) {
        gL2.glMatrixMode(5888);
        this.modelviewPushed = true;
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
    }

    public void pushProjectionIdentity(GL2 gL2) {
        gL2.glMatrixMode(5889);
        this.projectionPushed = true;
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
    }

    public void pushTextureIdentity(GL2 gL2) {
        gL2.glMatrixMode(5890);
        this.texturePushed = true;
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
    }
}

