/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.Declutterable;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.TextRenderer;
import gov.nasa.worldwind.util.ClutterFilter;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlacemarkClutterFilter
implements ClutterFilter {
    protected List<Rectangle2D> rectList = new ArrayList<Rectangle2D>();
    protected Map<Rectangle2D, List<Declutterable>> shapeMap = new HashMap<Rectangle2D, List<Declutterable>>();

    @Override
    public void apply(DrawContext drawContext, List<Declutterable> list) {
        for (Declutterable declutterable : list) {
            Rectangle2D rectangle2D = declutterable.getBounds(drawContext);
            Rectangle2D rectangle2D2 = this.intersects(rectangle2D);
            if (rectangle2D2 != null) {
                this.addShape(rectangle2D2, declutterable);
                continue;
            }
            if (rectangle2D == null) continue;
            double d = 2.0 * rectangle2D.getWidth();
            double d2 = 2.0 * rectangle2D.getHeight();
            double d3 = rectangle2D.getX() - 0.5 * rectangle2D.getWidth();
            double d4 = rectangle2D.getY() - 0.5 * rectangle2D.getHeight();
            this.addShape(new Rectangle2D.Double(d3, d4, d, d2), declutterable);
        }
        this.render(drawContext);
        this.clear();
    }

    protected void clear() {
        this.rectList.clear();
        this.shapeMap.clear();
    }

    protected Rectangle2D intersects(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        for (Rectangle2D rectangle2D2 : this.rectList) {
            if (!rectangle2D.intersects(rectangle2D2)) continue;
            return rectangle2D2;
        }
        return null;
    }

    protected void addShape(Rectangle2D rectangle2D, Declutterable declutterable) {
        List<Declutterable> list = this.shapeMap.get(rectangle2D);
        if (list == null) {
            list = new ArrayList<Declutterable>(1);
            this.shapeMap.put(rectangle2D, list);
            this.rectList.add(rectangle2D);
        }
        list.add(declutterable);
    }

    protected void render(DrawContext drawContext) {
        for (Map.Entry<Rectangle2D, List<Declutterable>> entry : this.shapeMap.entrySet()) {
            ArrayList<PointPlacemark> arrayList = null;
            Declutterable declutterable = null;
            for (Declutterable declutterable2 : entry.getValue()) {
                if (declutterable2 instanceof PointPlacemark) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<PointPlacemark>();
                    }
                    arrayList.add((PointPlacemark)((Object)declutterable2));
                    continue;
                }
                if (declutterable != null) continue;
                declutterable = declutterable2;
            }
            if (declutterable != null) {
                drawContext.addOrderedRenderable(declutterable);
            }
            if (arrayList != null && arrayList.size() > 1) {
                double d = -arrayList.size();
                for (PointPlacemark pointPlacemark : arrayList) {
                    drawContext.addOrderedRenderable(new DeclutteredLabel(d += 1.0, pointPlacemark, entry.getKey()));
                }
                continue;
            }
            if (arrayList == null || arrayList.size() != 1) continue;
            drawContext.addOrderedRenderable((OrderedRenderable)arrayList.get(0));
        }
    }

    protected static class DeclutteredLabel
    implements OrderedRenderable {
        protected double angle;
        protected PointPlacemark opm;
        protected Rectangle2D region;
        protected PickSupport pickSupport;

        public DeclutteredLabel(double d, PointPlacemark pointPlacemark, Rectangle2D rectangle2D) {
            this.angle = d;
            this.opm = pointPlacemark;
            this.region = rectangle2D;
        }

        @Override
        public double getDistanceFromEye() {
            return this.opm.getDistanceFromEye();
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
            if (this.opm.isEnableLabelPicking()) {
                if (this.pickSupport == null) {
                    this.pickSupport = new PickSupport();
                }
                this.pickSupport.clearPickList();
                try {
                    this.pickSupport.beginPicking(drawContext);
                    this.render(drawContext);
                }
                finally {
                    this.pickSupport.endPicking(drawContext);
                    this.pickSupport.resolvePick(drawContext, point, this.opm.getPickLayer());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void render(DrawContext drawContext) {
            Font font;
            GL2 gL2 = drawContext.getGL().getGL2();
            PointPlacemarkAttributes pointPlacemarkAttributes = this.opm.getAttributes();
            Font font2 = font = pointPlacemarkAttributes != null ? pointPlacemarkAttributes.getLabelFont() : null;
            if (font == null) {
                font = PointPlacemarkAttributes.DEFAULT_LABEL_FONT;
            }
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            int n = 63749;
            oGLStackHandler.pushAttrib(gL2, n);
            oGLStackHandler.pushProjectionIdentity(gL2);
            try {
                gL2.glDisable(2929);
                gL2.glDepthMask(false);
                gL2.glOrtho(0.0, drawContext.getView().getViewport().width, 0.0, drawContext.getView().getViewport().height, -1.0, 1.0);
                Vec4 vec4 = this.opm.getScreenPoint();
                Rectangle2D rectangle2D = this.opm.getBounds(drawContext);
                double d = -1.0 * rectangle2D.getWidth();
                double d2 = this.angle * rectangle2D.getHeight();
                double d3 = this.region.getX();
                double d4 = this.region.getCenterY();
                Vec4 vec42 = new Vec4(d3 + d, d4 + d2, 0.0);
                oGLStackHandler.pushModelviewIdentity(gL2);
                this.drawDeclutterLabel(drawContext, font, vec42, this.opm.getLabelText());
                if (!drawContext.isPickingMode()) {
                    Vec4 vec43 = new Vec4(vec42.x + rectangle2D.getWidth(), vec42.y, vec42.z);
                    d = vec43.x - vec4.x;
                    d2 = vec43.y() - vec4.y;
                    d = vec42.x - vec4.x;
                    d2 = vec42.y - vec4.y;
                    double d5 = d * d + d2 * d2;
                    double d6 = d * d + d2 * d2;
                    if (d5 < d6) {
                        vec43 = vec42;
                    }
                    this.drawDeclutterLine(drawContext, vec4, vec43);
                }
            }
            finally {
                oGLStackHandler.pop(gL2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void drawDeclutterLabel(DrawContext drawContext, Font font, Vec4 vec4, String string) {
            GL2 gL2 = drawContext.getGL().getGL2();
            if (drawContext.isPickingMode()) {
                Color color = drawContext.getUniquePickColor();
                Object object = this.opm.getDelegateOwner();
                PickedObject pickedObject = new PickedObject(color.getRGB(), object != null ? object : this.opm);
                pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.ID", "gov.nasa.worldwind.avkey.Label");
                this.pickSupport.addPickableObject(pickedObject);
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                gL2.glTranslated(vec4.x, vec4.y, 0.0);
                gL2.glScaled(this.region.getWidth() / 2.0, this.region.getHeight() / 2.0, 1.0);
                drawContext.drawUnitQuad();
            } else {
                TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
                try {
                    PointPlacemark pointPlacemark = this.opm;
                    Color color = Color.WHITE;
                    if (pointPlacemark.isHighlighted() && pointPlacemark.getHighlightAttributes() != null && pointPlacemark.getHighlightAttributes().getLabelColor() != null) {
                        color = pointPlacemark.getHighlightAttributes().getLabelColor();
                    } else if (pointPlacemark.getAttributes() != null && pointPlacemark.getAttributes().getLabelColor() != null) {
                        color = pointPlacemark.getAttributes().getLabelColor();
                    }
                    textRenderer.begin3DRendering();
                    textRenderer.setColor(Color.BLACK);
                    textRenderer.draw3D(string, (float)vec4.x + 1.0f, (float)vec4.y - 1.0f, 0.0f, 1.0f);
                    textRenderer.setColor(color);
                    textRenderer.draw3D(string, (float)vec4.x, (float)vec4.y, 0.0f, 1.0f);
                }
                finally {
                    textRenderer.end3DRendering();
                }
            }
        }

        protected void drawDeclutterLine(DrawContext drawContext, Vec4 vec4, Vec4 vec42) {
            GL2 gL2 = drawContext.getGL().getGL2();
            gL2.glLineWidth(1.0f);
            Color color = Color.WHITE;
            gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
            gL2.glBegin(3);
            gL2.glVertex3d(vec4.x(), vec4.y, vec4.z);
            gL2.glVertex3d(vec42.x, vec42.y(), vec42.z);
            gL2.glEnd();
        }
    }
}

