/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import gov.nasa.worldwind.util.Range;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class PolygonTessellator2 {
    protected GLUtessellator tess;
    protected FloatBuffer vertices = FloatBuffer.allocate(10);
    protected IntBuffer interiorIndices = IntBuffer.allocate(10);
    protected IntBuffer boundaryIndices = IntBuffer.allocate(10);
    protected Range polygonVertexRange = new Range(0, 0);
    protected int vertexStride = 3;
    protected boolean isBoundaryEdge;
    protected double[] coords = new double[6];
    protected double[] offset = new double[3];
    protected double[] clip = new double[]{-1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE};
    protected float[] vertex = new float[3];
    protected int prevClipCode;

    public PolygonTessellator2() {
        this.tess = GLU.gluNewTess();
        TessCallbackAdapter tessCallbackAdapter = new TessCallbackAdapter();
        GLU.gluTessCallback(this.tess, 100106, tessCallbackAdapter);
        GLU.gluTessCallback(this.tess, 100110, tessCallbackAdapter);
        GLU.gluTessCallback(this.tess, 100107, tessCallbackAdapter);
        GLU.gluTessCallback(this.tess, 100108, tessCallbackAdapter);
        GLU.gluTessCallback(this.tess, 100111, tessCallbackAdapter);
    }

    public int getVertexCount() {
        return this.vertices.position() / this.vertexStride;
    }

    public FloatBuffer getVertices(FloatBuffer floatBuffer) {
        int n = this.vertices.limit();
        int n2 = this.vertices.position();
        floatBuffer.put(this.vertices.flip());
        this.vertices.limit(n);
        this.vertices.position(n2);
        return floatBuffer;
    }

    public int getInteriorIndexCount() {
        return this.interiorIndices.position();
    }

    public IntBuffer getInteriorIndices(IntBuffer intBuffer) {
        int n = this.interiorIndices.limit();
        int n2 = this.interiorIndices.position();
        intBuffer.put(this.interiorIndices.flip());
        this.interiorIndices.limit(n);
        this.interiorIndices.position(n2);
        return intBuffer;
    }

    public int getBoundaryIndexCount() {
        return this.boundaryIndices.position();
    }

    public IntBuffer getBoundaryIndices(IntBuffer intBuffer) {
        int n = this.boundaryIndices.limit();
        int n2 = this.boundaryIndices.position();
        intBuffer.put(this.boundaryIndices.flip());
        this.boundaryIndices.limit(n);
        this.boundaryIndices.position(n2);
        return intBuffer;
    }

    public Range getPolygonVertexRange() {
        return this.polygonVertexRange;
    }

    public void reset() {
        this.vertices.clear();
        this.resetIndices();
    }

    public void resetIndices() {
        this.interiorIndices.clear();
        this.boundaryIndices.clear();
    }

    public void setPolygonNormal(double d, double d2, double d3) {
        GLU.gluTessNormal(this.tess, d, d2, d3);
    }

    public void setPolygonClipCoords(double d, double d2, double d3, double d4) {
        this.clip[0] = d;
        this.clip[1] = d2;
        this.clip[2] = d3;
        this.clip[3] = d4;
    }

    public void setVertexStride(int n) {
        this.vertexStride = n;
    }

    public void setVertexOffset(double d, double d2, double d3) {
        this.offset[0] = d;
        this.offset[1] = d2;
        this.offset[2] = d3;
    }

    public void beginPolygon() {
        GLU.gluTessBeginPolygon(this.tess, this);
        this.polygonVertexRange.location = this.vertices.position() / this.vertexStride;
        this.polygonVertexRange.length = 0;
    }

    public void beginContour() {
        GLU.gluTessBeginContour(this.tess);
        this.prevClipCode = -1;
    }

    public void addVertex(double d, double d2, double d3) {
        int n;
        this.coords[0] = d;
        this.coords[1] = d2;
        this.coords[2] = d3;
        int n2 = this.clipCode(d, d2, d3);
        if (this.prevClipCode > 0 && n2 != this.prevClipCode) {
            n = this.putVertex(this.coords, 3);
            GLU.gluTessVertex(this.tess, this.coords, 3, n);
        }
        if (n2 == 0 || n2 != this.prevClipCode) {
            n = this.putVertex(this.coords, 0);
            GLU.gluTessVertex(this.tess, this.coords, 0, n);
        }
        System.arraycopy(this.coords, 0, this.coords, 3, 3);
        this.prevClipCode = n2;
    }

    public void endContour() {
        GLU.gluTessEndContour(this.tess);
    }

    public void endPolygon() {
        GLU.gluTessEndPolygon(this.tess);
        this.polygonVertexRange.length = this.vertices.position() / this.vertexStride;
        this.polygonVertexRange.length -= this.polygonVertexRange.location;
    }

    protected void tessBegin(int n) {
    }

    protected void tessEdgeFlag(boolean bl) {
        this.isBoundaryEdge = bl;
    }

    protected void tessVertex(Object object) {
        int n = (Integer)object;
        this.putInteriorIndex(n);
        if (this.boundaryIndices.position() % 2 == 1) {
            this.putBoundaryIndex(n);
        }
        if (this.isBoundaryEdge) {
            this.putBoundaryIndex(n);
            int n2 = this.interiorIndices.position();
            if (n2 > 0 && n2 % 3 == 0) {
                int n3 = this.interiorIndices.get(n2 - 3);
                this.putBoundaryIndex(n3);
            }
        }
    }

    protected void tessEnd() {
    }

    protected void tessCombine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
        objectArray2[0] = this.putVertex(dArray, 0);
    }

    protected int putVertex(double[] dArray, int n) {
        int n2;
        if (this.vertices.remaining() < this.vertexStride) {
            n2 = this.vertices.capacity() + this.vertices.capacity() / 2;
            FloatBuffer floatBuffer = FloatBuffer.allocate(n2);
            floatBuffer.put(this.vertices.flip());
            this.vertices = floatBuffer;
        }
        n2 = this.vertices.position() / this.vertexStride;
        this.vertex[0] = (float)(dArray[0 + n] + this.offset[0]);
        this.vertex[1] = (float)(dArray[1 + n] + this.offset[1]);
        this.vertex[2] = (float)(dArray[2 + n] + this.offset[2]);
        this.vertices.put(this.vertex, 0, this.vertexStride);
        return n2;
    }

    protected void putInteriorIndex(int n) {
        if (!this.interiorIndices.hasRemaining()) {
            int n2 = this.interiorIndices.capacity() + this.interiorIndices.capacity() / 2;
            IntBuffer intBuffer = IntBuffer.allocate(n2);
            intBuffer.put(this.interiorIndices.flip());
            this.interiorIndices = intBuffer;
        }
        this.interiorIndices.put(n);
    }

    protected void putBoundaryIndex(int n) {
        if (!this.boundaryIndices.hasRemaining()) {
            int n2 = this.boundaryIndices.capacity() + this.boundaryIndices.capacity() / 2;
            IntBuffer intBuffer = IntBuffer.allocate(n2);
            intBuffer.put(this.boundaryIndices.flip());
            this.boundaryIndices = intBuffer;
        }
        this.boundaryIndices.put(n);
    }

    protected int clipCode(double d, double d2, double d3) {
        int n = 0;
        n |= d < this.clip[0] ? 1 : 0;
        n |= d > this.clip[1] ? 16 : 0;
        n |= d2 < this.clip[2] ? 256 : 0;
        return n |= d2 > this.clip[3] ? 4096 : 0;
    }

    protected static class TessCallbackAdapter
    extends GLUtessellatorCallbackAdapter {
        protected TessCallbackAdapter() {
        }

        @Override
        public void beginData(int n, Object object) {
            ((PolygonTessellator2)object).tessBegin(n);
        }

        @Override
        public void edgeFlagData(boolean bl, Object object) {
            ((PolygonTessellator2)object).tessEdgeFlag(bl);
        }

        @Override
        public void vertexData(Object object, Object object2) {
            ((PolygonTessellator2)object2).tessVertex(object);
        }

        @Override
        public void endData(Object object) {
            ((PolygonTessellator2)object).tessEnd();
        }

        @Override
        public void combineData(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2, Object object) {
            ((PolygonTessellator2)object).tessCombine(dArray, objectArray, fArray, objectArray2);
        }
    }
}

