/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

public class PolylineGeneralizer {
    protected int heapSize;
    protected Element[] heap = new Element[10];
    protected int vertexCount;
    protected double[] vertexArea = new double[10];

    public int getVertexCount() {
        return this.vertexCount;
    }

    public double[] getVertexEffectiveArea(double[] dArray) {
        if (dArray == null || dArray.length < this.vertexCount) {
            dArray = new double[this.vertexCount];
        }
        System.arraycopy(this.vertexArea, 0, dArray, 0, this.vertexCount);
        return dArray;
    }

    public void beginPolyline() {
        this.heapSize = 0;
    }

    public void endPolyline() {
        this.computeInitialArea();
        this.heapify();
        this.computeEliminationArea();
    }

    public void reset() {
        this.heapSize = 0;
        this.vertexCount = 0;
    }

    public void addVertex(double d, double d2, double d3) {
        if (this.heapSize == this.heap.length) {
            int n = this.heap.length + this.heap.length / 2;
            Element[] elementArray = new Element[n];
            System.arraycopy(this.heap, 0, elementArray, 0, this.heap.length);
            this.heap = elementArray;
        }
        this.heap[this.heapSize++] = new Element(this.vertexCount++, d, d2, d3);
    }

    protected void computeInitialArea() {
        this.heap[0].area = Double.MAX_VALUE;
        for (int i = 1; i < this.heapSize - 1; ++i) {
            this.heap[i].prev = this.heap[i - 1];
            this.heap[i].next = this.heap[i + 1];
            this.heap[i].area = this.computeEffectiveArea(this.heap[i]);
        }
        this.heap[this.heapSize - 1].area = Double.MAX_VALUE;
    }

    protected void computeEliminationArea() {
        Object object;
        if (this.vertexArea.length < this.vertexCount) {
            object = new double[this.vertexCount];
            System.arraycopy(this.vertexArea, 0, object, 0, this.vertexArea.length);
            this.vertexArea = object;
        }
        double d = 0.0;
        while (true) {
            Element element = this.pop();
            object = element;
            if (element == null) break;
            double d2 = object.area;
            if (d2 < d) {
                d2 = d;
            } else {
                d = d2;
            }
            this.vertexArea[object.ordinal] = d2;
            if (object.prev != null && object.prev.prev != null) {
                object.prev.next = object.next;
                this.updateEffectiveArea(object.prev);
            }
            if (object.next != null && object.next.next != null) {
                object.next.prev = object.prev;
                this.updateEffectiveArea(object.next);
            }
            object.prev = null;
            object.next = null;
        }
    }

    protected double computeEffectiveArea(Element element) {
        Element element2 = element;
        Element element3 = element.prev;
        Element element4 = element.next;
        return 0.5 * Math.abs((element3.x - element2.x) * (element4.y - element2.y) - (element3.y - element2.y) * (element4.x - element2.x));
    }

    protected void updateEffectiveArea(Element element) {
        double d;
        double d2 = element.area;
        element.area = d = this.computeEffectiveArea(element);
        if (d < d2) {
            this.siftUp(element.heapIndex, element);
        } else if (d > d2) {
            this.siftDown(element.heapIndex, element);
        }
    }

    protected void heapify() {
        for (int i = (this.heapSize >>> 1) - 1; i >= 0; --i) {
            this.siftDown(i, this.heap[i]);
        }
    }

    protected Element pop() {
        if (this.heapSize == 0) {
            return null;
        }
        int n = --this.heapSize;
        Element element = this.heap[0];
        Element element2 = this.heap[n];
        this.heap[n] = null;
        if (n != 0) {
            this.siftDown(0, element2);
        }
        return element;
    }

    protected void siftUp(int n, Element element) {
        while (n > 0) {
            int n2 = n - 1 >>> 1;
            Element element2 = this.heap[n2];
            if (element.area >= element2.area) break;
            this.heap[n] = element2;
            element2.heapIndex = n;
            n = n2;
        }
        this.heap[n] = element;
        element.heapIndex = n;
    }

    protected void siftDown(int n, Element element) {
        int n2 = this.heapSize >>> 1;
        while (n < n2) {
            int n3 = (n << 1) + 1;
            Element element2 = this.heap[n3];
            int n4 = n3 + 1;
            if (n4 < this.heapSize && element2.area > this.heap[n4].area) {
                n3 = n4;
                element2 = this.heap[n3];
            }
            if (element.area <= element2.area) break;
            this.heap[n] = element2;
            element2.heapIndex = n;
            n = n3;
        }
        this.heap[n] = element;
        element.heapIndex = n;
    }

    protected static class Element {
        public final int ordinal;
        public final double x;
        public final double y;
        public final double z;
        public double area;
        public int heapIndex;
        public Element prev;
        public Element next;

        public Element(int n, double d, double d2, double d3) {
            this.ordinal = n;
            this.heapIndex = n;
            this.x = d;
            this.y = d2;
            this.z = d3;
        }
    }
}

