/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.FileStoreSource;
import gov.nasa.worldwind.cache.SessionCache;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.retrieve.FileStoreRetriever;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.AbsentResourceList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.SessionCacheRetrievalPostProcessor;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.logging.Level;

public class SessionCacheUtils {
    public static void retrieveSessionData(URL uRL, SessionCache sessionCache, Object object, AbsentResourceList absentResourceList, long l, FileStoreSource fileStoreSource, PropertyChangeListener propertyChangeListener, String string) {
        if (uRL == null) {
            String string2 = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (sessionCache == null) {
            String string3 = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (object == null) {
            String string4 = Logging.getMessage("nullValue.CacheKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
            if (absentResourceList != null) {
                absentResourceList.markResourceAbsent(l);
            }
            return;
        }
        SessionCacheRetrievalPostProcessor sessionCacheRetrievalPostProcessor = new SessionCacheRetrievalPostProcessor(sessionCache, object, absentResourceList, l, fileStoreSource, propertyChangeListener, string);
        sessionCacheRetrievalPostProcessor.setName(uRL.toString());
        Retriever retriever = fileStoreSource != null && fileStoreSource.exists() ? new FileStoreRetriever(fileStoreSource, sessionCacheRetrievalPostProcessor) : URLRetriever.createRetriever(uRL, sessionCacheRetrievalPostProcessor);
        try {
            retriever.call();
        }
        catch (Exception exception) {
            String string5 = Logging.getMessage("layers.TiledImageLayer.ExceptionRetrievingResources", uRL.toString());
            Logging.logger().log(Level.SEVERE, string5, exception);
        }
    }

    public static WMSCapabilities getSessionCapabilities(SessionCache sessionCache, Object object, String string) {
        if (sessionCache == null) {
            String string2 = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.CacheKeyIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Object object2 = sessionCache.get(object);
        return object2 instanceof WMSCapabilities ? (WMSCapabilities)object2 : null;
    }

    public static WMSCapabilities getOrRetrieveSessionCapabilities(URL uRL, SessionCache sessionCache, Object object, AbsentResourceList absentResourceList, long l, FileStoreSource fileStoreSource, PropertyChangeListener propertyChangeListener, String string) {
        if (uRL == null) {
            String string2 = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (sessionCache == null) {
            String string3 = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (object == null) {
            String string4 = Logging.getMessage("nullValue.CacheKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        WMSCapabilities wMSCapabilities = SessionCacheUtils.getSessionCapabilities(sessionCache, object, uRL.toString());
        if (wMSCapabilities != null) {
            return wMSCapabilities;
        }
        SessionCacheUtils.retrieveSessionData(uRL, sessionCache, object, absentResourceList, l, fileStoreSource, propertyChangeListener, string);
        return SessionCacheUtils.getSessionCapabilities(sessionCache, object, uRL.toString());
    }
}

