/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import java.awt.Rectangle;
import java.util.Collection;

public class SurfaceTileDrawContext {
    protected Sector sector;
    protected Rectangle viewport;
    protected Matrix modelview;
    protected Collection<PickedObject> pickCandidates;

    public SurfaceTileDrawContext(Tile tile, Collection<PickedObject> collection) {
        if (tile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (collection == null) {
            String string = Logging.getMessage("nullValue.PickedObjectList");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = tile.getSector();
        this.viewport = new Rectangle(0, 0, tile.getWidth(), tile.getHeight());
        this.modelview = Matrix.fromGeographicToViewport(tile.getSector(), 0, 0, tile.getWidth(), tile.getHeight());
        this.pickCandidates = collection;
    }

    public Sector getSector() {
        return this.sector;
    }

    public Rectangle getViewport() {
        return this.viewport;
    }

    public Matrix getModelviewMatrix() {
        return this.modelview;
    }

    public Matrix getModelviewMatrix(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.modelview.multiply(Matrix.fromTranslation(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0));
    }

    public Collection<PickedObject> getPickCandidates() {
        return this.pickCandidates;
    }

    public void addPickCandidate(PickedObject pickedObject) {
        if (null == pickedObject) {
            String string = Logging.getMessage("nullValue.PickedObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickCandidates.add(pickedObject);
    }
}

