/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.util.packrect.BackingStoreManager;
import com.jogamp.opengl.util.packrect.Rect;
import com.jogamp.opengl.util.packrect.RectanglePacker;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class TextureAtlas {
    protected static final boolean DEFAULT_USE_MIP_MAPS = true;
    protected static final boolean DEFAULT_USE_ANISOTROPY = true;
    protected static final double DEFAULT_MAX_VERTICAL_FRAGMENTATION = 0.7;
    protected int maxWidth;
    protected int maxHeight;
    protected boolean useMipMaps;
    protected boolean useAnisotropy;
    protected boolean evictOldElements;
    protected double maxVerticalFragmentation = 0.7;
    protected RectanglePacker rectPacker;
    protected Map<Object, Entry> entryMap = new HashMap<Object, Entry>();
    protected Rectangle dirtyRect;
    protected Color clearColor = new Color(0, 0, 0, 0);
    protected Graphics2D g;
    protected Object textureKey = new Object();
    protected Queue<Object> disposedTextureKeys = new ArrayDeque<Object>();

    public TextureAtlas(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, true, true);
    }

    public TextureAtlas(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (n < 1) {
            String string = Logging.getMessage("TextureAtlas.InitialWidthInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("TextureAtlas.InitialHeightInvalid", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n3 < n) {
            String string = Logging.getMessage("TextureAtlas.MaxWidthInvalid", n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n4 < n2) {
            String string = Logging.getMessage("TextureAtlas.MaxWidthInvalid", n4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.rectPacker = this.createRectanglePacker(n, n2);
        this.rectPacker.setMaxSize(n3, n4);
        this.maxWidth = n3;
        this.maxHeight = n4;
        this.useMipMaps = bl;
        this.useAnisotropy = bl2;
    }

    protected RectanglePacker createRectanglePacker(int n, int n2) {
        return new RectanglePacker(new AtlasBackingStore(), n, n2);
    }

    public int getWidth() {
        return ((BufferedImage)this.rectPacker.getBackingStore()).getWidth();
    }

    public int getHeight() {
        return ((BufferedImage)this.rectPacker.getBackingStore()).getHeight();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public boolean isUseMipMaps() {
        return this.useMipMaps;
    }

    public boolean isUseAnisotropy() {
        return this.useAnisotropy;
    }

    public boolean isEvictOldElements() {
        return this.evictOldElements;
    }

    public void setEvictOldElements(boolean bl) {
        this.evictOldElements = bl;
    }

    public int getNumElements() {
        return this.entryMap.size();
    }

    public boolean isEmpty() {
        return this.entryMap.isEmpty();
    }

    public void add(Object object, BufferedImage bufferedImage) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage.getWidth() + 2 > this.maxWidth || bufferedImage.getHeight() + 2 > this.maxHeight) {
            String string = Logging.getMessage("TextureAtlas.ImageTooLarge", object);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            this.doAdd(object, bufferedImage);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("TextureAtlas.AtlasIsFull", object);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
    }

    protected void doAdd(Object object, BufferedImage bufferedImage) {
        Entry entry = this.entryMap.remove(object);
        if (entry != null) {
            this.doRemove(entry);
        }
        Rect rect = new Rect(0, 0, bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2, null);
        entry = new Entry(object, rect, 1, 1, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.markUsed(entry);
        this.entryMap.put(object, entry);
        this.rectPacker.add(rect);
        int n = rect.x() + entry.imageOffsetX;
        int n2 = rect.y() + entry.imageOffsetY;
        this.drawImage((BufferedImage)this.rectPacker.getBackingStore(), bufferedImage, n, n2, true);
        this.markDirty(rect.x(), rect.y(), rect.w(), rect.h());
    }

    public boolean remove(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Entry entry = this.entryMap.remove(object);
        if (entry != null) {
            this.doRemove(entry);
        }
        return entry != null;
    }

    protected void doRemove(Entry entry) {
        Rect rect = entry.rect;
        this.rectPacker.remove(rect);
        this.clearRect((BufferedImage)this.rectPacker.getBackingStore(), rect.x(), rect.y(), rect.w(), rect.h());
        this.markDirty(rect.x(), rect.y(), rect.w(), rect.h());
        if ((double)this.rectPacker.verticalFragmentationRatio() > this.maxVerticalFragmentation) {
            this.rectPacker.compact();
        }
    }

    public boolean contains(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.entryMap.containsKey(object);
    }

    public Dimension getSize(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Entry entry = this.entryMap.get(object);
        if (entry == null) {
            return null;
        }
        this.markUsed(entry);
        return new Dimension(entry.imageWidth, entry.imageHeight);
    }

    public TextureCoords getTexCoords(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Entry entry = this.entryMap.get(object);
        if (entry == null) {
            return null;
        }
        this.markUsed(entry);
        float f = entry.rect.x() + entry.imageOffsetX;
        float f2 = entry.rect.y() + entry.imageOffsetY;
        float f3 = f + (float)entry.imageWidth;
        float f4 = f2 + (float)entry.imageHeight;
        BufferedImage bufferedImage = (BufferedImage)this.rectPacker.getBackingStore();
        float f5 = f / (float)bufferedImage.getWidth();
        float f6 = f3 / (float)bufferedImage.getWidth();
        float f7 = f2 / (float)bufferedImage.getHeight();
        float f8 = f4 / (float)bufferedImage.getHeight();
        return new TextureCoords(f5, f8, f6, f7);
    }

    public void clear() {
        this.rectPacker.clear();
        this.entryMap.clear();
        BufferedImage bufferedImage = (BufferedImage)this.rectPacker.getBackingStore();
        this.markDirty(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public boolean bind(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.disposeOldTextures(drawContext);
        Texture texture = this.syncTexture(drawContext);
        if (texture != null) {
            texture.bind(drawContext.getGL());
            return true;
        }
        return false;
    }

    protected BufferedImage createBackingImage(int n, int n2) {
        int n3 = WWMath.powerOfTwoCeiling(n);
        int n4 = WWMath.powerOfTwoCeiling(n2);
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 7);
        this.clearRect(bufferedImage, 0, 0, n3, n4);
        return bufferedImage;
    }

    protected void disposeBackingImage() {
        Object object = this.textureKey;
        this.textureKey = new Object();
        this.disposedTextureKeys.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearRect(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setColor(this.clearColor);
            graphics2D.fillRect(n, n2, n3, n4);
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, boolean bl) {
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage((Image)bufferedImage2, n, n2, null);
            if (bl) {
                graphics2D.drawImage(bufferedImage2, n - 1, n2 - 1, n, n2, 0, 0, 1, 1, null);
                graphics2D.drawImage(bufferedImage2, n, n2 - 1, n + n3, n2, 0, 0, n3, 1, null);
                graphics2D.drawImage(bufferedImage2, n + n3, n2 - 1, n + n3 + 1, n2, n3 - 1, 0, n3, 1, null);
                graphics2D.drawImage(bufferedImage2, n + n3, n2, n + n3 + 1, n2 + n4, n3 - 1, 0, n3, n4, null);
                graphics2D.drawImage(bufferedImage2, n + n3, n2 + n4, n + n3 + 1, n2 + n4 + 1, n3 - 1, n4 - 1, n3, n4, null);
                graphics2D.drawImage(bufferedImage2, n, n2 + n4, n + n3, n2 + n4 + 1, 0, n4 - 1, n3, n4, null);
                graphics2D.drawImage(bufferedImage2, n - 1, n2 + n4, n, n2 + n4 + 1, 0, n4 - 1, 1, n4, null);
                graphics2D.drawImage(bufferedImage2, n - 1, n2, n, n2 + n4, 0, 0, 1, n4, null);
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected void beginMoveEntries(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.g != null) {
            this.g.dispose();
        }
        this.g = bufferedImage2.createGraphics();
        this.g.setComposite(AlphaComposite.Src);
    }

    protected void endMoveEntries(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.g != null) {
            this.g.dispose();
            this.g = null;
        }
        this.markDirty(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
    }

    protected void moveEntry(BufferedImage bufferedImage, Rect rect, BufferedImage bufferedImage2, Rect rect2) {
        this.g.setComposite(AlphaComposite.Src);
        if (bufferedImage == bufferedImage2) {
            this.g.copyArea(rect.x(), rect.y(), rect.w(), rect.h(), rect2.x() - rect.x(), rect2.y() - rect.y());
        } else {
            this.g.drawImage(bufferedImage, rect2.x(), rect2.y(), rect2.x() + rect2.w(), rect2.y() + rect2.h(), rect.x(), rect.y(), rect.x() + rect.w(), rect.y() + rect.h(), null);
        }
    }

    protected void markUsed(Entry entry) {
        entry.lastUsed = System.nanoTime();
    }

    protected boolean removeLeastRecentlyUsedEntry() {
        if (this.entryMap.isEmpty()) {
            return false;
        }
        Entry[] entryArray = new Entry[this.entryMap.size()];
        Arrays.sort(this.entryMap.values().toArray(entryArray));
        Entry entry = entryArray[0];
        this.entryMap.remove(entry.key);
        this.doRemove(entry);
        return true;
    }

    protected Rectangle getDirtyRect() {
        return this.dirtyRect;
    }

    protected void markDirty(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (this.dirtyRect == null) {
            this.dirtyRect = rectangle;
        } else {
            this.dirtyRect.add(rectangle);
        }
    }

    protected void clearDirtyRect() {
        this.dirtyRect = null;
    }

    protected Texture getTexture(DrawContext drawContext) {
        return drawContext.getTextureCache().getTexture(this.textureKey);
    }

    protected void setTexture(DrawContext drawContext, Texture texture) {
        drawContext.getTextureCache().put(this.textureKey, texture);
    }

    protected void disposeOldTextures(DrawContext drawContext) {
        Object object;
        while ((object = this.disposedTextureKeys.poll()) != null) {
            if (!drawContext.getTextureCache().contains(object)) continue;
            drawContext.getTextureCache().remove(object);
        }
    }

    protected Texture syncTexture(DrawContext drawContext) {
        Texture texture = this.getTexture(drawContext);
        if (texture == null) {
            texture = this.makeTextureWithBackingImage(drawContext);
        } else if (this.getDirtyRect() != null) {
            texture = this.updateTextureWithSubImage(drawContext, this.getDirtyRect());
        }
        this.clearDirtyRect();
        return texture;
    }

    protected Texture makeTextureWithBackingImage(DrawContext drawContext) {
        BufferedImage bufferedImage = (BufferedImage)this.rectPacker.getBackingStore();
        Texture texture = AWTTextureIO.newTexture(drawContext.getGL().getGLProfile(), bufferedImage, this.isUseMipMaps());
        this.setTexture(drawContext, texture);
        this.setTextureParameters(drawContext);
        return texture;
    }

    protected Texture updateTextureWithSubImage(DrawContext drawContext, Rectangle rectangle) {
        Texture texture = this.getTexture(drawContext);
        if (texture == null) {
            String string = Logging.getMessage("nullValue.TextureIsNull");
            Logging.logger().warning(string);
            return null;
        }
        if (!this.isUseMipMaps() || texture.isUsingAutoMipmapGeneration()) {
            BufferedImage bufferedImage = (BufferedImage)this.rectPacker.getBackingStore();
            BufferedImage bufferedImage2 = bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            GL gL = drawContext.getGL();
            TextureData textureData = AWTTextureIO.newTextureData(gL.getGLProfile(), bufferedImage2, false);
            texture.updateSubImage(gL, textureData, 0, rectangle.x, rectangle.y);
        } else {
            BufferedImage bufferedImage = (BufferedImage)this.rectPacker.getBackingStore();
            GL gL = drawContext.getGL();
            texture.updateImage(gL, AWTTextureIO.newTextureData(gL.getGLProfile(), bufferedImage, this.isUseMipMaps()));
            this.setTextureParameters(drawContext);
        }
        return texture;
    }

    protected void setTextureParameters(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        if (this.isUseMipMaps() && this.isUseAnisotropy()) {
            double d = drawContext.getGLRuntimeCapabilities().getMaxTextureAnisotropy();
            if (drawContext.getGLRuntimeCapabilities().isUseAnisotropicTextureFilter() && d >= 2.0) {
                gL.glTexParameterf(3553, 34046, (float)d);
            }
        }
    }

    protected class AtlasBackingStore
    implements BackingStoreManager {
        protected AtlasBackingStore() {
        }

        @Override
        public Object allocateBackingStore(int n, int n2) {
            return TextureAtlas.this.createBackingImage(n, n2);
        }

        @Override
        public void deleteBackingStore(Object object) {
            TextureAtlas.this.disposeBackingImage();
        }

        @Override
        public boolean canCompact() {
            return true;
        }

        @Override
        public boolean preExpand(Rect rect, int n) {
            return false;
        }

        @Override
        public boolean additionFailed(Rect rect, int n) {
            if (!TextureAtlas.this.isEvictOldElements() || !TextureAtlas.this.removeLeastRecentlyUsedEntry()) {
                throw new WWRuntimeException(Logging.getMessage("TextureAtlas.AtlasIsFull"));
            }
            return true;
        }

        @Override
        public void beginMovement(Object object, Object object2) {
            TextureAtlas.this.beginMoveEntries((BufferedImage)object, (BufferedImage)object2);
        }

        @Override
        public void move(Object object, Rect rect, Object object2, Rect rect2) {
            TextureAtlas.this.moveEntry((BufferedImage)object, rect, (BufferedImage)object2, rect2);
        }

        @Override
        public void endMovement(Object object, Object object2) {
            TextureAtlas.this.endMoveEntries((BufferedImage)object, (BufferedImage)object2);
        }
    }

    protected static class Entry
    implements Comparable<Entry> {
        public final Object key;
        public Rect rect;
        public int imageOffsetX;
        public int imageOffsetY;
        public int imageWidth;
        public int imageHeight;
        public long lastUsed;

        public Entry(Object object, Rect rect, int n, int n2, int n3, int n4) {
            this.key = object;
            this.rect = rect;
            this.imageOffsetX = n;
            this.imageOffsetY = n2;
            this.imageWidth = n3;
            this.imageHeight = n4;
        }

        @Override
        public int compareTo(Entry entry) {
            if (entry == null) {
                String string = Logging.getMessage("nullValue.EntryIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.lastUsed < entry.lastUsed ? -1 : (this.lastUsed == entry.lastUsed ? 0 : 1);
        }
    }
}

