/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.TaskService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadedTaskService
extends WWObjectImpl
implements TaskService,
Thread.UncaughtExceptionHandler {
    private static final int DEFAULT_CORE_POOL_SIZE = 1;
    private static final int DEFAULT_QUEUE_SIZE = 10;
    private static final String RUNNING_THREAD_NAME_PREFIX = Logging.getMessage("ThreadedTaskService.RunningThreadNamePrefix");
    private static final String IDLE_THREAD_NAME_PREFIX = Logging.getMessage("ThreadedTaskService.IdleThreadNamePrefix");
    private ConcurrentLinkedQueue<Runnable> activeTasks;
    private TaskExecutor executor;

    public ThreadedTaskService() {
        Integer n = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.TaskPoolSize", 1);
        Integer n2 = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.TaskQueueSize", 10);
        this.executor = new TaskExecutor(n, n2);
        this.activeTasks = new ConcurrentLinkedQueue();
    }

    @Override
    public void shutdown(boolean bl) {
        if (bl) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdown();
        }
        this.activeTasks.clear();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        String string = Logging.getMessage("ThreadedTaskService.UncaughtExceptionDuringTask", thread.getName());
        Logging.logger().fine(string);
        Thread.currentThread().getThreadGroup().uncaughtException(thread, throwable);
    }

    @Override
    public synchronized boolean contains(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        return this.activeTasks.contains(runnable) || this.executor.getQueue().contains(runnable);
    }

    @Override
    public synchronized void addTask(Runnable runnable) {
        if (runnable == null) {
            String string = Logging.getMessage("nullValue.RunnableIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (this.activeTasks.contains(runnable) || this.executor.getQueue().contains(runnable)) {
            return;
        }
        this.executor.execute(runnable);
    }

    @Override
    public boolean isFull() {
        return this.executor.getQueue().remainingCapacity() == 0;
    }

    @Override
    public boolean hasActiveTasks() {
        Thread[] threadArray = new Thread[Thread.activeCount()];
        int n = Thread.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            if (!threadArray[i].getName().startsWith(RUNNING_THREAD_NAME_PREFIX)) continue;
            return true;
        }
        return false;
    }

    private class TaskExecutor
    extends ThreadPoolExecutor {
        private static final long THREAD_TIMEOUT = 2L;

        private TaskExecutor(int n, int n2) {
            super(n, n, 2L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(n2), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.setPriority(1);
                    thread.setUncaughtExceptionHandler(ThreadedTaskService.this);
                    return thread;
                }
            }, new ThreadPoolExecutor.DiscardPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    String string = Logging.getMessage("ThreadedTaskService.ResourceRejected", runnable);
                    Logging.logger().fine(string);
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            });
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            if (thread == null) {
                String string = Logging.getMessage("nullValue.ThreadIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            if (runnable == null) {
                String string = Logging.getMessage("nullValue.RunnableIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            if (ThreadedTaskService.this.activeTasks.contains(runnable)) {
                String string = Logging.getMessage("ThreadedTaskService.CancellingDuplicateTask", runnable);
                Logging.logger().finer(string);
                thread.interrupt();
                return;
            }
            ThreadedTaskService.this.activeTasks.add(runnable);
            if (RUNNING_THREAD_NAME_PREFIX != null) {
                thread.setName(RUNNING_THREAD_NAME_PREFIX + runnable);
            }
            thread.setPriority(1);
            thread.setUncaughtExceptionHandler(ThreadedTaskService.this);
            super.beforeExecute(thread, runnable);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            if (runnable == null) {
                String string = Logging.getMessage("nullValue.RunnableIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            super.afterExecute(runnable, throwable);
            ThreadedTaskService.this.activeTasks.remove(runnable);
            if (throwable == null && IDLE_THREAD_NAME_PREFIX != null) {
                Thread.currentThread().setName(IDLE_THREAD_NAME_PREFIX);
            }
        }
    }
}

