/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.render.DrawContext;
import java.util.Random;

public class TimedExpirySupport {
    protected boolean expired = true;
    protected long expiryTime = -1L;
    protected long minExpiryTime;
    protected long maxExpiryTime;
    protected static Random rand = new Random();

    public TimedExpirySupport() {
        this.minExpiryTime = 2000L;
        this.maxExpiryTime = 3000L;
    }

    public TimedExpirySupport(long l, long l2) {
        this.minExpiryTime = Math.max(l, 0L);
        this.maxExpiryTime = Math.max(l2, 0L);
    }

    public void setExpired(boolean bl) {
        this.expired = bl;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    public void setExpiryTime(long l, long l2) {
        this.minExpiryTime = Math.max(l, 0L);
        this.maxExpiryTime = Math.max(l2, 0L);
    }

    public long getMinExpiryTime() {
        return this.minExpiryTime;
    }

    public long getMaxExpiryTime() {
        return this.maxExpiryTime;
    }

    public boolean isExpired(DrawContext drawContext) {
        long l;
        if (this.expired) {
            return true;
        }
        long l2 = l = drawContext != null ? drawContext.getFrameTimeStamp() : System.currentTimeMillis();
        return l >= this.expiryTime;
    }

    public boolean isExpired(long l) {
        return this.expired || this.expiryTime < l;
    }

    public void restart(DrawContext drawContext) {
        if (this.maxExpiryTime == 0L || this.maxExpiryTime < this.minExpiryTime) {
            this.expired = true;
        } else {
            long l = drawContext != null ? drawContext.getFrameTimeStamp() : System.currentTimeMillis();
            this.expiryTime = l + this.minExpiryTime + (long)rand.nextInt((int)(this.maxExpiryTime - this.minExpiryTime));
            this.expired = false;
        }
    }
}

