/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.util.Logging;

public class UnitsFormat
extends AVListImpl {
    public static final String IMPERIAL_SYSTEM = "gov.nasa.worldwind.units.ImperialSystem";
    public static final String METRIC_SYSTEM = "gov.nasa.worldwind.units.MetricSystem";
    public static final String METERS = "UnitsFormat.Meters";
    public static final String KILOMETERS = "UnitsFormat.Kilometers";
    public static final String MILES = "UnitsFormat.Miles";
    public static final String NAUTICAL_MILES = "UnitsFormat.NauticalMiles";
    public static final String YARDS = "UnitsFormat.Yards";
    public static final String FEET = "UnitsFormat.Feet";
    public static final String SQUARE_METERS = "UnitsFormat.SquareMeters";
    public static final String SQUARE_KILOMETERS = "UnitsFormat.SquareKilometers";
    public static final String SQUARE_MILES = "UnitsFormat.SquareMiles";
    public static final String HECTARE = "UnitsFormat.Hectare";
    public static final String ACRE = "UnitsFormat.Acre";
    public static final String SQUARE_YARDS = "UnitsFormat.SquareYards";
    public static final String SQUARE_FEET = "UnitsFormat.SquareFeet";
    public static final String SYMBOL_METERS = "m";
    public static final String SYMBOL_KILOMETERS = "km";
    public static final String SYMBOL_MILES = "miles";
    public static final String SYMBOL_NAUTICAL_MILES = "Nm";
    public static final String SYMBOL_YARDS = "yd";
    public static final String SYMBOL_FEET = "ft";
    public static final String SYMBOL_SQUARE_METERS = "m\u00b2";
    public static final String SYMBOL_SQUARE_KILOMETERS = "km\u00b2";
    public static final String SYMBOL_SQUARE_MILES = "miles\u00b2";
    public static final String SYMBOL_HECTARE = "ha";
    public static final String SYMBOL_ACRE = "acres";
    public static final String SYMBOL_SQUARE_YARDS = "yd\u00b2";
    public static final String SYMBOL_SQUARE_FEET = "ft\u00b2";
    public static final String LABEL_LATITUDE = "UnitsFormat.LatitudeLabel";
    public static final String LABEL_LONGITUDE = "UnitsFormat.LongitudeLabel";
    public static final String LABEL_LATLON_LAT = "UnitsFormat.LatLonLatLabel";
    public static final String LABEL_LATLON_LON = "UnitsFormat.LatLonLonLabel";
    public static final String LABEL_HEADING = "UnitsFormat.HeadingLabel";
    public static final String LABEL_EYE_ALTITUDE = "UnitsFormat.EyeAltitudeLabel";
    public static final String LABEL_PITCH = "UnitsFormat.PitchLabel";
    public static final String LABEL_UTM_ZONE = "UnitsFormat.UTMZoneLabel";
    public static final String LABEL_UTM_EASTING = "UnitsFormat.UTMEastingLabel";
    public static final String LABEL_UTM_NORTHING = "UnitsFormat.UTMNorthingLabel";
    public static final String LABEL_TERRAIN_HEIGHT = "UnitsFormat.TerrainHeightLabel";
    public static final String LABEL_DATUM = "UnitsFormat.DatumLabel";
    public static final String FORMAT_LENGTH = "UnitsFormat.FormatLength";
    public static final String FORMAT_AREA = "UnitsFormat.FormatArea";
    public static final String FORMAT_PITCH = "UnitsFormat.FormatPitch";
    public static final String FORMAT_HEADING = "UnitsFormat.FormatHeading";
    public static final String FORMAT_UTM_NORTHING = "UnitsFormat.FormatUTMNorthing";
    public static final String FORMAT_UTM_EASTING = "UnitsFormat.FormatUTMEasting";
    public static final String FORMAT_EYE_ALTITUDE = "UnitsFormat.FormatEyeAltitude";
    public static final String FORMAT_DECIMAL_DEGREES = "UnitsFormat.FormatDecimalDegrees";
    public static final String FORMAT_TERRAIN_HEIGHT = "UnitsFormat.FormatTerrainHeight";
    protected static final String NL = "\n";
    protected boolean showDMS = false;
    protected String lengthUnits;
    protected String lengthUnitsSymbol;
    protected double lengthUnitsMultiplier;
    protected String areaUnits;
    protected String areaUnitsSymbol;
    protected double areaUnitsMultiplier;
    protected String altitudeUnits;
    protected String altitudeUnitsSymbol;
    protected double altitudeUnitsMultiplier;

    public UnitsFormat() {
        this(KILOMETERS, SQUARE_KILOMETERS, false);
    }

    public UnitsFormat(String string, String string2) {
        this(string, string2, false);
    }

    public UnitsFormat(String string, String string2, boolean bl) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.LengthUnit");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.AreaUnit");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.setDefaultLabels();
        this.setDefaultFormats();
        this.setLengthUnits(string);
        this.setAltitudeUnits(string);
        this.setAreaUnits(string2);
        this.setShowDMS(bl);
    }

    protected void setDefaultLabels() {
        this.setLabel(LABEL_LATITUDE, Logging.getMessage(LABEL_LATITUDE));
        this.setLabel(LABEL_LONGITUDE, Logging.getMessage(LABEL_LONGITUDE));
        this.setLabel(LABEL_LATLON_LAT, Logging.getMessage(LABEL_LATLON_LAT));
        this.setLabel(LABEL_LATLON_LON, Logging.getMessage(LABEL_LATLON_LON));
        this.setLabel(LABEL_HEADING, Logging.getMessage(LABEL_HEADING));
        this.setLabel(LABEL_EYE_ALTITUDE, Logging.getMessage(LABEL_EYE_ALTITUDE));
        this.setLabel(LABEL_PITCH, Logging.getMessage(LABEL_PITCH));
        this.setLabel(LABEL_UTM_ZONE, Logging.getMessage(LABEL_UTM_ZONE));
        this.setLabel(LABEL_UTM_EASTING, Logging.getMessage(LABEL_UTM_EASTING));
        this.setLabel(LABEL_UTM_NORTHING, Logging.getMessage(LABEL_UTM_NORTHING));
        this.setLabel(LABEL_TERRAIN_HEIGHT, Logging.getMessage(LABEL_TERRAIN_HEIGHT));
        this.setLabel(LABEL_DATUM, "Datum:");
    }

    protected void setDefaultFormats() {
        this.setFormat(FORMAT_LENGTH, " %,12.1f %s");
        this.setFormat(FORMAT_AREA, " %,12.1f %s");
        this.setFormat(FORMAT_PITCH, " %9.2f\u00b0");
        this.setFormat(FORMAT_HEADING, " %9.2f\u00b0");
        this.setFormat(FORMAT_UTM_NORTHING, " %,11.1f");
        this.setFormat(FORMAT_UTM_EASTING, " %,11.1f");
        this.setFormat(FORMAT_EYE_ALTITUDE, " %,6d %s");
        this.setFormat(FORMAT_DECIMAL_DEGREES, "%9.4f\u00b0");
        this.setFormat(FORMAT_TERRAIN_HEIGHT, " (ve %3.1f) %,6d %s");
    }

    public void setLabel(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.LabelKey");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.Label");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.setValue(string, string2);
    }

    public String getLabel(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.LabelKey");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getStringValue(string);
    }

    public void setFormat(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FormatKey");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.setValue(string, string2);
    }

    public String getFormat(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FormatKey");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getStringValue(string);
    }

    public boolean isShowDMS() {
        return this.showDMS;
    }

    public void setShowDMS(boolean bl) {
        this.showDMS = bl;
    }

    public String getLengthUnitsSymbol() {
        return this.lengthUnitsSymbol;
    }

    public String getLengthUnits() {
        return this.lengthUnits;
    }

    public void setLengthUnits(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.LengthUnit");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.lengthUnits = string;
        if (string.equals(KILOMETERS)) {
            this.lengthUnitsMultiplier = 0.001;
            this.lengthUnitsSymbol = SYMBOL_KILOMETERS;
        } else if (string.equals(MILES)) {
            this.lengthUnitsMultiplier = 6.21371192E-4;
            this.lengthUnitsSymbol = SYMBOL_MILES;
        } else if (string.equals(NAUTICAL_MILES)) {
            this.lengthUnitsMultiplier = 5.39956803E-4;
            this.lengthUnitsSymbol = SYMBOL_NAUTICAL_MILES;
        } else if (string.equals(YARDS)) {
            this.lengthUnitsMultiplier = 1.0936133;
            this.lengthUnitsSymbol = SYMBOL_YARDS;
        } else if (string.equals(FEET)) {
            this.lengthUnitsMultiplier = 3.280839895;
            this.lengthUnitsSymbol = SYMBOL_FEET;
        } else {
            this.lengthUnitsMultiplier = 1.0;
            this.lengthUnitsSymbol = SYMBOL_METERS;
        }
    }

    public double getLengthUnitsMultiplier() {
        return this.lengthUnitsMultiplier;
    }

    public String getAltitudeUnitsSymbol() {
        return this.altitudeUnitsSymbol;
    }

    public String getAltitudeUnits() {
        return this.altitudeUnits;
    }

    public void setAltitudeUnits(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.AltitudeUnit");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.altitudeUnits = string;
        if (string.equals(KILOMETERS)) {
            this.altitudeUnitsMultiplier = 0.001;
            this.altitudeUnitsSymbol = SYMBOL_KILOMETERS;
        } else if (string.equals(MILES)) {
            this.altitudeUnitsMultiplier = 6.21371192E-4;
            this.altitudeUnitsSymbol = SYMBOL_MILES;
        } else if (string.equals(NAUTICAL_MILES)) {
            this.altitudeUnitsMultiplier = 5.39956803E-4;
            this.altitudeUnitsSymbol = SYMBOL_NAUTICAL_MILES;
        } else if (string.equals(YARDS)) {
            this.altitudeUnitsMultiplier = 1.0936133;
            this.altitudeUnitsSymbol = SYMBOL_YARDS;
        } else if (string.equals(FEET)) {
            this.altitudeUnitsMultiplier = 3.280839895;
            this.altitudeUnitsSymbol = SYMBOL_FEET;
        } else {
            this.altitudeUnitsMultiplier = 1.0;
            this.altitudeUnitsSymbol = SYMBOL_METERS;
        }
    }

    public double getAltitudeUnitsMultiplier() {
        return this.altitudeUnitsMultiplier;
    }

    public String getAreaUnits() {
        return this.areaUnits;
    }

    public void setAreaUnits(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.AreaUnit");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.areaUnits = string;
        if (string.equals(SQUARE_KILOMETERS)) {
            this.areaUnitsMultiplier = 1.0E-6;
            this.areaUnitsSymbol = SYMBOL_SQUARE_KILOMETERS;
        } else if (string.equals(SQUARE_MILES)) {
            this.areaUnitsMultiplier = 3.86102159E-7;
            this.areaUnitsSymbol = SYMBOL_SQUARE_MILES;
        } else if (string.equals(HECTARE)) {
            this.areaUnitsMultiplier = 1.0E-4;
            this.areaUnitsSymbol = SYMBOL_HECTARE;
        } else if (string.equals(ACRE)) {
            this.areaUnitsMultiplier = 2.47105381E-4;
            this.areaUnitsSymbol = SYMBOL_ACRE;
        } else if (string.equals(SQUARE_YARDS)) {
            this.areaUnitsMultiplier = 1.19599005;
            this.areaUnitsSymbol = SYMBOL_SQUARE_YARDS;
        } else if (string.equals(SQUARE_FEET)) {
            this.areaUnitsMultiplier = 10.7639104;
            this.areaUnitsSymbol = SYMBOL_SQUARE_FEET;
        } else {
            this.areaUnitsMultiplier = 1.0;
            this.areaUnitsSymbol = SYMBOL_SQUARE_METERS;
        }
    }

    public double getAreaUnitsMultiplier() {
        return this.areaUnitsMultiplier;
    }

    public String getAreaUnitsSymbol() {
        return this.areaUnitsSymbol;
    }

    public void setUnitsSystem(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.UnitsSystem");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.equals(IMPERIAL_SYSTEM)) {
            this.setLengthUnits(MILES);
            this.setAltitudeUnits(MILES);
            this.setAreaUnits(SQUARE_MILES);
        } else {
            this.setLengthUnits(KILOMETERS);
            this.setAltitudeUnits(KILOMETERS);
            this.setAreaUnits(SQUARE_KILOMETERS);
        }
    }

    public String getLengthUnitsSystem() {
        if (this.getLengthUnits().equals(METERS) || this.getLengthUnits().equals(KILOMETERS)) {
            return METRIC_SYSTEM;
        }
        return IMPERIAL_SYSTEM;
    }

    public String getAreaUnitsSystem() {
        if (this.getAreaUnits().equals(SQUARE_METERS) || this.getAreaUnits().equals(SQUARE_KILOMETERS) || this.getAreaUnits().equals(HECTARE)) {
            return METRIC_SYSTEM;
        }
        return IMPERIAL_SYSTEM;
    }

    public String latitudeNL(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.angleNL(this.getLabel(LABEL_LATITUDE), angle);
    }

    public String latitude(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.angle(this.getLabel(LABEL_LATITUDE), angle);
    }

    public String longitudeNL(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.angleNL(this.getLabel(LABEL_LONGITUDE), angle);
    }

    public String longitude(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.angle(this.getLabel(LABEL_LONGITUDE), angle);
    }

    public String headingNL(Angle angle) {
        return this.angleNL(this.getLabel(LABEL_HEADING), angle);
    }

    public String heading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.angle(this.getLabel(LABEL_HEADING), angle);
    }

    public String headingNL(double d) {
        return this.heading(d) + NL;
    }

    public String heading(double d) {
        return String.format(this.getLabel(LABEL_HEADING) + this.getFormat(FORMAT_HEADING), d);
    }

    public String latLonNL(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.latLon(latLon) + NL;
    }

    public String latLon(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return String.format("%s %s", this.angle(this.getLabel(LABEL_LATLON_LAT), latLon.getLatitude()), this.angle(this.getLabel(LABEL_LATLON_LON), latLon.getLongitude())).trim();
    }

    public String latLon2NL(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.latLon2(latLon) + NL;
    }

    public String latLon2(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.angle("", Angle.fromDegrees(Math.abs(latLon.getLatitude().degrees)));
        String string2 = String.format("%s%s", string, latLon.getLatitude().degrees >= 0.0 ? "N" : "S");
        String string3 = this.angle("", Angle.fromDegrees(Math.abs(latLon.getLongitude().degrees)));
        String string4 = String.format("%s%s", string3, latLon.getLongitude().degrees >= 0.0 ? "E" : "W");
        return String.format("%s %s", string2, string4);
    }

    public String angleNL(String string, Angle angle) {
        if (angle == null) {
            String string2 = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.angle(string, angle) + NL;
    }

    public String angle(String string, Angle angle) {
        if (angle == null) {
            String string2 = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = this.isShowDMS() ? String.format("%s", angle.toFormattedDMSString()).trim() : String.format(this.getFormat(FORMAT_DECIMAL_DEGREES), angle.degrees).trim();
        return string != null ? string + " " + string3 : string3;
    }

    public String eyeAltitudeNL(double d) {
        return this.eyeAltitude(d) + NL;
    }

    public String eyeAltitude(double d) {
        if (this.getFormat(FORMAT_EYE_ALTITUDE).contains("f")) {
            return String.format(this.getLabel(LABEL_EYE_ALTITUDE) + this.getFormat(FORMAT_EYE_ALTITUDE), d * this.getAltitudeUnitsMultiplier(), this.getAltitudeUnitsSymbol());
        }
        return String.format(this.getLabel(LABEL_EYE_ALTITUDE) + this.getFormat(FORMAT_EYE_ALTITUDE), (int)Math.round(d * this.getAltitudeUnitsMultiplier()), this.getAltitudeUnitsSymbol());
    }

    public String pitchNL(double d) {
        return this.pitch(d) + NL;
    }

    public String pitch(double d) {
        return String.format(this.getLabel(LABEL_PITCH) + this.getFormat(FORMAT_PITCH), d);
    }

    public String utmZoneNL(int n) {
        return this.utmZone(n) + NL;
    }

    public String utmZone(int n) {
        return String.format(this.getLabel(LABEL_UTM_ZONE) + " %2d", n);
    }

    public String utmNorthingNL(double d) {
        return this.utmNorthing(d) + NL;
    }

    public String utmNorthing(double d) {
        return String.format(this.getLabel(LABEL_UTM_NORTHING) + this.getFormat(FORMAT_UTM_NORTHING), d);
    }

    public String utmEastingNL(double d) {
        return this.utmEasting(d) + NL;
    }

    public String utmEasting(double d) {
        return String.format(this.getLabel(LABEL_UTM_EASTING) + this.getFormat(FORMAT_UTM_EASTING), d);
    }

    public String terrainHeightNL(double d, double d2) {
        return this.terrainHeight(d, d2) + NL;
    }

    public String terrainHeight(double d, double d2) {
        String string;
        double d3;
        if (this.getLengthUnitsSystem().equals(METRIC_SYSTEM)) {
            d3 = 1.0;
            string = SYMBOL_METERS;
        } else {
            d3 = 3.280839895;
            string = SYMBOL_FEET;
        }
        return String.format(this.getLabel(LABEL_TERRAIN_HEIGHT) + this.getFormat(FORMAT_TERRAIN_HEIGHT), d2, (int)Math.round(d / d2 * d3), string);
    }

    public String lengthNL(String string, double d) {
        return this.length(string, d) + NL;
    }

    public String length(String string, double d) {
        String string2 = String.format(this.getFormat(FORMAT_LENGTH), d * this.getLengthUnitsMultiplier(), this.getLengthUnitsSymbol()).trim();
        return string != null ? string + " " + string2 : string2;
    }

    public String areaNL(String string, double d) {
        return this.area(string, d) + NL;
    }

    public String area(String string, double d) {
        String string2 = String.format(this.getFormat(FORMAT_AREA), d * this.getAreaUnitsMultiplier(), this.getAreaUnitsSymbol()).trim();
        return string != null ? string + " " + string2 : string2;
    }
}

