/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.CompoundVecBuffer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.WWBufferUtil;
import java.nio.ByteBuffer;

public class VecBufferBlocks
extends CompoundVecBuffer {
    protected int coordsPerVec;
    protected String dataType;
    protected ByteBuffer buffer;

    public VecBufferBlocks(int n, String string, ByteBuffer byteBuffer, int n2) {
        super(n2);
        if (n < 1) {
            String string2 = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.DataTypeIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (byteBuffer == null) {
            String string4 = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.coordsPerVec = n;
        this.dataType = string;
        this.buffer = byteBuffer;
    }

    public VecBufferBlocks(int n, String string, ByteBuffer byteBuffer) {
        this(n, string, byteBuffer, 16);
    }

    protected VecBufferBlocks(VecBufferBlocks vecBufferBlocks, int n, int n2) {
        super(vecBufferBlocks, n, n2);
        this.coordsPerVec = vecBufferBlocks.coordsPerVec;
        this.dataType = vecBufferBlocks.dataType;
        this.buffer = vecBufferBlocks.buffer;
    }

    protected VecBufferBlocks(VecBufferBlocks vecBufferBlocks, int[] nArray, int n, int n2) {
        super(vecBufferBlocks, nArray, n, n2);
        this.coordsPerVec = vecBufferBlocks.coordsPerVec;
        this.dataType = vecBufferBlocks.dataType;
        this.buffer = vecBufferBlocks.buffer;
    }

    @Override
    public int subBufferSize(int n) {
        if (n < 0 || n >= this.count) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.lengths.get(n) / WWBufferUtil.sizeOfPrimitiveType(this.dataType) / this.coordsPerVec;
    }

    @Override
    public int getCoordsPerVec() {
        return this.coordsPerVec;
    }

    public String getDataType() {
        return this.dataType;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int addBlock(int n, int n2) {
        if (n2 < 0 || n2 > this.buffer.capacity()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n > n2) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.addSubBuffer(n, n2 - n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VecBuffer createSubBuffer(int n, int n2) {
        VecBuffer vecBuffer;
        int n3 = this.buffer.limit();
        int n4 = this.buffer.position();
        try {
            this.buffer.limit(n + n2);
            this.buffer.position(n);
            BufferWrapper bufferWrapper = BufferWrapper.wrap(this.buffer, this.dataType);
            vecBuffer = new VecBuffer(this.coordsPerVec, bufferWrapper);
        }
        finally {
            this.buffer.limit(n3);
            this.buffer.position(n4);
        }
        return vecBuffer;
    }

    @Override
    protected CompoundVecBuffer createSlice(int[] nArray, int n, int n2) {
        return new VecBufferBlocks(this, nArray, n, n2);
    }

    @Override
    protected CompoundVecBuffer createSlice(int n, int n2) {
        return new VecBufferBlocks(this, n, n2);
    }
}

