/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.combine;

import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.ContourList;
import gov.nasa.worldwind.util.GLUTessellatorSupport;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.List;

public class CombineContext
implements Disposable {
    protected Globe globe;
    protected Sector sector = Sector.FULL_SPHERE;
    protected double resolution;
    protected GLUtessellator tess;
    protected ContourList contours = new ContourList();
    protected ArrayList<LatLon> currentContour;
    protected boolean isBoundingSectorMode;
    protected ArrayList<Sector> boundingSectors = new ArrayList();

    public CombineContext(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TessCallbackAdapter tessCallbackAdapter = new TessCallbackAdapter(this);
        GLUtessellator gLUtessellator = GLU.gluNewTess();
        GLU.gluTessCallback(gLUtessellator, 100100, tessCallbackAdapter);
        GLU.gluTessCallback(gLUtessellator, 100101, tessCallbackAdapter);
        GLU.gluTessCallback(gLUtessellator, 100102, tessCallbackAdapter);
        GLU.gluTessCallback(gLUtessellator, 100105, tessCallbackAdapter);
        GLU.gluTessCallback(gLUtessellator, 100103, tessCallbackAdapter);
        GLU.gluTessProperty(gLUtessellator, 100141, 1.0);
        GLU.gluTessNormal(gLUtessellator, 0.0, 0.0, 1.0);
        this.globe = globe;
        this.resolution = d;
        this.tess = gLUtessellator;
    }

    @Override
    public void dispose() {
        GLU.gluDeleteTess(this.tess);
        this.tess = null;
    }

    public Globe getGlobe() {
        return this.globe;
    }

    public void setGlobe(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.globe = globe;
    }

    public Sector getSector() {
        return this.sector;
    }

    public void setSector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setResolution(double d) {
        this.resolution = d;
    }

    public GLUtessellator getTessellator() {
        return this.tess;
    }

    public ContourList getContours() {
        return this.contours;
    }

    public void addContour(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.contours.addContour(iterable);
    }

    public void removeAllContours() {
        this.contours.removeAllContours();
    }

    protected void tessBegin(int n) {
        this.currentContour = new ArrayList();
    }

    protected void tessVertex(Object object) {
        double[] dArray = (double[])object;
        double d = Angle.normalizedDegreesLatitude(dArray[1]);
        double d2 = Angle.normalizedDegreesLongitude(dArray[0]);
        this.currentContour.add(LatLon.fromDegrees(d, d2));
    }

    protected void tessEnd() {
        this.addContour(this.currentContour);
        this.currentContour = null;
    }

    protected void tessCombine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
        objectArray2[0] = dArray;
    }

    protected void tessError(int n) {
        String string = GLUTessellatorSupport.convertGLUTessErrorToString(n);
        String string2 = Logging.getMessage("generic.ExceptionWhileTessellating", string);
        Logging.logger().severe(string2);
    }

    public boolean isBoundingSectorMode() {
        return this.isBoundingSectorMode;
    }

    public void setBoundingSectorMode(boolean bl) {
        this.isBoundingSectorMode = bl;
    }

    public List<Sector> getBoundingSectors() {
        return this.boundingSectors;
    }

    public void addBoundingSector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundingSectors.add(sector);
    }

    public void removeAllBoundingSectors() {
        this.boundingSectors.clear();
    }

    protected static class TessCallbackAdapter
    extends GLUtessellatorCallbackAdapter {
        protected CombineContext cc;

        public TessCallbackAdapter(CombineContext combineContext) {
            this.cc = combineContext;
        }

        @Override
        public void begin(int n) {
            this.cc.tessBegin(n);
        }

        @Override
        public void vertex(Object object) {
            this.cc.tessVertex(object);
        }

        @Override
        public void end() {
            this.cc.tessEnd();
        }

        @Override
        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            this.cc.tessCombine(dArray, objectArray, fArray, objectArray2);
        }

        @Override
        public void error(int n) {
            this.cc.tessError(n);
        }
    }
}

