/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.combine;

import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.ContourList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.combine.Combinable;
import gov.nasa.worldwind.util.combine.CombineContext;
import java.util.Arrays;

public class ShapeCombiner {
    protected Globe globe;
    protected double resolution;

    public ShapeCombiner(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.globe = globe;
        this.resolution = d;
    }

    public Globe getGlobe() {
        return this.globe;
    }

    public double getResolution() {
        return this.resolution;
    }

    public ContourList union(Combinable ... combinableArray) {
        if (combinableArray == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        CombineContext combineContext = this.createContext();
        try {
            this.union(combineContext, combinableArray);
        }
        finally {
            combineContext.dispose();
        }
        return combineContext.getContours();
    }

    public ContourList intersection(Combinable ... combinableArray) {
        if (combinableArray == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        CombineContext combineContext = this.createContext();
        try {
            if (combinableArray.length == 1) {
                this.union(combineContext, combinableArray);
            } else if (combinableArray.length > 1) {
                this.intersection(combineContext, combinableArray);
            }
        }
        finally {
            combineContext.dispose();
        }
        return combineContext.getContours();
    }

    public ContourList difference(Combinable ... combinableArray) {
        if (combinableArray == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        CombineContext combineContext = this.createContext();
        try {
            if (combinableArray.length == 1) {
                this.union(combineContext, combinableArray);
            } else if (combinableArray.length > 1) {
                this.difference(combineContext, combinableArray);
            }
        }
        finally {
            combineContext.dispose();
        }
        return combineContext.getContours();
    }

    protected CombineContext createContext() {
        return new CombineContext(this.globe, this.resolution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void union(CombineContext combineContext, Combinable ... combinableArray) {
        GLUtessellator gLUtessellator = combineContext.getTessellator();
        try {
            GLU.gluTessProperty(gLUtessellator, 100140, 100131.0);
            GLU.gluTessBeginPolygon(gLUtessellator, null);
            for (Combinable combinable : combinableArray) {
                combinable.combine(combineContext);
            }
        }
        finally {
            GLU.gluTessEndPolygon(gLUtessellator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reverseUnion(CombineContext combineContext, Combinable ... combinableArray) {
        GLUtessellator gLUtessellator = combineContext.getTessellator();
        try {
            GLU.gluTessProperty(gLUtessellator, 100140, 100131.0);
            GLU.gluTessNormal(gLUtessellator, 0.0, 0.0, -1.0);
            GLU.gluTessBeginPolygon(gLUtessellator, null);
            for (Combinable combinable : combinableArray) {
                combinable.combine(combineContext);
            }
        }
        finally {
            GLU.gluTessEndPolygon(gLUtessellator);
        }
    }

    protected void intersection(CombineContext combineContext, Combinable ... combinableArray) {
        this.assembleBoundingSectors(combineContext, combinableArray);
        Sector sector = Sector.intersection(combineContext.getBoundingSectors());
        if (sector == null) {
            return;
        }
        combineContext.setSector(sector);
        this.intersection(combineContext, combinableArray[0], combinableArray[1]);
        if (combinableArray.length > 2) {
            for (int i = 2; i < combinableArray.length; ++i) {
                ContourList contourList = new ContourList(combineContext.getContours());
                combineContext.removeAllContours();
                this.intersection(combineContext, (Combinable)contourList, combinableArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void intersection(CombineContext combineContext, Combinable combinable, Combinable combinable2) {
        GLUtessellator gLUtessellator = combineContext.getTessellator();
        try {
            GLU.gluTessProperty(gLUtessellator, 100140, 100134.0);
            GLU.gluTessBeginPolygon(gLUtessellator, null);
            combinable.combine(combineContext);
            combinable2.combine(combineContext);
        }
        finally {
            GLU.gluTessEndPolygon(gLUtessellator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void difference(CombineContext combineContext, Combinable ... combinableArray) {
        Combinable combinable = combinableArray[0];
        this.assembleBoundingSectors(combineContext, combinable);
        if (combineContext.getBoundingSectors().size() == 0) {
            return;
        }
        combineContext.setSector(combineContext.getBoundingSectors().get(0));
        this.reverseUnion(combineContext, Arrays.copyOfRange(combinableArray, 1, combinableArray.length));
        ContourList contourList = new ContourList(combineContext.getContours());
        combineContext.removeAllContours();
        GLUtessellator gLUtessellator = combineContext.getTessellator();
        try {
            GLU.gluTessProperty(gLUtessellator, 100140, 100132.0);
            GLU.gluTessNormal(gLUtessellator, 0.0, 0.0, 1.0);
            GLU.gluTessBeginPolygon(gLUtessellator, null);
            combinable.combine(combineContext);
            contourList.combine(combineContext);
        }
        finally {
            GLU.gluTessEndPolygon(gLUtessellator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assembleBoundingSectors(CombineContext combineContext, Combinable ... combinableArray) {
        try {
            combineContext.setBoundingSectorMode(true);
            for (Combinable combinable : combinableArray) {
                combinable.combine(combineContext);
            }
        }
        finally {
            combineContext.setBoundingSectorMode(false);
        }
    }
}

