/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.measure;

import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.measure.MeasureTool;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MeasureToolController
extends MouseAdapter
implements MouseListener,
MouseMotionListener,
SelectListener,
PositionListener,
RenderingListener {
    protected MeasureTool measureTool;
    protected boolean armed = false;
    protected boolean active = false;
    protected boolean moving = false;
    protected boolean useRubberBand = true;
    protected boolean freeHand = false;
    protected double freeHandMinSpacing = 100.0;
    protected MeasureTool.ControlPoint rubberBandTarget;
    protected MeasureTool.ControlPoint movingTarget;
    protected MeasureTool.ControlPoint lastPickedObject;
    protected BasicDragger dragger;

    public void setMeasureTool(MeasureTool measureTool) {
        if (measureTool == null) {
            String string = Logging.getMessage("nullValue.MeasureToolIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.measureTool = measureTool;
    }

    public MeasureTool getMeasureTool() {
        return this.measureTool;
    }

    public boolean isUseRubberBand() {
        return this.useRubberBand;
    }

    public void setUseRubberBand(boolean bl) {
        this.useRubberBand = bl;
    }

    public boolean isFreeHand() {
        return this.freeHand;
    }

    public void setFreeHand(boolean bl) {
        this.freeHand = bl;
    }

    public double getFreeHandMinSpacing() {
        return this.freeHandMinSpacing;
    }

    public void setFreeHandMinSpacing(double d) {
        this.freeHandMinSpacing = d;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean bl) {
        if (this.armed != bl) {
            this.armed = bl;
            this.measureTool.firePropertyChange("MeasureTool.Armed", !bl, bl);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isMoving() {
        return this.moving;
    }

    protected void setMoving(boolean bl) {
        this.moving = bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isArmed() && this.isUseRubberBand() && mouseEvent.getButton() == 1) {
            if ((mouseEvent.getModifiersEx() & 0x400) != 0 && !mouseEvent.isControlDown()) {
                this.setActive(true);
                if (this.measureTool.addControlPoint() != null) {
                    if (this.measureTool.getControlPoints().size() == 1) {
                        this.measureTool.addControlPoint();
                    }
                    if (this.measureTool.isRegularShape()) {
                        String string = this.measureTool.getShapeInitialControl(this.measureTool.getWwd().getCurrentPosition());
                        this.rubberBandTarget = this.measureTool.getControlPoint(string);
                    } else {
                        this.rubberBandTarget = (MeasureTool.ControlPoint)this.measureTool.getControlPoints().get(this.measureTool.getControlPoints().size() - 1);
                    }
                    this.measureTool.firePropertyChange("MeasureTool.RubberBandStart", null, null);
                }
            }
            mouseEvent.consume();
        } else if (!this.isArmed() && mouseEvent.getButton() == 1 && mouseEvent.isAltDown()) {
            if (!this.measureTool.isRegularShape()) {
                this.setMoving(true);
                this.movingTarget = this.lastPickedObject;
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isArmed() && this.isUseRubberBand() && mouseEvent.getButton() == 1) {
            if (this.measureTool.getPositions().size() == 1) {
                this.measureTool.removeControlPoint();
            }
            this.setActive(false);
            this.rubberBandTarget = null;
            this.autoDisarm();
            mouseEvent.consume();
            this.measureTool.firePropertyChange("MeasureTool.RubberBandStop", null, null);
        } else if (this.isMoving() && mouseEvent.getButton() == 1) {
            this.setMoving(false);
            this.movingTarget = null;
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.measureTool == null) {
            return;
        }
        if (this.isArmed() && mouseEvent.getButton() == 1) {
            if (mouseEvent.isControlDown()) {
                this.measureTool.removeControlPoint();
            } else if (!this.isUseRubberBand() && this.measureTool.addControlPoint() != null) {
                this.autoDisarm();
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.measureTool == null) {
            return;
        }
        if (this.isActive() && this.isArmed() && (mouseEvent.getModifiersEx() & 0x400) != 0) {
            mouseEvent.consume();
        } else if (!this.isArmed() && this.isMoving() && (mouseEvent.getModifiersEx() & 0x400) != 0 && mouseEvent.isAltDown()) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void moved(PositionEvent positionEvent) {
        if (this.measureTool == null || !this.active && !this.moving) {
            return;
        }
        this.doMoved(positionEvent);
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        PickedObjectList pickedObjectList;
        if (this.measureTool == null || this.isArmed() && this.isUseRubberBand() || this.isMoving()) {
            return;
        }
        if (this.dragger == null) {
            this.dragger = new BasicDragger(this.measureTool.getWwd());
        }
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
            this.highlight(selectEvent.getTopObject());
            this.measureTool.getWwd().redraw();
        }
        this.doSelected(selectEvent);
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = this.measureTool.getWwd().getObjectsAtCurrentPosition()) != null) {
            this.highlight(pickedObjectList.getTopObject());
            this.measureTool.getWwd().redraw();
        }
    }

    @Override
    public void stageChanged(RenderingEvent renderingEvent) {
        if (this.measureTool == null) {
            return;
        }
        if (renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.AfterBufferSwap")) {
            this.measureTool.firePropertyChange("MeasureTool.MetricChanged", null, null);
        }
    }

    protected void doMoved(PositionEvent positionEvent) {
        if (this.active && this.rubberBandTarget != null && this.measureTool.getWwd().getObjectsAtCurrentPosition() != null && this.measureTool.getWwd().getObjectsAtCurrentPosition().getTerrainObject() != null) {
            if (!this.isFreeHand() || !this.measureTool.getMeasureShapeType().equals("MeasureTool.ShapePath") && !this.measureTool.getMeasureShapeType().equals("MeasureTool.ShapePolygon")) {
                Position position = this.rubberBandTarget.getPosition();
                PickedObjectList pickedObjectList = this.measureTool.getWwd().getObjectsAtCurrentPosition();
                PickedObject pickedObject = pickedObjectList.getTerrainObject();
                this.rubberBandTarget.setPosition(new Position(pickedObject.getPosition(), 0.0));
                this.measureTool.moveControlPoint(this.rubberBandTarget);
                this.measureTool.firePropertyChange("MeasureTool.ReplacePosition", position, this.rubberBandTarget.getPosition());
                this.measureTool.getWwd().redraw();
            } else {
                Position position = this.rubberBandTarget.getPosition();
                Position position2 = this.measureTool.getWwd().getCurrentPosition();
                double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)position2).radians * this.measureTool.getWwd().getModel().getGlobe().getRadius();
                if (d >= this.freeHandMinSpacing && this.measureTool.addControlPoint() != null) {
                    this.rubberBandTarget = (MeasureTool.ControlPoint)this.getMeasureTool().getControlPoints().get(this.getMeasureTool().getControlPoints().size() - 1);
                }
            }
        } else if (this.moving && this.movingTarget != null && this.measureTool.getWwd().getCurrentPosition() != null) {
            Position position = this.movingTarget.getPosition();
            Position position3 = this.measureTool.getWwd().getCurrentPosition();
            this.moveToPosition(position, position3);
            if (this.measureTool.isShowAnnotation()) {
                this.measureTool.updateAnnotation(this.movingTarget.getPosition());
            }
            this.measureTool.getWwd().redraw();
        }
    }

    protected void moveToPosition(Position position, Position position2) {
        Angle angle = LatLon.greatCircleDistance(position, position2);
        Angle angle2 = LatLon.greatCircleAzimuth(position, position2);
        this.measureTool.moveMeasureShape(angle2, angle);
        this.measureTool.firePropertyChange("MeasureTool.ReplacePosition", position, position2);
    }

    protected void doSelected(SelectEvent selectEvent) {
        if (this.movingTarget != null) {
            return;
        }
        if (!selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag") && !selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            return;
        }
        if (selectEvent.getTopObject() == null || !(selectEvent.getTopObject() instanceof MeasureTool.ControlPoint) || ((MeasureTool.ControlPoint)selectEvent.getTopObject()).getParent() != this.measureTool) {
            return;
        }
        this.dragSelected(selectEvent);
    }

    protected void dragSelected(SelectEvent selectEvent) {
        MeasureTool.ControlPoint controlPoint = (MeasureTool.ControlPoint)selectEvent.getTopObject();
        LatLon latLon = controlPoint.getPosition();
        if (controlPoint.getValue("MeasureTool.ControlTypeLocationIndex") != null) {
            latLon = this.measureTool.getPositions().get((Integer)controlPoint.getValue("MeasureTool.ControlTypeLocationIndex"));
        }
        this.dragger.selected(selectEvent);
        this.measureTool.moveControlPoint(controlPoint);
        if (this.measureTool.isShowAnnotation()) {
            this.measureTool.updateAnnotation(controlPoint.getPosition());
        }
        this.measureTool.firePropertyChange("MeasureTool.ReplacePosition", latLon, controlPoint.getPosition());
        this.measureTool.getWwd().redraw();
    }

    protected void highlight(Object object) {
        if (this.lastPickedObject == object) {
            return;
        }
        if (this.lastPickedObject != null) {
            this.lastPickedObject.getAttributes().setHighlighted(false);
            this.lastPickedObject.getAttributes().setBackgroundColor(null);
            this.lastPickedObject = null;
            if (this.measureTool.isShowAnnotation()) {
                this.measureTool.updateAnnotation(null);
            }
            this.setCursor(null);
        }
        if (this.lastPickedObject == null && object instanceof MeasureTool.ControlPoint && ((MeasureTool.ControlPoint)object).getParent() == this.measureTool) {
            this.lastPickedObject = (MeasureTool.ControlPoint)object;
            this.lastPickedObject.getAttributes().setHighlighted(true);
            this.lastPickedObject.getAttributes().setBackgroundColor(this.lastPickedObject.getAttributes().getTextColor());
            if (this.measureTool.isShowAnnotation()) {
                this.measureTool.updateAnnotation(this.lastPickedObject.getPosition());
            }
            this.setCursor(this.lastPickedObject);
        }
    }

    protected void setCursor(MeasureTool.ControlPoint controlPoint) {
        if (controlPoint == null) {
            this.setComponentCursor(null);
        } else if (this.measureTool.isRegularShape()) {
            if (this.measureTool.isCornerControl(controlPoint)) {
                Angle angle = LatLon.greatCircleAzimuth(controlPoint.getPosition(), this.measureTool.getCenterPosition());
                angle = angle.subtract(this.measureTool.getWwd().getView().getHeading());
                this.setComponentCursor(this.selectResizeCursor(angle));
            } else if (this.measureTool.isCenterControl(controlPoint)) {
                this.setComponentCursor(Cursor.getPredefinedCursor(13));
            }
        } else {
            this.setComponentCursor(Cursor.getPredefinedCursor(13));
        }
    }

    protected Cursor selectResizeCursor(Angle angle) {
        while (angle.degrees < 0.0) {
            angle = angle.addDegrees(360.0);
        }
        if (angle.degrees < 22.5) {
            return Cursor.getPredefinedCursor(8);
        }
        if (angle.degrees < 67.5) {
            return Cursor.getPredefinedCursor(7);
        }
        if (angle.degrees < 112.5) {
            return Cursor.getPredefinedCursor(11);
        }
        if (angle.degrees < 157.5) {
            return Cursor.getPredefinedCursor(5);
        }
        if (angle.degrees < 202.5) {
            return Cursor.getPredefinedCursor(9);
        }
        if (angle.degrees < 247.5) {
            return Cursor.getPredefinedCursor(4);
        }
        if (angle.degrees < 292.5) {
            return Cursor.getPredefinedCursor(10);
        }
        if (angle.degrees < 337.5) {
            return Cursor.getPredefinedCursor(6);
        }
        return Cursor.getPredefinedCursor(8);
    }

    protected void setComponentCursor(Cursor cursor) {
        ((Component)((Object)this.measureTool.getWwd())).setCursor(cursor != null ? cursor : Cursor.getDefaultCursor());
    }

    protected void autoDisarm() {
        if ((this.measureTool.isRegularShape() || this.measureTool.getMeasureShapeType().equals("MeasureTool.ShapeLine")) && this.measureTool.getControlPoints().size() > 1) {
            this.setArmed(false);
        }
    }
}

