/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.xml;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class StringListXMLEventParser
extends AbstractXMLEventParser
implements Iterable<String> {
    protected QName elementName;
    protected List<String> strings = new ArrayList<String>();

    public StringListXMLEventParser() {
    }

    public StringListXMLEventParser(String string) {
        super(string);
    }

    public StringListXMLEventParser(String string, QName qName) {
        super(string);
        this.elementName = qName;
    }

    @Override
    public XMLEventParser newInstance() throws Exception {
        StringListXMLEventParser stringListXMLEventParser = (StringListXMLEventParser)super.newInstance();
        if (stringListXMLEventParser != null) {
            stringListXMLEventParser.elementName = this.elementName;
        }
        return stringListXMLEventParser;
    }

    @Override
    public Object parse(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        this.strings.clear();
        return super.parse(xMLEventParserContext, xMLEvent, objectArray);
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        String string;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.elementName) && !WWUtil.isEmpty(string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]))) {
            this.addString(string);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.strings.iterator();
    }

    public List<String> getStrings() {
        return this.strings;
    }

    protected void addString(String string) {
        this.strings.add(string);
    }
}

