/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.animation.Animator;
import gov.nasa.worldwind.awt.ViewInputHandler;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.view.ViewPropertyLimits;
import gov.nasa.worldwind.view.ViewUtil;
import java.awt.Rectangle;

public class BasicView
extends WWObjectImpl
implements View {
    protected Angle fieldOfView = Angle.fromDegrees(45.0);
    protected double nearClipDistance = 1.0;
    protected double farClipDistance = 1000.0;
    protected Matrix modelview = Matrix.IDENTITY;
    protected Matrix modelviewInv = Matrix.IDENTITY;
    protected Matrix projection = Matrix.IDENTITY;
    protected Rectangle viewport = new Rectangle();
    protected Frustum frustum = new Frustum();
    protected Frustum lastFrustumInModelCoords = null;
    protected ViewPropertyLimits viewLimits;
    protected DrawContext dc;
    protected boolean detectCollisions = true;
    protected boolean hadCollisions;
    protected ViewInputHandler viewInputHandler;
    protected Globe globe;
    protected Position eyePosition = Position.ZERO;
    protected double horizonDistance;
    protected Angle roll = Angle.fromDegrees(0.0);
    protected Angle pitch = Angle.fromDegrees(0.0);
    protected Angle heading = Angle.fromDegrees(0.0);
    protected Position lastEyePosition = null;
    protected Vec4 lastEyePoint = null;
    protected Vec4 lastUpVector = null;
    protected Vec4 lastForwardVector = null;
    protected long viewStateID;
    protected static final double MINIMUM_NEAR_DISTANCE = 1.0;
    protected static final double MINIMUM_FAR_DISTANCE = 1000.0;
    protected static final double DEFAULT_DEPTH_RESOLUTION = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.DepthResolution", 3.0);
    protected static final double COLLISION_THRESHOLD = 10.0;
    protected static final int COLLISION_NUM_ITERATIONS = 4;

    @Override
    public Globe getGlobe() {
        return this.globe;
    }

    public void setGlobe(Globe globe) {
        this.globe = globe;
    }

    public DrawContext getDC() {
        return this.dc;
    }

    @Override
    public ViewInputHandler getViewInputHandler() {
        return this.viewInputHandler;
    }

    public void setViewInputHandler(ViewInputHandler viewInputHandler) {
        this.viewInputHandler = viewInputHandler;
    }

    public boolean isDetectCollisions() {
        return this.detectCollisions;
    }

    public void setDetectCollisions(boolean bl) {
        this.detectCollisions = bl;
    }

    public boolean hadCollisions() {
        boolean bl = this.hadCollisions;
        this.hadCollisions = false;
        return bl;
    }

    @Override
    public void copyViewState(View view) {
        this.globe = view.getGlobe();
        Vec4 vec4 = view.getCenterPoint();
        if (vec4 == null) {
            Vec4 vec42 = view.getCurrentEyePoint();
            vec4 = vec42.add3(view.getForwardVector());
        }
        this.setOrientation(view.getCurrentEyePosition(), this.globe.computePositionFromPoint(vec4));
    }

    @Override
    public void apply(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("layers.AbstractLayer.NoGlobeSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.viewInputHandler != null) {
            this.viewInputHandler.apply();
        }
        this.doApply(drawContext);
        if (this.viewInputHandler != null) {
            this.viewInputHandler.viewApplied();
        }
    }

    protected void doApply(DrawContext drawContext) {
    }

    @Override
    public void stopMovement() {
        this.firePropertyChange("gov.nasa.worldwind.View.ViewStopped", null, this);
    }

    @Override
    public Rectangle getViewport() {
        return new Rectangle(this.viewport);
    }

    @Override
    public Frustum getFrustum() {
        return this.frustum;
    }

    @Override
    public Frustum getFrustumInModelCoordinates() {
        if (this.lastFrustumInModelCoords == null) {
            Matrix matrix = this.modelview.getTranspose();
            this.lastFrustumInModelCoords = matrix != null ? this.frustum.transformBy(matrix) : this.frustum;
        }
        return this.lastFrustumInModelCoords;
    }

    @Override
    public void setFieldOfView(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.fieldOfView = angle;
    }

    @Override
    public double getNearClipDistance() {
        return this.nearClipDistance;
    }

    protected void setNearClipDistance(double d) {
        this.nearClipDistance = d;
    }

    @Override
    public double getFarClipDistance() {
        return this.farClipDistance;
    }

    protected void setFarClipDistance(double d) {
        this.farClipDistance = d;
    }

    @Override
    public Matrix getModelviewMatrix() {
        return this.modelview;
    }

    @Override
    public long getViewStateID() {
        return this.viewStateID;
    }

    @Override
    public Angle getFieldOfView() {
        return this.fieldOfView;
    }

    @Override
    public Vec4 project(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.project(vec4, this.modelview, this.projection, this.viewport);
    }

    @Override
    public Vec4 unProject(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.unProject(vec4, this.modelview, this.projection, this.viewport);
    }

    @Override
    public Vec4 getEyePoint() {
        if (this.lastEyePoint == null) {
            this.lastEyePoint = Vec4.UNIT_W.transformBy4(this.modelviewInv);
        }
        return this.lastEyePoint;
    }

    @Override
    public Vec4 getCenterPoint() {
        Vec4 vec4 = this.getEyePoint();
        Intersection[] intersectionArray = this.globe.intersect(new Line(vec4, this.getForwardVector()), 0.0);
        if (intersectionArray == null) {
            return null;
        }
        return intersectionArray[0].getIntersectionPoint();
    }

    public Position getCenterPosition() {
        Vec4 vec4 = this.getEyePoint();
        Intersection[] intersectionArray = this.globe.intersect(new Line(vec4, this.getForwardVector()), 0.0);
        Position position = this.globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
        return position;
    }

    @Override
    public Vec4 getCurrentEyePoint() {
        Matrix matrix;
        Matrix matrix2;
        if (this.globe != null && (matrix2 = ViewUtil.computeTransformMatrix(this.globe, this.eyePosition, this.heading, this.pitch, this.roll)) != null && (matrix = matrix2.getInverse()) != null) {
            return Vec4.UNIT_W.transformBy4(matrix);
        }
        return Vec4.ZERO;
    }

    @Override
    public Position getCurrentEyePosition() {
        Matrix matrix;
        Matrix matrix2;
        if (this.globe != null && (matrix2 = ViewUtil.computeTransformMatrix(this.globe, this.eyePosition, this.heading, this.pitch, this.roll)) != null && (matrix = matrix2.getInverse()) != null) {
            Vec4 vec4 = Vec4.UNIT_W.transformBy4(matrix);
            return this.globe.computePositionFromPoint(vec4);
        }
        return Position.ZERO;
    }

    @Override
    public Position getEyePosition() {
        return this.lastEyePosition;
    }

    @Override
    public void setEyePosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.eyePosition = position;
        this.updateModelViewStateID();
    }

    @Override
    public Angle getHeading() {
        return this.heading;
    }

    @Override
    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = ViewUtil.normalizedHeading(angle);
        this.heading = angle;
        this.updateModelViewStateID();
    }

    @Override
    public Angle getPitch() {
        return this.pitch;
    }

    @Override
    public void setPitch(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pitch = angle;
        this.updateModelViewStateID();
    }

    @Override
    public void setRoll(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.roll = ViewUtil.normalizedRoll(angle);
        this.updateModelViewStateID();
    }

    @Override
    public Angle getRoll() {
        return this.roll;
    }

    @Override
    public Vec4 getUpVector() {
        if (this.lastUpVector == null) {
            this.lastUpVector = Vec4.UNIT_Y.transformBy4(this.modelviewInv);
        }
        return this.lastUpVector;
    }

    @Override
    public Vec4 getForwardVector() {
        if (this.lastForwardVector == null) {
            this.lastForwardVector = Vec4.UNIT_NEGATIVE_Z.transformBy4(this.modelviewInv);
        }
        return this.lastForwardVector;
    }

    public Vec4 getCurrentForwardVector() {
        Matrix matrix;
        Matrix matrix2;
        if (this.globe != null && (matrix2 = ViewUtil.computeTransformMatrix(this.globe, this.eyePosition, this.heading, this.pitch, this.roll)) != null && (matrix = matrix2.getInverse()) != null) {
            return Vec4.UNIT_NEGATIVE_Z.transformBy4(matrix);
        }
        return null;
    }

    protected void setViewState(ViewUtil.ViewState viewState) {
        if (viewState != null) {
            if (viewState.getPosition() != null) {
                this.eyePosition = ViewUtil.normalizedEyePosition(viewState.getPosition());
            }
            if (viewState.getHeading() != null) {
                this.heading = ViewUtil.normalizedHeading(viewState.getHeading());
            }
            if (viewState.getPitch() != null) {
                this.pitch = ViewUtil.normalizedPitch(viewState.getPitch());
            }
            if (viewState.getRoll() != null) {
                this.roll = ViewUtil.normalizedRoll(viewState.getRoll());
            }
        }
    }

    @Override
    public void setOrientation(Position position, Position position2) {
        Matrix matrix;
        Object object;
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Vec4 vec4 = this.globe.computePointFromPosition(position);
        Vec4 vec42 = this.globe.computePointFromPosition(position2);
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec43 = this.globe.computeSurfaceNormalAtPoint(vec42);
        Vec4 vec44 = vec42.subtract3(vec4).normalize3();
        if (vec44.cross3(vec43).getLength3() < 0.001 && (object = ViewUtil.computeTransformMatrix(this.globe, position, this.heading, Angle.ZERO, Angle.ZERO)) != null && (matrix = ((Matrix)object).getInverse()) != null) {
            vec43 = Vec4.UNIT_Y.transformBy4(matrix);
        }
        if (vec43 == null) {
            object = Logging.getMessage("View.ErrorSettingOrientation", position, position2);
            Logging.logger().severe((String)object);
            throw new IllegalArgumentException((String)object);
        }
        object = ViewUtil.computeViewState(this.globe, vec4, vec42, vec43);
        this.setViewState((ViewUtil.ViewState)object);
        this.updateModelViewStateID();
    }

    @Override
    public void stopAnimations() {
        this.viewInputHandler.stopAnimators();
    }

    @Override
    public boolean isAnimating() {
        return this.viewInputHandler.isAnimating();
    }

    @Override
    public void goTo(Position position, double d) {
        this.viewInputHandler.goTo(position, d);
    }

    @Override
    public Line computeRayFromScreenPoint(double d, double d2) {
        return ViewUtil.computeRayFromScreenPoint(this, d, d2, this.modelview, this.projection, this.viewport);
    }

    @Override
    public Position computePositionFromScreenPoint(double d, double d2) {
        Line line;
        if (this.globe != null && (line = this.computeRayFromScreenPoint(d, d2)) != null) {
            return this.globe.getIntersectionPosition(line);
        }
        return null;
    }

    @Override
    public double computePixelSizeAtDistance(double d) {
        return ViewUtil.computePixelSizeAtDistance(d, this.fieldOfView, this.viewport);
    }

    protected Position computeEyePositionFromModelview() {
        if (this.globe != null) {
            Vec4 vec4 = Vec4.UNIT_W.transformBy4(this.modelviewInv);
            return this.globe.computePositionFromPoint(vec4);
        }
        return Position.ZERO;
    }

    @Override
    public double getHorizonDistance() {
        return this.horizonDistance;
    }

    protected double computeHorizonDistance() {
        return this.computeHorizonDistance(this.computeEyePositionFromModelview());
    }

    protected double computeHorizonDistance(Position position) {
        if (this.globe != null && position != null) {
            double d = position.getElevation();
            double d2 = ViewUtil.computeElevationAboveSurface(this.dc, position);
            return ViewUtil.computeHorizonDistance(this.globe, Math.max(d, d2));
        }
        return 0.0;
    }

    @Override
    public ViewPropertyLimits getViewPropertyLimits() {
        return this.viewLimits;
    }

    protected double computeNearClipDistance() {
        return this.computeNearDistance(this.getCurrentEyePosition());
    }

    protected double computeFarClipDistance() {
        return this.computeFarDistance(this.getCurrentEyePosition());
    }

    protected double computeNearDistance(Position position) {
        int n = this.dc.getGLRuntimeCapabilities().getDepthBits();
        double d = ViewUtil.computePerspectiveNearDistance(this.farClipDistance, DEFAULT_DEPTH_RESOLUTION, n);
        if (position != null && this.dc != null) {
            double d2 = ViewUtil.computeElevationAboveSurface(this.dc, position);
            if (d2 > 0.0) {
                double d3 = ViewUtil.computePerspectiveNearDistance(this.fieldOfView, d2);
                if (d > d3) {
                    d = d3;
                }
            } else {
                d = 1.0;
            }
        }
        if (d < 1.0) {
            d = 1.0;
        }
        return d;
    }

    protected double computeFarDistance(Position position) {
        double d = 0.0;
        if (position != null) {
            d = this.computeHorizonDistance(position);
        }
        return d < 1000.0 ? 1000.0 : d;
    }

    @Override
    public Matrix getProjectionMatrix() {
        return this.projection;
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void updateModelViewStateID() {
        ++this.viewStateID;
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.getViewPropertyLimits().getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "viewPropertyLimits"));
        restorableSupport.addStateValueAsBoolean(stateObject, "detectCollisions", this.isDetectCollisions());
        if (this.getFieldOfView() != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "fieldOfView", this.getFieldOfView().getDegrees());
        }
        restorableSupport.addStateValueAsDouble(stateObject, "nearClipDistance", this.getNearClipDistance());
        restorableSupport.addStateValueAsDouble(stateObject, "farClipDistance", this.getFarClipDistance());
        if (this.getEyePosition() != null) {
            restorableSupport.addStateValueAsPosition(stateObject, "eyePosition", this.getEyePosition());
        }
        if (this.getHeading() != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "heading", this.getHeading().getDegrees());
        }
        if (this.getPitch() != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "pitch", this.getPitch().getDegrees());
        }
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Position position;
        Double d;
        Boolean bl;
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "viewPropertyLimits");
        if (stateObject2 != null) {
            this.getViewPropertyLimits().restoreState(restorableSupport, stateObject2);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "detectCollisions")) != null) {
            this.setDetectCollisions(bl);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "fieldOfView")) != null) {
            this.setFieldOfView(Angle.fromDegrees(d));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "nearClipDistance")) != null) {
            this.setNearClipDistance(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "farClipDistance")) != null) {
            this.setFarClipDistance(d);
        }
        if ((position = restorableSupport.getStateValueAsPosition(stateObject, "eyePosition")) != null) {
            this.setEyePosition(position);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "heading")) != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "pitch")) != null) {
            this.setPitch(Angle.fromDegrees(d));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Matrix pushReferenceCenter(DrawContext drawContext, Vec4 vec4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = this.getModelviewMatrix();
        Matrix matrix2 = null;
        if (matrix != null) {
            matrix2 = matrix.multiply(Matrix.fromTranslation(vec4));
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            oGLStackHandler.pushAttrib(gL2, 4096);
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            if (matrix2 != null) {
                double[] dArray = new double[16];
                matrix2.toArray(dArray, 0, false);
                gL2.glLoadMatrixd(dArray, 0);
            }
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
        return matrix2;
    }

    @Override
    public Matrix setReferenceCenter(DrawContext drawContext, Vec4 vec4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = this.getModelviewMatrix();
        Matrix matrix2 = null;
        if (matrix != null) {
            matrix2 = matrix.multiply(Matrix.fromTranslation(vec4));
        }
        if (matrix2 == null) {
            return null;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMatrixMode(5888);
        double[] dArray = new double[16];
        matrix2.toArray(dArray, 0, false);
        gL2.glLoadMatrixd(dArray, 0);
        return matrix2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popReferenceCenter(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            oGLStackHandler.pushAttrib(gL2, 4096);
            gL2.glMatrixMode(5888);
            gL2.glPopMatrix();
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    public Vec4 project(Vec4 vec4, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null || matrix2 == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        matrix.toArray(dArray, 0, false);
        matrix2.toArray(dArray2, 0, false);
        int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        double[] dArray3 = new double[3];
        if (!this.dc.getGLU().gluProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0)) {
            return null;
        }
        return Vec4.fromArray3(dArray3, 0);
    }

    public Vec4 unProject(Vec4 vec4, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null || matrix2 == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        matrix.toArray(dArray, 0, false);
        matrix2.toArray(dArray2, 0, false);
        int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        double[] dArray3 = new double[3];
        if (!this.dc.getGLU().gluUnProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0)) {
            return null;
        }
        return Vec4.fromArray3(dArray3, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadGLViewState(DrawContext drawContext, Matrix matrix, Matrix matrix2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (matrix == null) {
            Logging.logger().fine("nullValue.ModelViewIsNull");
        }
        if (matrix2 == null) {
            Logging.logger().fine("nullValue.ProjectionIsNull");
        }
        double[] dArray = new double[16];
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            oGLStackHandler.pushAttrib(gL2, 4096);
            gL2.glMatrixMode(5888);
            if (matrix != null) {
                matrix.toArray(dArray, 0, false);
                gL2.glLoadMatrixd(dArray, 0);
            } else {
                gL2.glLoadIdentity();
            }
            gL2.glMatrixMode(5889);
            if (matrix2 != null) {
                matrix2.toArray(dArray, 0, false);
                gL2.glLoadMatrixd(dArray, 0);
            } else {
                gL2.glLoadIdentity();
            }
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    @Override
    public void addAnimator(Animator animator) {
        this.viewInputHandler.addAnimator(animator);
    }
}

