/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.PropertyAccessor;
import gov.nasa.worldwind.view.ViewPropertyAccessor;
import gov.nasa.worldwind.view.orbit.OrbitView;

public class OrbitViewPropertyAccessor
extends ViewPropertyAccessor {
    private OrbitViewPropertyAccessor() {
    }

    public static PropertyAccessor.PositionAccessor createCenterPositionAccessor(OrbitView orbitView) {
        return new CenterPositionAccessor(orbitView);
    }

    public static PropertyAccessor.DoubleAccessor createZoomAccessor(OrbitView orbitView) {
        return new ZoomAccessor(orbitView);
    }

    private static class CenterPositionAccessor
    implements PropertyAccessor.PositionAccessor {
        private OrbitView orbitView;

        public CenterPositionAccessor(OrbitView orbitView) {
            this.orbitView = orbitView;
        }

        @Override
        public Position getPosition() {
            if (this.orbitView == null) {
                return null;
            }
            return this.orbitView.getCenterPosition();
        }

        @Override
        public boolean setPosition(Position position) {
            if (this.orbitView == null || position == null) {
                return false;
            }
            try {
                this.orbitView.setCenterPosition(position);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class ZoomAccessor
    implements PropertyAccessor.DoubleAccessor {
        OrbitView orbitView;

        public ZoomAccessor(OrbitView orbitView) {
            this.orbitView = orbitView;
        }

        @Override
        public final Double getDouble() {
            if (this.orbitView == null) {
                return null;
            }
            return this.orbitView.getZoom();
        }

        @Override
        public final boolean setDouble(Double d) {
            if (this.orbitView == null || d == null) {
                return false;
            }
            try {
                this.orbitView.setZoom(d);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

