/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class drmModeEncoder {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] drmModeEncoder_size = new int[]{20, 20, 20, 20, 20, 20, 20, 20, 20, 20};
    private static final int[] encoder_id_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] encoder_type_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] crtc_id_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] possible_crtcs_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] possible_clones_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};

    public static int size() {
        return drmModeEncoder_size[mdIdx];
    }

    public static drmModeEncoder create() {
        return drmModeEncoder.create(Buffers.newDirectByteBuffer(drmModeEncoder.size()));
    }

    public static drmModeEncoder create(ByteBuffer byteBuffer) {
        return new drmModeEncoder(byteBuffer);
    }

    drmModeEncoder(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[drmModeEncoder.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public drmModeEncoder setEncoder_id(int n) {
        this.accessor.setIntAt(encoder_id_offset[mdIdx], n);
        return this;
    }

    public int getEncoder_id() {
        return this.accessor.getIntAt(encoder_id_offset[mdIdx]);
    }

    public drmModeEncoder setEncoder_type(int n) {
        this.accessor.setIntAt(encoder_type_offset[mdIdx], n);
        return this;
    }

    public int getEncoder_type() {
        return this.accessor.getIntAt(encoder_type_offset[mdIdx]);
    }

    public drmModeEncoder setCrtc_id(int n) {
        this.accessor.setIntAt(crtc_id_offset[mdIdx], n);
        return this;
    }

    public int getCrtc_id() {
        return this.accessor.getIntAt(crtc_id_offset[mdIdx]);
    }

    public drmModeEncoder setPossible_crtcs(int n) {
        this.accessor.setIntAt(possible_crtcs_offset[mdIdx], n);
        return this;
    }

    public int getPossible_crtcs() {
        return this.accessor.getIntAt(possible_crtcs_offset[mdIdx]);
    }

    public drmModeEncoder setPossible_clones(int n) {
        this.accessor.setIntAt(possible_clones_offset[mdIdx], n);
        return this;
    }

    public int getPossible_clones() {
        return this.accessor.getIntAt(possible_clones_offset[mdIdx]);
    }
}

