/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class drmModeRes {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] drmModeRes_size = new int[]{48, 48, 48, 48, 48, 48, 48, 80, 80, 80};
    private static final int[] count_fbs_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] count_crtcs_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 16, 16, 16};
    private static final int[] count_connectors_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 32, 32, 32};
    private static final int[] count_encoders_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 48, 48, 48};
    private static final int[] min_width_offset = new int[]{32, 32, 32, 32, 32, 32, 32, 64, 64, 64};
    private static final int[] max_width_offset = new int[]{36, 36, 36, 36, 36, 36, 36, 68, 68, 68};
    private static final int[] min_height_offset = new int[]{40, 40, 40, 40, 40, 40, 40, 72, 72, 72};
    private static final int[] max_height_offset = new int[]{44, 44, 44, 44, 44, 44, 44, 76, 76, 76};

    public static int size() {
        return drmModeRes_size[mdIdx];
    }

    public static drmModeRes create() {
        return drmModeRes.create(Buffers.newDirectByteBuffer(drmModeRes.size()));
    }

    public static drmModeRes create(ByteBuffer byteBuffer) {
        return new drmModeRes(byteBuffer);
    }

    drmModeRes(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[drmModeRes.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public drmModeRes setCount_fbs(int n) {
        this.accessor.setIntAt(count_fbs_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getCount_fbs() {
        return this.accessor.getIntAt(count_fbs_offset[mdIdx], this.md.intSizeInBytes());
    }

    public drmModeRes setCount_crtcs(int n) {
        this.accessor.setIntAt(count_crtcs_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getCount_crtcs() {
        return this.accessor.getIntAt(count_crtcs_offset[mdIdx], this.md.intSizeInBytes());
    }

    private native ByteBuffer getCrtcs0(ByteBuffer var1, int var2);

    public IntBuffer getCrtcs() {
        int n = this.getCount_crtcs();
        ByteBuffer byteBuffer = this.getCrtcs0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer).asIntBuffer();
    }

    public drmModeRes setCount_connectors(int n) {
        this.accessor.setIntAt(count_connectors_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getCount_connectors() {
        return this.accessor.getIntAt(count_connectors_offset[mdIdx], this.md.intSizeInBytes());
    }

    private native ByteBuffer getConnectors0(ByteBuffer var1, int var2);

    public IntBuffer getConnectors() {
        int n = this.getCount_connectors();
        ByteBuffer byteBuffer = this.getConnectors0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer).asIntBuffer();
    }

    public drmModeRes setCount_encoders(int n) {
        this.accessor.setIntAt(count_encoders_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getCount_encoders() {
        return this.accessor.getIntAt(count_encoders_offset[mdIdx], this.md.intSizeInBytes());
    }

    private native ByteBuffer getEncoders0(ByteBuffer var1, int var2);

    public IntBuffer getEncoders() {
        int n = this.getCount_encoders();
        ByteBuffer byteBuffer = this.getEncoders0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer).asIntBuffer();
    }

    public drmModeRes setMin_width(int n) {
        this.accessor.setIntAt(min_width_offset[mdIdx], n);
        return this;
    }

    public int getMin_width() {
        return this.accessor.getIntAt(min_width_offset[mdIdx]);
    }

    public drmModeRes setMax_width(int n) {
        this.accessor.setIntAt(max_width_offset[mdIdx], n);
        return this;
    }

    public int getMax_width() {
        return this.accessor.getIntAt(max_width_offset[mdIdx]);
    }

    public drmModeRes setMin_height(int n) {
        this.accessor.setIntAt(min_height_offset[mdIdx], n);
        return this;
    }

    public int getMin_height() {
        return this.accessor.getIntAt(min_height_offset[mdIdx]);
    }

    public drmModeRes setMax_height(int n) {
        this.accessor.setIntAt(max_height_offset[mdIdx], n);
        return this;
    }

    public int getMax_height() {
        return this.accessor.getIntAt(max_height_offset[mdIdx]);
    }
}

