/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.WeakIdentityHashMap;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jogamp.opengl.GLContextImpl;

public class GLContextShareSet {
    private static final boolean DEBUG = GLContextImpl.DEBUG;
    private static final Map<GLContext, ShareSet> shareMap = new WeakIdentityHashMap<GLContext, ShareSet>();

    public static synchronized void registerSharing(GLContext gLContext, GLContext gLContext2) {
        if (gLContext == null || gLContext2 == null) {
            throw new IllegalArgumentException("Both slave and master must be non-null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (null == shareSet) {
            shareSet = GLContextShareSet.entryFor(gLContext2);
        }
        if (null == shareSet) {
            shareSet = new ShareSet();
        }
        shareSet.mapNewEntry(gLContext, gLContext2);
        shareSet.mapEntryIfNew(gLContext2, gLContext2);
        GLContextShareSet.mapEntryIfNew(gLContext, shareSet);
        GLContextShareSet.mapEntryIfNew(gLContext2, shareSet);
        if (DEBUG) {
            System.err.println("GLContextShareSet: registereSharing: 1: " + GLContextShareSet.toHexString(gLContext.hashCode()) + ", 2: " + GLContextShareSet.toHexString(gLContext2.hashCode()));
        }
    }

    public static synchronized void unregisterSharing(GLContext gLContext) {
        if (gLContext == null) {
            throw new IllegalArgumentException("Last context is null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet == null) {
            throw new GLException("Last context is unknown: " + gLContext);
        }
        Set<GLContext> set = shareSet.getCreatedShares();
        if (set.size() > 0) {
            throw new GLException("Last context's share set contains " + set.size() + " non destroyed context");
        }
        set = shareSet.getDestroyedShares();
        if (set.size() == 0) {
            throw new GLException("Last context's share set contains no destroyed context");
        }
        if (DEBUG) {
            System.err.println("GLContextShareSet: unregisterSharing: " + GLContextShareSet.toHexString(gLContext.hashCode()) + ", entries: " + set.size());
        }
        for (GLContext gLContext2 : set) {
            if (null != GLContextShareSet.removeEntry(gLContext2)) continue;
            throw new GLException("Removal of shareSet for context failed");
        }
    }

    public static synchronized boolean isShared(GLContext gLContext) {
        if (gLContext == null) {
            throw new IllegalArgumentException("context is null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        return shareSet != null;
    }

    public static synchronized GLContext getSharedMaster(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet == null) {
            return null;
        }
        return shareSet.getMaster(gLContext);
    }

    private static synchronized Set<GLContext> getCreatedSharesImpl(GLContext gLContext) {
        if (gLContext == null) {
            throw new IllegalArgumentException("context is null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            return shareSet.getCreatedShares();
        }
        return null;
    }

    private static synchronized Set<GLContext> getDestroyedSharesImpl(GLContext gLContext) {
        if (gLContext == null) {
            throw new IllegalArgumentException("context is null");
        }
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            return shareSet.getDestroyedShares();
        }
        return null;
    }

    public static synchronized boolean hasCreatedSharesLeft(GLContext gLContext) {
        Set<GLContext> set = GLContextShareSet.getCreatedSharesImpl(gLContext);
        return null != set && set.size() > 0;
    }

    public static synchronized int getCreatedShareCount(GLContext gLContext) {
        Set<GLContext> set = GLContextShareSet.getCreatedSharesImpl(gLContext);
        return null != set ? set.size() : 0;
    }

    public static synchronized int getDestroyedShareCount(GLContext gLContext) {
        Set<GLContext> set = GLContextShareSet.getDestroyedSharesImpl(gLContext);
        return null != set ? set.size() : 0;
    }

    public static synchronized ArrayList<GLContext> getCreatedShares(GLContext gLContext) {
        ArrayList<GLContext> arrayList = new ArrayList<GLContext>();
        Set<GLContext> set = GLContextShareSet.getCreatedSharesImpl(gLContext);
        if (null != set) {
            for (GLContext gLContext2 : set) {
                if (gLContext2 == gLContext) continue;
                arrayList.add(gLContext2);
            }
        }
        return arrayList;
    }

    public static synchronized ArrayList<GLContext> getDestroyedShares(GLContext gLContext) {
        ArrayList<GLContext> arrayList = new ArrayList<GLContext>();
        Set<GLContext> set = GLContextShareSet.getDestroyedSharesImpl(gLContext);
        if (null != set) {
            for (GLContext gLContext2 : set) {
                if (gLContext2 == gLContext) continue;
                arrayList.add(gLContext2);
            }
        }
        return arrayList;
    }

    public static synchronized boolean contextCreated(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            shareSet.contextCreated(gLContext);
            return true;
        }
        return false;
    }

    public static synchronized boolean contextDestroyed(GLContext gLContext) {
        ShareSet shareSet = GLContextShareSet.entryFor(gLContext);
        if (shareSet != null) {
            shareSet.contextDestroyed(gLContext);
            return true;
        }
        return false;
    }

    public static synchronized int getSize() {
        return shareMap.size();
    }

    public static void printMap(PrintStream printStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        IdentityHashMap<GLContext, GLContext> identityHashMap = new IdentityHashMap<GLContext, GLContext>();
        IdentityHashMap<GLContext, GLContext> identityHashMap2 = new IdentityHashMap<GLContext, GLContext>();
        Set<GLContext> set = shareMap.keySet();
        for (GLContext gLContext : set) {
            Iterator iterator;
            ShareSet shareSet = shareMap.get(gLContext);
            if (null != shareSet) {
                for (GLContext gLContext2 : shareSet.createdShares.keySet()) {
                    identityHashMap.putIfAbsent(gLContext2, gLContext2);
                }
                iterator = shareSet.destroyedShares.keySet().iterator();
                while (iterator.hasNext()) {
                    GLContext gLContext2;
                    gLContext2 = (GLContext)iterator.next();
                    identityHashMap2.putIfAbsent(gLContext2, gLContext2);
                }
            }
            boolean bl = (iterator = gLContext.getSharedMaster()) == gLContext;
            int n4 = null != iterator ? iterator.hashCode() : 0;
            printStream.println(n + ": hash 0x" + Integer.toHexString(gLContext.hashCode()) + ", \t(isShared " + GLContextShareSet.isShared(gLContext) + ", created " + gLContext.isCreated() + ", master 0x" + Integer.toHexString(n4) + ", isMaster " + bl + ", createdShares " + GLContextShareSet.getCreatedShareCount(gLContext) + ", destroyedShares " + GLContextShareSet.getDestroyedShareCount(gLContext) + ")");
            ++n;
        }
        for (GLContext gLContext : identityHashMap.keySet()) {
            printStream.println("  Created   Ctx #" + n2++ + ": hash 0x" + Integer.toHexString(gLContext.hashCode()) + ", \t(created " + gLContext.isCreated() + ")");
        }
        for (GLContext gLContext : identityHashMap2.keySet()) {
            printStream.println("  Destroyed Ctx #" + n3++ + ": hash 0x" + Integer.toHexString(gLContext.hashCode()) + ", \t(created " + gLContext.isCreated() + ")");
        }
        printStream.println("\t Total created " + n2 + " + destroyed " + n3 + " = " + (n2 + n3) + " - Total Mapped " + n + "/" + GLContextShareSet.getSize());
    }

    private static ShareSet entryFor(GLContext gLContext) {
        return shareMap.get(gLContext);
    }

    private static void mapEntryIfNew(GLContext gLContext, ShareSet shareSet) {
        if (null == shareMap.get(gLContext)) {
            shareMap.put(gLContext, shareSet);
        }
    }

    private static ShareSet removeEntry(GLContext gLContext) {
        return shareMap.remove(gLContext);
    }

    private static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private static class ShareSet {
        private final Map<GLContext, GLContext> createdShares = new IdentityHashMap<GLContext, GLContext>();
        private final Map<GLContext, GLContext> destroyedShares = new WeakIdentityHashMap<GLContext, GLContext>();

        private ShareSet() {
        }

        public final void mapNewEntry(GLContext gLContext, GLContext gLContext2) {
            GLContext gLContext3 = gLContext.isCreated() ? this.createdShares.put(gLContext, gLContext2) : this.destroyedShares.put(gLContext, gLContext2);
            if (null != gLContext3) {
                throw new InternalError("State of ShareSet corrupted: Slave " + GLContextShareSet.toHexString(gLContext.hashCode()) + " is not new w/ master " + GLContextShareSet.toHexString(gLContext3.hashCode()));
            }
        }

        public final void mapEntryIfNew(GLContext gLContext, GLContext gLContext2) {
            if (null == this.getMaster(gLContext2)) {
                this.mapNewEntry(gLContext, gLContext2);
            }
        }

        public final GLContext getMaster(GLContext gLContext) {
            GLContext gLContext2 = this.createdShares.get(gLContext);
            return null != gLContext2 ? gLContext2 : this.destroyedShares.get(gLContext);
        }

        public Set<GLContext> getCreatedShares() {
            return this.createdShares.keySet();
        }

        public Set<GLContext> getDestroyedShares() {
            return this.destroyedShares.keySet();
        }

        public void contextCreated(GLContext gLContext) {
            GLContext gLContext2 = this.destroyedShares.remove(gLContext);
            if (null == gLContext2) {
                throw new InternalError("State of ShareSet corrupted: Context " + GLContextShareSet.toHexString(gLContext.hashCode()) + " should have been in destroyed-set");
            }
            GLContext gLContext3 = this.createdShares.put(gLContext, gLContext2);
            if (null != gLContext3) {
                throw new InternalError("State of ShareSet corrupted: Context " + GLContextShareSet.toHexString(gLContext.hashCode()) + " shouldn't have been in created-set");
            }
        }

        public void contextDestroyed(GLContext gLContext) {
            GLContext gLContext2 = this.createdShares.remove(gLContext);
            if (null == gLContext2) {
                throw new InternalError("State of ShareSet corrupted: Context " + GLContextShareSet.toHexString(gLContext.hashCode()) + " should have been in created-set");
            }
            GLContext gLContext3 = this.destroyedShares.put(gLContext, gLContext2);
            if (null != gLContext3) {
                throw new InternalError("State of ShareSet corrupted: Context " + GLContextShareSet.toHexString(gLContext.hashCode()) + " shouldn't have been in destroyed-set");
            }
        }
    }
}

