/*
 * Decompiled with CFR 0.152.
 */
package osm.map.worldwind.gl.obj;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import osm.map.worldwind.gl.GLRenderable;
import osm.map.worldwind.gl.obj.ObjLoader;

public class ObjRenderable
extends GLRenderable {
    static Map<String, ObjLoader> modelCache = new HashMap<String, ObjLoader>();
    protected String modelSource;
    protected boolean centerit = false;
    protected boolean flipTextureVertically = false;
    private String id;

    public ObjRenderable(Position position, String string) {
        super(position);
        this.modelSource = string;
    }

    public ObjRenderable(Position position, String string, boolean bl, boolean bl2) {
        super(position);
        this.modelSource = string;
        this.centerit = bl;
        this.flipTextureVertically = bl2;
    }

    protected ObjLoader getModel(DrawContext drawContext) {
        String string = this.modelSource + "#" + drawContext.hashCode();
        if (modelCache.get(string) == null) {
            modelCache.put(string, new ObjLoader(this.modelSource, drawContext.getGL().getGL2(), this.centerit, this.flipTextureVertically));
        }
        ObjLoader objLoader = modelCache.get(string);
        this.eyeDistanceOffset = Math.max(Math.max(objLoader.getXWidth(), objLoader.getYHeight()), objLoader.getZDepth());
        return modelCache.get(string);
    }

    public static void reload() {
        modelCache.clear();
    }

    @Override
    protected void drawGL(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glRotated(90.0, 1.0, 0.0, 0.0);
        ObjLoader objLoader = this.getModel(drawContext);
        if (drawContext.isPickingMode()) {
            objLoader.getBoundingBox().drawUnitCube(drawContext);
        } else {
            this.getModel(drawContext).opengldraw(gL2);
            if (this.isHighlighted()) {
                objLoader.getBoundingBox().drawUnitCubeOutline(drawContext);
            }
        }
    }

    private double getPixelsPerMeter() {
        int n = Toolkit.getDefaultToolkit().getScreenResolution();
        return (double)n / 0.0254;
    }

    @Override
    protected double computeSize(DrawContext drawContext, Vec4 vec4) {
        if (this.keepConstantSize) {
            return this.size;
        }
        if (vec4 == null) {
            System.err.println("Null location when computing size");
            return 1.0;
        }
        double d = vec4.distanceTo3(drawContext.getView().getEyePoint());
        double d2 = drawContext.getView().computePixelSizeAtDistance(d);
        double d3 = this.getPixelsPerMeter();
        double d4 = this.eyeDistanceOffset;
        double d5 = d4 / d2;
        double d6 = this.size / d5;
        if (d6 < 0.5) {
            d6 = 0.5;
        }
        return d6;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }
}

