/*
 * Decompiled with CFR 0.152.
 */
package de.micromata.opengis.kml.v_2_2_0;

import de.micromata.opengis.kml.v_2_2_0.AbstractObject;
import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.BooleanConverter;
import de.micromata.opengis.kml.v_2_2_0.Coordinate;
import de.micromata.opengis.kml.v_2_2_0.CoordinatesConverter;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.annotations.Obvious;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LineStringType", propOrder={"extrude", "tessellate", "altitudeMode", "coordinates", "lineStringSimpleExtension", "lineStringObjectExtension"})
@XmlRootElement(name="LineString", namespace="http://www.opengis.net/kml/2.2")
public class LineString
extends Geometry
implements Cloneable {
    @XmlElement(defaultValue="0")
    @XmlJavaTypeAdapter(value=BooleanConverter.class)
    protected Boolean extrude;
    @XmlElement(defaultValue="0")
    @XmlJavaTypeAdapter(value=BooleanConverter.class)
    protected Boolean tessellate;
    @XmlElement(defaultValue="clampToGround")
    protected AltitudeMode altitudeMode;
    @XmlElement(namespace="http://www.opengis.net/kml/2.2", type=String.class)
    @XmlJavaTypeAdapter(value=CoordinatesConverter.class)
    protected List<Coordinate> coordinates;
    @XmlElement(name="LineStringSimpleExtensionGroup")
    @XmlSchemaType(name="anySimpleType")
    protected List<Object> lineStringSimpleExtension;
    @XmlElement(name="LineStringObjectExtensionGroup")
    protected List<AbstractObject> lineStringObjectExtension;

    public Boolean isExtrude() {
        return this.extrude;
    }

    public void setExtrude(Boolean value) {
        this.extrude = value;
    }

    public Boolean isTessellate() {
        return this.tessellate;
    }

    public void setTessellate(Boolean value) {
        this.tessellate = value;
    }

    public AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(AltitudeMode value) {
        this.altitudeMode = value;
    }

    public List<Object> getLineStringSimpleExtension() {
        if (this.lineStringSimpleExtension == null) {
            this.lineStringSimpleExtension = new ArrayList<Object>();
        }
        return this.lineStringSimpleExtension;
    }

    public List<AbstractObject> getLineStringObjectExtension() {
        if (this.lineStringObjectExtension == null) {
            this.lineStringObjectExtension = new ArrayList<AbstractObject>();
        }
        return this.lineStringObjectExtension;
    }

    public List<Coordinate> getCoordinates() {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList<Coordinate>();
        }
        return this.coordinates;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extrude == null ? 0 : this.extrude.hashCode());
        result = 31 * result + (this.tessellate == null ? 0 : this.tessellate.hashCode());
        result = 31 * result + (this.altitudeMode == null ? 0 : this.altitudeMode.hashCode());
        result = 31 * result + (this.coordinates == null ? 0 : this.coordinates.hashCode());
        result = 31 * result + (this.lineStringSimpleExtension == null ? 0 : this.lineStringSimpleExtension.hashCode());
        result = 31 * result + (this.lineStringObjectExtension == null ? 0 : this.lineStringObjectExtension.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LineString)) {
            return false;
        }
        LineString other = (LineString)obj;
        if (this.extrude == null ? other.extrude != null : !this.extrude.equals(other.extrude)) {
            return false;
        }
        if (this.tessellate == null ? other.tessellate != null : !this.tessellate.equals(other.tessellate)) {
            return false;
        }
        if (this.altitudeMode == null ? other.altitudeMode != null : !this.altitudeMode.equals((Object)other.altitudeMode)) {
            return false;
        }
        if (this.coordinates == null ? other.coordinates != null : !this.coordinates.equals(other.coordinates)) {
            return false;
        }
        if (this.lineStringSimpleExtension == null ? other.lineStringSimpleExtension != null : !this.lineStringSimpleExtension.equals(other.lineStringSimpleExtension)) {
            return false;
        }
        return !(this.lineStringObjectExtension == null ? other.lineStringObjectExtension != null : !this.lineStringObjectExtension.equals(other.lineStringObjectExtension));
    }

    public void setCoordinates(List<Coordinate> coordinates) {
        this.coordinates = coordinates;
    }

    public LineString addToCoordinates(double longitude, double latitude) {
        this.getCoordinates().add(new Coordinate(longitude, latitude));
        return this;
    }

    public LineString addToCoordinates(double longitude, double latitude, double altitude) {
        this.getCoordinates().add(new Coordinate(longitude, latitude, altitude));
        return this;
    }

    public LineString addToCoordinates(String coordinates) {
        this.getCoordinates().add(new Coordinate(coordinates));
        return this;
    }

    public void setLineStringSimpleExtension(List<Object> lineStringSimpleExtension) {
        this.lineStringSimpleExtension = lineStringSimpleExtension;
    }

    public LineString addToLineStringSimpleExtension(Object lineStringSimpleExtension) {
        this.getLineStringSimpleExtension().add(lineStringSimpleExtension);
        return this;
    }

    public void setLineStringObjectExtension(List<AbstractObject> lineStringObjectExtension) {
        this.lineStringObjectExtension = lineStringObjectExtension;
    }

    public LineString addToLineStringObjectExtension(AbstractObject lineStringObjectExtension) {
        this.getLineStringObjectExtension().add(lineStringObjectExtension);
        return this;
    }

    @Override
    @Obvious
    public void setObjectSimpleExtension(List<Object> objectSimpleExtension) {
        super.setObjectSimpleExtension(objectSimpleExtension);
    }

    @Override
    @Obvious
    public LineString addToObjectSimpleExtension(Object objectSimpleExtension) {
        super.getObjectSimpleExtension().add(objectSimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public void setGeometrySimpleExtension(List<Object> geometrySimpleExtension) {
        super.setGeometrySimpleExtension(geometrySimpleExtension);
    }

    @Override
    @Obvious
    public LineString addToGeometrySimpleExtension(Object geometrySimpleExtension) {
        super.getGeometrySimpleExtension().add(geometrySimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public void setGeometryObjectExtension(List<AbstractObject> geometryObjectExtension) {
        super.setGeometryObjectExtension(geometryObjectExtension);
    }

    @Override
    @Obvious
    public LineString addToGeometryObjectExtension(AbstractObject geometryObjectExtension) {
        super.getGeometryObjectExtension().add(geometryObjectExtension);
        return this;
    }

    public LineString withExtrude(Boolean extrude) {
        this.setExtrude(extrude);
        return this;
    }

    public LineString withTessellate(Boolean tessellate) {
        this.setTessellate(tessellate);
        return this;
    }

    public LineString withAltitudeMode(AltitudeMode altitudeMode) {
        this.setAltitudeMode(altitudeMode);
        return this;
    }

    public LineString withCoordinates(List<Coordinate> coordinates) {
        this.setCoordinates(coordinates);
        return this;
    }

    public LineString withLineStringSimpleExtension(List<Object> lineStringSimpleExtension) {
        this.setLineStringSimpleExtension(lineStringSimpleExtension);
        return this;
    }

    public LineString withLineStringObjectExtension(List<AbstractObject> lineStringObjectExtension) {
        this.setLineStringObjectExtension(lineStringObjectExtension);
        return this;
    }

    @Override
    @Obvious
    public LineString withObjectSimpleExtension(List<Object> objectSimpleExtension) {
        super.withObjectSimpleExtension((List)objectSimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public LineString withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    @Obvious
    public LineString withTargetId(String targetId) {
        super.withTargetId(targetId);
        return this;
    }

    @Override
    @Obvious
    public LineString withGeometrySimpleExtension(List<Object> geometrySimpleExtension) {
        super.withGeometrySimpleExtension(geometrySimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public LineString withGeometryObjectExtension(List<AbstractObject> geometryObjectExtension) {
        super.withGeometryObjectExtension(geometryObjectExtension);
        return this;
    }

    public List<Coordinate> createAndSetCoordinates() {
        ArrayList<Coordinate> newValue = new ArrayList<Coordinate>();
        this.setCoordinates(newValue);
        return newValue;
    }

    @Override
    public LineString clone() {
        LineString copy = (LineString)super.clone();
        copy.coordinates = new ArrayList<Coordinate>(this.getCoordinates().size());
        for (Coordinate coordinate : this.coordinates) {
            copy.coordinates.add(coordinate.clone());
        }
        copy.lineStringSimpleExtension = new ArrayList<Object>(this.getLineStringSimpleExtension().size());
        for (Object object : this.lineStringSimpleExtension) {
            copy.lineStringSimpleExtension.add(object);
        }
        copy.lineStringObjectExtension = new ArrayList<AbstractObject>(this.getLineStringObjectExtension().size());
        for (AbstractObject abstractObject : this.lineStringObjectExtension) {
            copy.lineStringObjectExtension.add(abstractObject.clone());
        }
        return copy;
    }
}

