/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.jxmapviewer2;

import java.util.HashSet;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.DefaultWaypoint;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.WaypointPainter;
import org.mapton.api.MBookmark;
import org.mapton.api.MBookmarkManager;
import org.mapton.jxmapviewer2.JxMapViewerMapEngine;

public class BookmarkPlotter {
    private final MBookmarkManager mBookmarkManager = MBookmarkManager.getInstance();
    private final JxMapViewerMapEngine mEngine;

    public BookmarkPlotter(JxMapViewerMapEngine engine) {
        this.mEngine = engine;
        this.mBookmarkManager.getItems().addListener(c -> this.updatePlacemarks());
        this.updatePlacemarks();
    }

    private void updatePlacemarks() {
        HashSet<DefaultWaypoint> waypoints = new HashSet<DefaultWaypoint>();
        for (MBookmark bookmark : this.mBookmarkManager.getItems()) {
            if (!bookmark.isDisplayMarker().booleanValue()) continue;
            GeoPosition geoPosition = new GeoPosition(bookmark.getLatitude().doubleValue(), bookmark.getLongitude().doubleValue());
            DefaultWaypoint defaultWaypoint = new DefaultWaypoint(geoPosition);
            waypoints.add(defaultWaypoint);
        }
        WaypointPainter waypointPainter = new WaypointPainter();
        waypointPainter.setWaypoints(waypoints);
        this.mEngine.getMap().setOverlayPainter((Painter)waypointPainter);
    }
}

