/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.jxmapviewer2;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javafx.embed.swing.SwingNode;
import javafx.scene.Node;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.mapton.api.MAttribution;
import org.mapton.api.MDocumentInfo;
import org.mapton.api.MEngine;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.Mapton;
import org.mapton.jxmapviewer2.BookmarkPlotter;
import org.mapton.jxmapviewer2.MapKit;
import se.trixon.almond.util.GraphicsHelper;
import se.trixon.almond.util.MathHelper;

public class JxMapViewerMapEngine
extends MEngine {
    public static final String LOG_TAG = "JxMapViewer2";
    private BookmarkPlotter mBookmarkPlotter;
    private JXMapViewer mMap;
    private MapKit mMapKit;
    private SwingNode mSwingNode;

    public void create(Runnable postCreateRunnable) {
        if (this.mMapKit == null) {
            this.init();
            this.initListeners();
            postCreateRunnable.run();
        } else {
            postCreateRunnable.run();
        }
    }

    public void fitToBounds(MLatLonBox latLonBox) {
        HashSet<GeoPosition> positions = new HashSet<GeoPosition>();
        positions.add(this.toGeoPosition(latLonBox.getNorthEast()));
        positions.add(this.toGeoPosition(latLonBox.getSouthWest()));
        this.mMap.zoomToBestFit(positions, 0.9);
        this.mMap.setCenterPosition(this.toGeoPosition(latLonBox.getCenter()));
        System.out.println(ToStringBuilder.reflectionToString((Object)latLonBox, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
        System.out.println(ToStringBuilder.reflectionToString((Object)latLonBox.getCenter(), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
    }

    public MLatLon getCenter() {
        return this.toLatLon(this.mMapKit.getCenterPosition());
    }

    public Node getLayerView() {
        return null;
    }

    public JXMapViewer getMap() {
        return this.mMap;
    }

    public JComponent getMapComponent() {
        this.updateToolbarDocumentInfo();
        return this.mMapKit;
    }

    public Node getMapNode() {
        if (this.mSwingNode == null) {
            this.mSwingNode = new SwingNode();
            this.getMapComponent();
            this.refreshUI();
        }
        return this.mSwingNode;
    }

    public String getName() {
        return "OpenStreetMap";
    }

    public Node getRulerView() {
        return null;
    }

    public Node getStyleView() {
        return null;
    }

    public double getZoom() {
        return this.toGlobalZoom();
    }

    public void onWhatsHere(String s) {
    }

    public void panTo(MLatLon latLong) {
        this.panTo(latLong, this.mMap.getZoom());
    }

    public void panTo(MLatLon latLon, double zoom) {
        this.panAndZoomTo(this.toGeoPosition(latLon), MathHelper.round((double)this.toLocalZoom(zoom)));
    }

    public void refreshUI() {
        SwingUtilities.invokeLater(() -> this.mSwingNode.setContent((JComponent)((Object)this.mMapKit)));
    }

    private void init() {
        this.mMapKit = new MapKit();
        this.mMap = this.mMapKit.getMainMap();
        this.setImageRenderer(() -> {
            BufferedImage image = GraphicsHelper.componentToImage((Component)this.mMap, null);
            return image;
        });
        this.mBookmarkPlotter = new BookmarkPlotter(this);
        Mapton.getLog().i(LOG_TAG, "Loaded and ready");
    }

    private void initListeners() {
        this.mMap.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JxMapViewerMapEngine.this.hideContextMenu();
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JxMapViewerMapEngine.this.displayContextMenu(e.getLocationOnScreen());
                }
            }
        });
        this.mMap.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GeoPosition geoPosition = JxMapViewerMapEngine.this.mMap.convertPointToGeoPosition((Point2D)e.getPoint());
                JxMapViewerMapEngine.this.setStatusMousePositionData(JxMapViewerMapEngine.this.toLatLon(geoPosition), null, null);
            }
        });
        this.mMapKit.getZoomSlider().addChangeListener(e -> Mapton.getInstance().zoomProperty().set(this.toGlobalZoom()));
    }

    private void panAndZoomTo(GeoPosition geoPosition, int zoom) {
        this.mMapKit.setCenterPosition(geoPosition);
        this.mMapKit.setZoom(zoom);
    }

    private GeoPosition toGeoPosition(MLatLon latLon) {
        return new GeoPosition(latLon.getLatitude(), latLon.getLongitude());
    }

    private double toGlobalZoom() {
        double steps = 17.0;
        int zoom = this.mMap.getZoom();
        return (17.0 - (double)zoom) / 17.0;
    }

    private MLatLon toLatLon(GeoPosition geoPosition) {
        return new MLatLon(geoPosition.getLatitude(), geoPosition.getLongitude());
    }

    private double toLocalZoom(double globalZoom) {
        double steps = 17.0;
        return 17.0 - 17.0 * globalZoom;
    }

    private void updateToolbarDocumentInfo() {
        LinkedHashMap<String, MAttribution> attributions = new LinkedHashMap<String, MAttribution>();
        MAttribution attribution = new MAttribution();
        attribution.setProviderName("OpenStreetMap");
        attribution.setProviderUrl("https://www.openstreetmap.org");
        attribution.setLicenseName("Open Data Commons Open Database License (ODbL)");
        attribution.setLicenseUrl("https://opendatacommons.org/licenses/odbl/");
        attribution.setRawHtml("\u00a9 OpenStreetMap contributors");
        attributions.put("OSM", attribution);
        MDocumentInfo documentInfo = new MDocumentInfo(this.getName(), attributions);
        Mapton.getGlobalState().put("map.document.info", (Object)documentInfo);
    }
}

