/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.TimeSection;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Iterator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class TimeSectionBuilder<B extends TimeSectionBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected TimeSectionBuilder() {
    }

    public static final TimeSectionBuilder create() {
        return new TimeSectionBuilder();
    }

    public final B start(LocalTime VALUE) {
        this.properties.put("start", (Property)new SimpleObjectProperty((Object)VALUE));
        return (B)this;
    }

    public final B stop(LocalTime VALUE) {
        this.properties.put("stop", (Property)new SimpleObjectProperty((Object)VALUE));
        return (B)this;
    }

    public final B text(String TEXT) {
        this.properties.put("text", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B icon(Image IMAGE) {
        this.properties.put("icon", (Property)new SimpleObjectProperty((Object)IMAGE));
        return (B)this;
    }

    public final B color(Color COLOR) {
        this.properties.put("color", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B highlightColor(Color COLOR) {
        this.properties.put("highlightColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B active(boolean ACTIVE) {
        this.properties.put("active", (Property)new SimpleBooleanProperty(ACTIVE));
        return (B)this;
    }

    public final B days(DayOfWeek ... DAYS) {
        this.properties.put("daysArray", (Property)new SimpleObjectProperty((Object)DAYS));
        return (B)this;
    }

    public final B onTimeSectionEntered(EventHandler<TimeSection.TimeSectionEvent> HANDLER) {
        this.properties.put("onTimeSectionEntered", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B onTimeSectionLeft(EventHandler<TimeSection.TimeSectionEvent> HANDLER) {
        this.properties.put("onTimeSectionLeft", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final TimeSection build() {
        TimeSection SECTION = new TimeSection();
        if (this.properties.containsKey("daysArray")) {
            SECTION.setDays((DayOfWeek[])((ObjectProperty)this.properties.get("daysArray")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "start": {
                    SECTION.setStart((LocalTime)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "stop": {
                    SECTION.setStop((LocalTime)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "text": {
                    SECTION.setText((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "icon": {
                    SECTION.setIcon((Image)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "color": {
                    SECTION.setColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "highlightColor": {
                    SECTION.setHighlightColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textColor": {
                    SECTION.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "active": {
                    SECTION.setActive(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "onTimeSectionEntered": {
                    SECTION.setOnTimeSectionEntered((EventHandler<TimeSection.TimeSectionEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "onTimeSectionLeft": {
                    SECTION.setOnTimeSectionLeft((EventHandler<TimeSection.TimeSectionEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                }
            }
        }
        return SECTION;
    }
}

