/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEvent;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.toolboxfx.FontMetrix;
import eu.hansolo.toolboxfx.geom.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class CycleStepTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private List<ChartItem> chartItems;
    private VBox chartBox;
    private ListChangeListener<ChartData> chartDataListener;
    private Tooltip selectionTooltip;
    private EventHandler<MouseEvent> mouseHandler;

    public CycleStepTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.chartDataListener = change -> {
            this.chartBox.getChildren().forEach(child -> ((ChartItem)child).dispose());
            this.chartBox.getChildren().clear();
            double sum = this.tile.getChartData().stream().mapToDouble(chartData -> chartData.getValue()).sum();
            this.tile.getChartData().forEach(chartData -> this.chartBox.getChildren().add((Object)new ChartItem((ChartData)chartData, sum)));
            this.updateChart();
        };
        this.mouseHandler = e -> {
            EventType TYPE = e.getEventType();
            if (MouseEvent.MOUSE_MOVED.equals(TYPE) || MouseEvent.MOUSE_EXITED.equals(TYPE)) {
                this.selectionTooltip.hide();
                this.selectionTooltip.setOpacity(0.0);
            }
        };
        this.chartItems = new ArrayList<ChartItem>();
        double sum = this.tile.getChartData().stream().mapToDouble(chartData -> chartData.getValue()).sum();
        this.tile.getChartData().forEach(chartData -> this.chartItems.add(new ChartItem((ChartData)chartData, sum)));
        this.chartBox = new VBox(0.0);
        this.chartBox.setFillWidth(true);
        this.chartBox.getChildren().addAll(this.chartItems);
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.selectionTooltip = new Tooltip("");
        this.selectionTooltip.setOpacity(0.0);
        this.selectionTooltip.setWidth(60.0);
        this.selectionTooltip.setHeight(48.0);
        Tooltip.install((Node)this.getPane(), (Tooltip)this.selectionTooltip);
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.chartBox});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().addListener(this.chartDataListener);
        this.tile.addEventHandler(MouseEvent.MOUSE_MOVED, this.mouseHandler);
        this.tile.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        } else if ("DATA".equals(EVENT_TYPE)) {
            this.updateChart();
        }
    }

    @Override
    public void dispose() {
        this.tile.getChartData().removeListener(this.chartDataListener);
        this.tile.removeEventHandler(MouseEvent.MOUSE_MOVED, this.mouseHandler);
        this.tile.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
        super.dispose();
    }

    private void updateChart() {
        Platform.runLater(() -> {
            double sum = this.tile.getChartData().stream().mapToDouble(chartData -> chartData.getValue()).sum();
            double lastFactor = 0.0;
            for (int i = 0; i < this.chartBox.getChildren().size(); ++i) {
                ChartItem item = (ChartItem)this.chartBox.getChildren().get(i);
                item.update(sum, lastFactor);
                lastFactor += item.getChartData().getValue() / sum;
            }
        });
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.chartBox.relocate(this.contentBounds.getMinX(), this.contentBounds.getMinY());
        this.chartBox.setPrefSize(this.contentBounds.getWidth(), this.contentBounds.getHeight());
        this.updateChart();
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.tile.getBarChartItems().forEach(item -> {
            item.setNameColor(this.tile.getTextColor());
            item.setValueColor(this.tile.getValueColor());
        });
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
    }

    public class ChartItem
    extends Region
    implements ChartDataEventListener {
        private static final double PREFERRED_WIDTH = 250.0;
        private static final double PREFERRED_HEIGHT = 250.0;
        private static final double MINIMUM_WIDTH = 10.0;
        private static final double MINIMUM_HEIGHT = 10.0;
        private static final double MAXIMUM_WIDTH = 1024.0;
        private static final double MAXIMUM_HEIGHT = 1024.0;
        private double size;
        private double width;
        private double height;
        private Canvas canvas;
        private GraphicsContext ctx;
        private ChartData chartData;
        private double sum;
        private double factorX;
        private Rectangle barRectangle;
        private EventHandler<MouseEvent> mouseHandler;

        public ChartItem(ChartData chartData, double sum) {
            this.chartData = chartData;
            this.sum = sum;
            this.factorX = 0.0;
            this.barRectangle = new Rectangle();
            this.mouseHandler = e -> {
                if (this.barRectangle.contains(e.getSceneX(), e.getSceneY())) {
                    String tooltipText = chartData.getName() + "\n" + String.format(CycleStepTileSkin.this.locale, CycleStepTileSkin.this.formatString, chartData.getValue());
                    Point2D popupLocation = new Point2D(e.getScreenX() - CycleStepTileSkin.this.selectionTooltip.getWidth() * 0.5, e.getScreenY() - this.size * 0.025 - CycleStepTileSkin.this.selectionTooltip.getHeight());
                    CycleStepTileSkin.this.selectionTooltip.setText(tooltipText);
                    CycleStepTileSkin.this.selectionTooltip.setX(popupLocation.getX());
                    CycleStepTileSkin.this.selectionTooltip.setY(popupLocation.getY());
                    CycleStepTileSkin.this.selectionTooltip.setOpacity(1.0);
                    CycleStepTileSkin.this.selectionTooltip.show(CycleStepTileSkin.this.tile.getScene().getWindow());
                }
            };
            this.initGraphics();
            this.registerListeners();
        }

        private void initGraphics() {
            if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
                if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                    this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
                } else {
                    this.setPrefSize(250.0, 250.0);
                }
            }
            this.canvas = new Canvas();
            this.ctx = this.canvas.getGraphicsContext2D();
            this.getChildren().setAll((Object[])new Node[]{this.canvas});
        }

        private void registerListeners() {
            this.widthProperty().addListener(o -> this.resize());
            this.heightProperty().addListener(o -> this.resize());
            this.chartData.addChartDataEventListener(this);
            this.addEventFilter(MouseEvent.MOUSE_CLICKED, this.mouseHandler);
        }

        protected double computeMinWidth(double HEIGHT) {
            return 10.0;
        }

        protected double computeMinHeight(double WIDTH) {
            return 10.0;
        }

        protected double computePrefWidth(double HEIGHT) {
            return super.computePrefWidth(HEIGHT);
        }

        protected double computePrefHeight(double WIDTH) {
            return super.computePrefHeight(WIDTH);
        }

        protected double computeMaxWidth(double HEIGHT) {
            return 1024.0;
        }

        protected double computeMaxHeight(double WIDTH) {
            return 1024.0;
        }

        public ChartData getChartData() {
            return this.chartData;
        }

        public Rectangle getBarRectangle() {
            return this.barRectangle;
        }

        public void update(double sum, double factorX) {
            this.sum = sum;
            this.factorX = factorX;
            this.redraw();
        }

        public void dispose() {
            this.chartData.removeChartDataEventListener(this);
            this.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.mouseHandler);
        }

        private void resize() {
            this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
            this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
            double d = this.size = this.width < this.height ? this.width : this.height;
            if (this.width > 0.0 && this.height > 0.0) {
                this.canvas.setWidth(this.width);
                this.canvas.setHeight(this.height);
                this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
                this.redraw();
            }
        }

        private void redraw() {
            String valueText;
            double value = this.chartData.getValue();
            String formatString = "%." + CycleStepTileSkin.this.tile.getDecimals() + "f";
            double maxTextWidth = this.width * 0.4;
            double barStartX = maxTextWidth + 5.0;
            double barStartY = this.height * 0.2;
            double maxBarWidth = this.width - barStartX;
            double barWidth = value / this.sum * maxBarWidth;
            double barHeight = this.height * 0.6;
            Color barBackgroundColor = Helper.getColorWithOpacity(CycleStepTileSkin.this.tile.getForegroundColor(), 0.1);
            Color barColor = this.chartData.getFillColor();
            boolean autoItemTextColor = CycleStepTileSkin.this.tile.getAutoItemTextColor();
            Color textFill = CycleStepTileSkin.this.tile.getForegroundColor();
            double valueFontSize = this.height * 0.3;
            Font valueFont = Fonts.latoRegular(valueFontSize);
            FontMetrix fontMetrix = new FontMetrix(valueFont);
            String string = valueText = CycleStepTileSkin.this.tile.getShortenNumbers() ? Helper.shortenNumber((long)value, CycleStepTileSkin.this.locale) : String.format(CycleStepTileSkin.this.tile.getLocale(), formatString, value);
            if (autoItemTextColor) {
                textFill = fontMetrix.computeStringWidth(valueText) > barWidth ? (Helper.isDark(CycleStepTileSkin.this.tile.getBackgroundColor()) ? CycleStepTileSkin.this.tile.getAutoItemBrightTextColor() : CycleStepTileSkin.this.tile.getAutoItemDarkTextColor()) : (Helper.isDark(barColor) ? CycleStepTileSkin.this.tile.getAutoItemBrightTextColor() : CycleStepTileSkin.this.tile.getAutoItemDarkTextColor());
            }
            double barLeftX = barStartX + this.factorX * maxBarWidth;
            double barRightX = barStartX + this.factorX * maxBarWidth + barWidth;
            double bar25Percent = barStartX + maxBarWidth * 0.25;
            double bar75Percent = barStartX + maxBarWidth * 0.75;
            double bar100Percent = barStartX + maxBarWidth;
            this.ctx.setTextBaseline(VPos.CENTER);
            this.ctx.setFont(Fonts.latoRegular(this.height * 0.4));
            this.ctx.setTextAlign(TextAlignment.LEFT);
            this.ctx.clearRect(0.0, 0.0, this.width, this.height);
            this.ctx.setFill((Paint)CycleStepTileSkin.this.tile.getForegroundColor());
            this.ctx.fillText(this.chartData.getName(), 0.0, this.height / 2.0, maxTextWidth);
            this.ctx.setFill((Paint)barBackgroundColor);
            this.ctx.fillRect(barStartX, barStartY, maxBarWidth, barHeight);
            this.ctx.setFill((Paint)barColor);
            this.ctx.fillRect(barLeftX, barStartY, barWidth, barHeight);
            this.ctx.setFill((Paint)textFill);
            this.ctx.setFont(valueFont);
            Point2D p = this.canvas.localToScene(barStartX, barStartY);
            this.barRectangle.set(p.getX(), p.getY(), maxBarWidth, barHeight);
            if (valueFontSize >= 6.0) {
                if (barLeftX < bar25Percent) {
                    this.ctx.setTextAlign(TextAlignment.LEFT);
                    maxTextWidth = bar100Percent - barLeftX;
                    this.ctx.fillText(valueText, barLeftX, this.height * 0.5, maxTextWidth);
                } else if (barRightX > bar75Percent) {
                    this.ctx.setTextAlign(TextAlignment.RIGHT);
                    maxTextWidth = barRightX - barStartX;
                    this.ctx.fillText(valueText, barRightX, this.height * 0.5, maxTextWidth);
                } else {
                    this.ctx.setTextAlign(TextAlignment.CENTER);
                    maxTextWidth = bar100Percent - barLeftX + barRightX - barStartX;
                    this.ctx.fillText(valueText, barLeftX + barWidth * 0.5, this.height * 0.5, maxTextWidth);
                }
            }
        }

        @Override
        public void onChartDataEvent(ChartDataEvent EVENT) {
            double sum = CycleStepTileSkin.this.tile.getChartData().stream().mapToDouble(chartData -> chartData.getValue()).sum();
            double lastFactor = 0.0;
            for (int i = 0; i < CycleStepTileSkin.this.chartBox.getChildren().size(); ++i) {
                ChartItem item = (ChartItem)CycleStepTileSkin.this.chartBox.getChildren().get(i);
                item.update(sum, lastFactor);
                lastFactor += item.getChartData().getValue() / sum;
            }
            this.redraw();
        }
    }
}

