/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class ImageCounterTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Label description;
    private ImageView imgView;
    private StackPane graphicContainer;
    private Circle roundFrame;
    private Rectangle rectangularFrame;
    private ChangeListener imageListener;

    public ImageCounterTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.imageListener = (o, ov, nv) -> {
            if (nv != null) {
                this.imgView.setImage(this.tile.getImage());
            }
        };
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.imgView = new ImageView(this.tile.getImage());
        this.roundFrame = new Circle();
        this.roundFrame.setFill((Paint)Color.TRANSPARENT);
        this.rectangularFrame = new Rectangle();
        this.rectangularFrame.setFill((Paint)Color.TRANSPARENT);
        this.graphicContainer = new StackPane();
        this.graphicContainer.setMinSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.graphicContainer.getChildren().setAll((Object[])new Node[]{this.roundFrame, this.rectangularFrame, this.imgView});
        this.valueText = new Text(String.format(this.locale, this.formatString, (this.tile.getValue() - this.minValue) / this.range * 100.0));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.valueText.setTextOrigin(VPos.BASELINE);
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(new Node[]{this.upperUnitText, this.unitText});
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        Helper.enableNode((Node)this.unitFlow, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new HBox(new Node[]{this.valueText, this.unitFlow});
        this.valueUnitFlow.setAlignment(Pos.BOTTOM_RIGHT);
        this.valueUnitFlow.setMouseTransparent(true);
        this.description = new Label(this.tile.getText());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setWrapText(true);
        this.description.setTextFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.description, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.graphicContainer, this.valueUnitFlow, this.fractionLine, this.description, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.imageProperty().addListener(this.imageListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            this.graphicContainer.setMaxSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
            this.graphicContainer.setPrefSize(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitFlow, !this.tile.getUnit().isEmpty());
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        if (this.tile.getShortenNumbers()) {
            this.valueText.setText(Helper.shortenNumber((long)VALUE));
        } else if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        this.resizeDynamicText();
    }

    @Override
    public void dispose() {
        this.tile.graphicProperty().removeListener(this.imageListener);
        super.dispose();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 - this.contentBounds.getWidth() * 0.45 : this.width - this.size * 0.1 - this.contentBounds.getWidth() * 0.45;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        maxWidth = this.width - this.size * 0.05 - this.contentBounds.getWidth() * 0.5;
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
        if (this.description.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.description, maxWidth, fontSize);
        }
    }

    @Override
    protected void resize() {
        double containerSize;
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double containerWidth = this.contentBounds.getWidth() * 0.45;
        double containerHeight = this.contentBounds.getHeight();
        double d = containerSize = containerWidth < containerHeight ? containerWidth : containerHeight;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            if (containerWidth > 0.0 && containerHeight > 0.0) {
                this.graphicContainer.setMinSize(containerWidth, containerHeight);
                this.graphicContainer.setMaxSize(containerWidth, containerHeight);
                this.graphicContainer.setPrefSize(containerWidth, containerHeight);
                this.graphicContainer.relocate(this.contentBounds.getX(), this.contentBounds.getY());
                if (null != this.tile) {
                    this.imgView.setPreserveRatio(true);
                    this.imgView.setFitWidth(containerWidth * 0.96);
                    this.imgView.setFitHeight(containerHeight * 0.96);
                    this.imgView.relocate((this.width - containerWidth) * 0.5, (this.height - containerHeight) * 0.5);
                    switch (this.tile.getImageMask()) {
                        case ROUND: {
                            this.imgView.setClip((Node)new Circle(this.imgView.getLayoutBounds().getWidth() * 0.5, this.imgView.getLayoutBounds().getHeight() * 0.5, containerSize * 0.48));
                            this.rectangularFrame.setManaged(false);
                            this.rectangularFrame.setVisible(false);
                            this.roundFrame.setManaged(true);
                            this.roundFrame.setVisible(true);
                            this.roundFrame.setRadius(containerSize * 0.5);
                            this.roundFrame.setStrokeWidth(this.size * 0.01);
                            this.roundFrame.setStroke((Paint)this.tile.getForegroundColor());
                            break;
                        }
                        case RECTANGULAR: {
                            Rectangle clip = new Rectangle(containerSize * 0.96, containerSize * 0.96);
                            clip.setArcWidth(this.size * 0.03);
                            clip.setArcHeight(this.size * 0.03);
                            this.imgView.setClip((Node)clip);
                            this.roundFrame.setManaged(false);
                            this.roundFrame.setVisible(false);
                            this.rectangularFrame.setManaged(true);
                            this.rectangularFrame.setVisible(true);
                            this.rectangularFrame.setWidth(containerSize);
                            this.rectangularFrame.setHeight(containerSize);
                            this.rectangularFrame.setStrokeWidth(this.size * 0.01);
                            this.rectangularFrame.setArcWidth(this.size * 0.05);
                            this.rectangularFrame.setArcHeight(this.size * 0.05);
                            this.rectangularFrame.setStroke((Paint)this.tile.getForegroundColor());
                            break;
                        }
                        default: {
                            this.imgView.setClip(null);
                            this.roundFrame.setManaged(false);
                            this.roundFrame.setVisible(false);
                            this.rectangularFrame.setManaged(false);
                            this.rectangularFrame.setVisible(false);
                        }
                    }
                    if (Tile.ImageMask.ROUND == this.tile.getImageMask()) {
                        this.imgView.setClip((Node)new Circle(this.imgView.getLayoutBounds().getWidth() * 0.5, this.imgView.getLayoutBounds().getHeight() * 0.5, containerSize * 0.48));
                        this.roundFrame.setManaged(true);
                        this.roundFrame.setVisible(true);
                        this.roundFrame.setRadius(containerSize * 0.5);
                        this.roundFrame.setStrokeWidth(this.size * 0.01);
                        this.roundFrame.setStroke((Paint)this.tile.getForegroundColor());
                    } else {
                        this.roundFrame.setManaged(false);
                        this.roundFrame.setVisible(false);
                    }
                }
            }
            this.resizeDynamicText();
            this.resizeStaticText();
            double textWidth = this.tile.getUnit().isEmpty() ? this.contentBounds.getWidth() * 0.55 : this.contentBounds.getWidth() * 0.5;
            this.valueUnitFlow.setPrefWidth(textWidth);
            this.valueUnitFlow.relocate(this.width - this.size * 0.05 - textWidth, this.contentBounds.getY());
            this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
            this.fractionLine.setStartX(this.width - 0.17 * this.size);
            this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
            this.fractionLine.setEndX(this.width - 0.05 * this.size);
            this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
            this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
            this.fractionLine.setStrokeWidth(this.size * 0.005);
            this.unitFlow.setTranslateY(-this.size * 0.005);
            textWidth = this.contentBounds.getWidth() * 0.5;
            this.description.setPrefSize(textWidth, this.size * 0.43);
            this.description.relocate(this.width - this.size * 0.05 - textWidth, this.titleText.isVisible() ? this.height * 0.42 : this.height * 0.32);
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(this.tile.getCurrentValue()));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        }
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode((Node)this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode((Node)this.fractionLine, false);
        }
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.description.setTextFill((Paint)this.tile.getDescriptionColor());
    }
}

