/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.lang.GeoLocation;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.mapton.addon.photos.api.MapoSource;
import se.trixon.almond.util.GraphicsHelper;
import se.trixon.almond.util.ImageScaler;
import se.trixon.almond.util.Scaler;

public class PhotoInfo {
    private String mChecksum;
    private ExifSubIFDDirectory mExifDirectory;
    private final File mFile;
    private final double mFormat = 1000000.0;
    private GeoLocation mGeoLocation;
    private GpsDirectory mGpsDirectory;
    private int mHeight;
    private final ImageScaler mImageScaler = ImageScaler.getInstance();
    private Metadata mMetadata;
    private int mOrientation;
    private Dimension mOriginalDimension = null;
    private int mWidth;

    public PhotoInfo(File file) throws ImageProcessingException, IOException {
        this.mFile = file;
        this.init();
    }

    public void createThumbnail(MapoSource source, File file) throws IOException {
        int thumbnailSize = source.getThumbnailSize();
        if (source.isThumbnailForceCreation() || !file.exists()) {
            BufferedImage scaledImage = this.mImageScaler.getScaledImage(this.mFile, new Dimension(thumbnailSize, thumbnailSize));
            scaledImage = GraphicsHelper.rotate((BufferedImage)scaledImage, (int)this.mOrientation);
            this.mHeight = scaledImage.getHeight();
            this.mWidth = scaledImage.getWidth();
            int borderSize = source.getThumbnailBorderSize();
            BufferedImage borderedImage = scaledImage;
            if (borderSize > 0) {
                int width = scaledImage.getWidth();
                int height = scaledImage.getHeight();
                int borderedImageWidth = width + borderSize * 2;
                int borderedImageHeight = height + borderSize * 2;
                borderedImage = new BufferedImage(borderedImageWidth, borderedImageHeight, 5);
                Graphics2D g2 = borderedImage.createGraphics();
                g2.setColor(Color.decode("#" + source.getThumbnailBorderColor()));
                g2.fillRect(0, 0, borderedImageWidth, borderedImageHeight);
                g2.drawImage(scaledImage, borderSize, borderSize, width + borderSize, height + borderSize, 0, 0, width, height, Color.YELLOW, null);
            }
            try {
                ImageIO.write((RenderedImage)borderedImage, "jpg", file);
            }
            catch (IOException ex) {
                throw new IOException("E000 %s".formatted(file.getAbsolutePath()));
            }
        } else {
            Scaler scaler = new Scaler(this.getOriginalDimension());
            scaler.setHeight(thumbnailSize);
            scaler.setWidth(thumbnailSize);
            this.mHeight = scaler.getDimension().height;
            this.mWidth = scaler.getDimension().width;
        }
    }

    public Double getAltitude() {
        if (this.mGpsDirectory != null) {
            return this.mGpsDirectory.getDoubleObject(6);
        }
        return null;
    }

    public Double getBearing() {
        if (this.mGpsDirectory != null) {
            return this.mGpsDirectory.getDoubleObject(274);
        }
        return null;
    }

    public String getChecksum() {
        return this.mChecksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate() {
        Date date;
        if (this.mExifDirectory.containsTag(36867)) {
            date = this.mExifDirectory.getDate(36867, TimeZone.getDefault());
        } else {
            long millis = 0L;
            try {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(this.mFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                millis = basicFileAttributes.lastModifiedTime().toMillis();
            }
            catch (IOException ex) {
                millis = this.mFile.lastModified();
            }
            finally {
                date = new Date(millis);
            }
        }
        return date;
    }

    public ExifSubIFDDirectory getExifDirectory() {
        return this.mExifDirectory;
    }

    public GpsDirectory getGpsDirectory() {
        return this.mGpsDirectory;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public double getLat() throws NullPointerException {
        int latInt = (int)(this.mGeoLocation.getLatitude() * 1000000.0);
        return (double)latInt / 1000000.0;
    }

    public double getLon() {
        int lonInt = (int)(this.mGeoLocation.getLongitude() * 1000000.0);
        return (double)lonInt / 1000000.0;
    }

    public Metadata getMetadata() {
        return this.mMetadata;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public boolean isZeroCoordinate() {
        return this.mGpsDirectory == null || this.mGpsDirectory.getGeoLocation() == null || this.mGpsDirectory.getGeoLocation().isZero();
    }

    private GeoLocation getGeoLocation() throws ImageProcessingException {
        return this.mGpsDirectory.getGeoLocation();
    }

    private Dimension getOriginalDimension() throws IOException {
        if (this.mOriginalDimension == null) {
            try {
                this.mOriginalDimension = GraphicsHelper.getImgageDimension((File)this.mFile);
                if (this.getOrientation() == 6 || this.getOrientation() == 8) {
                    int storedHeight = this.mOriginalDimension.height;
                    this.mOriginalDimension.height = this.mOriginalDimension.width;
                    this.mOriginalDimension.width = storedHeight;
                }
            }
            catch (IOException ex) {
                throw new IOException("E000 %s".formatted(this.mFile.getAbsolutePath()));
            }
            if (this.mOriginalDimension == null) {
                this.mOriginalDimension = new Dimension(200, 200);
            }
        }
        return this.mOriginalDimension;
    }

    private void init() throws ImageProcessingException, IOException, NullPointerException {
        this.mChecksum = "%08x".formatted(FileUtils.checksumCRC32((File)this.mFile));
        this.mMetadata = ImageMetadataReader.readMetadata((File)this.mFile);
        this.mExifDirectory = (ExifSubIFDDirectory)this.mMetadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
        this.mGpsDirectory = (GpsDirectory)this.mMetadata.getFirstDirectoryOfType(GpsDirectory.class);
        if (this.mGpsDirectory != null) {
            this.mGeoLocation = this.getGeoLocation();
            try {
                ExifIFD0Directory rotationDirectory = (ExifIFD0Directory)this.mMetadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
                this.mOrientation = rotationDirectory.getInt(274);
            }
            catch (MetadataException | NullPointerException ex) {
                this.mOrientation = 1;
            }
        }
    }
}

