/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.render.WWIcon;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.mapton.addon.photos.LineNode;
import org.mapton.addon.photos.api.MapoPhoto;
import org.mapton.addon.photos.api.MapoSettings;
import org.mapton.addon.photos.api.MapoSource;
import org.mapton.addon.photos.api.MapoSourceManager;
import org.mapton.addon.photos.ui.OptionsView;
import org.mapton.api.MTemporalManager;
import org.mapton.api.MTemporalRange;
import org.mapton.api.Mapton;
import org.mapton.worldwind.api.LayerBundle;
import se.trixon.almond.nbp.dialogs.NbMessage;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.GlobalState;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;

public class PhotosLayerBundle
extends LayerBundle {
    private final FastDateFormat mDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH.mm.ss");
    private final IconLayer mLayer = new IconLayer();
    private final ArrayList<LineNode> mLineNodes = new ArrayList();
    private final MapoSourceManager mManager = MapoSourceManager.getInstance();
    private OptionsView mOptionsView;
    private final RenderableLayer mRenderableLayer = new RenderableLayer();
    private MapoSettings mSettings;
    private final MTemporalManager mTemporalManager = MTemporalManager.getInstance();
    private ConcurrentHashMap<String, MTemporalRange> mTemporalRanges;

    public PhotosLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    public Node getOptionsView() {
        if (this.mOptionsView == null) {
            this.mOptionsView = new OptionsView();
        }
        return this.mOptionsView;
    }

    public void populate() throws Exception {
        this.getLayers().addAll((Object[])new Layer[]{this.mLayer, this.mRenderableLayer});
        this.repaint(5000L);
    }

    private String getCatKey(String category, String value) {
        return "%s#%s".formatted(category, value);
    }

    private String getPattern(MapoSettings.SplitBy splitBy) {
        return switch (splitBy) {
            case MapoSettings.SplitBy.NONE -> "'NO_SPLIT'";
            case MapoSettings.SplitBy.HOUR -> "yyyyMMddHH";
            case MapoSettings.SplitBy.DAY -> "yyyyMMdd";
            case MapoSettings.SplitBy.WEEK -> "yyyyww";
            case MapoSettings.SplitBy.MONTH -> "yyyyMM";
            case MapoSettings.SplitBy.YEAR -> "yyyy";
            default -> null;
        };
    }

    private void init() {
        this.mLayer.setName(Dict.PHOTOS.toString());
        this.setCategoryAddOns((Layer)this.mLayer);
        this.attachTopComponentToLayer("PhotosTopComponent", (Layer)this.mLayer);
        this.mLayer.setEnabled(true);
        this.mRenderableLayer.setPickEnabled(false);
        this.mRenderableLayer.setEnabled(true);
        this.setName(Dict.PHOTOS.toString());
        this.setParentLayer((Layer)this.mLayer);
        this.setAllChildLayers(new Layer[]{this.mRenderableLayer});
    }

    private void initListeners() {
        GlobalState globalState = Mapton.getGlobalState();
        globalState.addListener(gsce -> this.repaint(), new String[]{"mapo"});
        globalState.addListener(gsce -> {
            this.mSettings = (MapoSettings)gsce.getValue();
            this.repaint();
        }, new String[]{"photos.settings_updated"});
        this.mLayer.addPropertyChangeListener("Enabled", pce -> {
            if (this.mLayer.isEnabled()) {
                this.repaint();
                this.mTemporalManager.putAll(this.mTemporalRanges);
            } else {
                this.mTemporalRanges = this.mTemporalManager.getAndRemoveSubSet("org.mapton.addon.mapollage.");
            }
        });
    }

    private void initRepaint() {
        this.setPainter(() -> {
            if (!this.mLayer.isEnabled() || this.mSettings == null) {
                return;
            }
            this.removeAllIcons();
            this.removeAllRenderables();
            this.mLineNodes.clear();
            for (MapoSource source : this.mManager.getItems()) {
                if (!source.isVisible()) continue;
                for (MapoPhoto photo : source.getCollection().getPhotos()) {
                    boolean validDate;
                    try {
                        validDate = this.mTemporalManager.isValid(photo.getDate());
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    if (!validDate) continue;
                    String absolutePath = new File(source.getThumbnailDir(), "%s.jpg".formatted(photo.getChecksum())).getAbsolutePath();
                    UserFacingIcon userFacingIcon = new UserFacingIcon(absolutePath, Position.fromDegrees((double)photo.getLat(), (double)photo.getLon()));
                    int downSample = 10;
                    userFacingIcon.setSize(new Dimension(photo.getWidth() / downSample, photo.getHeight() / downSample));
                    userFacingIcon.setHighlightScale((double)downSample);
                    userFacingIcon.setValue("mapton.runnable.hoover", () -> {
                        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
                        propertyMap.put(this.getCatKey(Dict.PHOTO.toString(), Dict.NAME.toString()), FilenameUtils.getBaseName((String)photo.getPath()));
                        propertyMap.put(this.getCatKey(Dict.PHOTO.toString(), Dict.DATE.toString()), this.mDateFormat.format(photo.getDate()));
                        propertyMap.put(this.getCatKey(Dict.PHOTO.toString(), Dict.PATH.toString()), photo.getPath());
                        propertyMap.put(this.getCatKey(Dict.PHOTO.toString(), Dict.LATITUDE.toString()), photo.getLat());
                        propertyMap.put(this.getCatKey(Dict.PHOTO.toString(), Dict.LONGITUDE.toString()), photo.getLon());
                        propertyMap.put(this.getCatKey(Dict.PHOTO.toString(), Dict.ALTITUDE.toString()), photo.getAltitude());
                        propertyMap.put(this.getCatKey(Dict.PHOTO.toString(), Dict.BEARING.toString()), photo.getBearing());
                        propertyMap.put(this.getCatKey(Dict.SOURCE.toString(), Dict.SOURCE.toString()), source.getName());
                        propertyMap.put(this.getCatKey(Dict.SOURCE.toString(), Dict.DESCRIPTION.toString()), source.getDescriptionString());
                        propertyMap.put(this.getCatKey(Dict.SOURCE.toString(), Dict.CACHE.toString()), source.getThumbnailDir().getAbsolutePath());
                        Mapton.getGlobalState().put("object.properties", propertyMap);
                    });
                    userFacingIcon.setValue("mapton.runnable.left_double_click", () -> {
                        File file = new File(photo.getPath());
                        if (file.isFile()) {
                            SystemHelper.desktopOpen((File)new File(photo.getPath()));
                        } else {
                            NbMessage.error((String)Dict.Dialog.TITLE_FILE_NOT_FOUND.toString(), (String)Dict.Dialog.MESSAGE_FILE_NOT_FOUND.toString().formatted(photo.getPath()));
                        }
                    });
                    this.mLineNodes.add(new LineNode(photo.getDate(), photo.getLat(), photo.getLon()));
                    this.mLayer.addIcon((WWIcon)userFacingIcon);
                }
            }
            if (this.mLineNodes.size() > 1) {
                this.plotTracks();
            }
            this.setDragEnabled(false);
        });
    }

    private void plotTrack(BasicShapeAttributes attributes, ArrayList<Position> positions) {
        Path path = new Path(positions);
        path.setFollowTerrain(true);
        path.setAttributes((ShapeAttributes)attributes);
        path.setAltitudeMode(1);
        this.mRenderableLayer.addRenderable((Renderable)path);
    }

    private void plotTracks() {
        BasicShapeAttributes trackAttributes = new BasicShapeAttributes();
        trackAttributes.setDrawOutline(true);
        trackAttributes.setOutlineOpacity(0.8);
        trackAttributes.setOutlineWidth(this.mSettings.getWidth().doubleValue());
        trackAttributes.setOutlineMaterial(new Material(FxHelper.colorToColor((Color)FxHelper.colorFromHexRGBA((String)this.mSettings.getColorTrack()))));
        BasicShapeAttributes gapAttributes = (BasicShapeAttributes)trackAttributes.copy();
        gapAttributes.setOutlineMaterial(new Material(FxHelper.colorToColor((Color)FxHelper.colorFromHexRGBA((String)this.mSettings.getColorGap()))));
        Collections.sort(this.mLineNodes, Comparator.comparing(LineNode::getDate));
        FastDateFormat dateFormat = FastDateFormat.getInstance((String)this.getPattern(this.mSettings.getSplitBy()));
        TreeMap periodLineNodeMap = new TreeMap();
        this.mLineNodes.forEach(node -> periodLineNodeMap.computeIfAbsent(dateFormat.format(node.getDate()), k -> new ArrayList()).add(node));
        if (this.mSettings.isPlotTracks()) {
            for (ArrayList nodes : periodLineNodeMap.values()) {
                if (nodes.size() <= 1) continue;
                ArrayList<Position> positions = new ArrayList<Position>();
                nodes.forEach(node -> positions.add(Position.fromDegrees((double)node.getLat(), (double)node.getLon())));
                this.plotTrack(trackAttributes, positions);
            }
        }
        if (this.mSettings.isPlotGaps()) {
            ArrayList previousNodes = null;
            for (ArrayList nodes : periodLineNodeMap.values()) {
                if (previousNodes != null) {
                    LineNode prevLast = (LineNode)previousNodes.get(previousNodes.size() - 1);
                    LineNode currentFirst = (LineNode)nodes.get(0);
                    ArrayList<Position> positions = new ArrayList<Position>();
                    positions.add(Position.fromDegrees((double)prevLast.getLat(), (double)prevLast.getLon()));
                    positions.add(Position.fromDegrees((double)currentFirst.getLat(), (double)currentFirst.getLon()));
                    this.plotTrack(gapAttributes, positions);
                }
                previousNodes = nodes;
            }
        }
    }
}

