/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos.ui;

import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.ToolBar;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ObjectUtils;
import org.controlsfx.control.CheckListView;
import org.controlsfx.control.IndexedCheckModel;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.addon.photos.SourceScanner;
import org.mapton.addon.photos.api.Mapo;
import org.mapton.addon.photos.api.MapoCollection;
import org.mapton.addon.photos.api.MapoSource;
import org.mapton.addon.photos.api.MapoSourceManager;
import org.mapton.addon.photos.ui.SourceFileExportAction;
import org.mapton.addon.photos.ui.SourceFileImportAction;
import org.mapton.api.MTemporalManager;
import org.mapton.api.MTemporalRange;
import org.mapton.api.Mapton;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class SourcesPane
extends BorderPane {
    private List<Action> mActions;
    private final CheckListView<MapoSource> mListView = new CheckListView();
    private final MapoSourceManager mManager = MapoSourceManager.getInstance();
    private final Mapo mMapo = Mapo.getInstance();
    private Action mRefreshAction;
    private Button mRefreshButton;
    private Thread mRefreshThread;
    private RunState mRunState;
    private final MTemporalManager mTemporalManager = MTemporalManager.getInstance();

    public SourcesPane() {
        this.createUI();
        this.refreshCheckedStates();
        this.initListeners();
        Mapton.getGlobalState().put("photos.source_updated", (Object)this.mManager);
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                Thread.currentThread().interrupt();
            }
            Mapton.getGlobalState().put("photos.settings_updated", (Object)this.mMapo.getSettings());
        }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
    }

    private void createUI() {
        Action addAction = new Action(Dict.ADD.toString(), event -> this.mManager.edit(null));
        addAction.setGraphic((Node)MaterialIcon._Content.ADD.getImageView(Mapton.getIconSizeToolBarInt()));
        Action editAction = new Action(Dict.EDIT.toString(), event -> {
            if (this.getSelected() != null) {
                this.mManager.edit(this.getSelected());
            }
        });
        editAction.setGraphic((Node)MaterialIcon._Editor.MODE_EDIT.getImageView(Mapton.getIconSizeToolBarInt()));
        Action remAction = new Action(Dict.REMOVE.toString(), event -> {
            if (this.getSelected() != null) {
                this.remove();
            }
        });
        remAction.setGraphic((Node)MaterialIcon._Content.REMOVE.getImageView(Mapton.getIconSizeToolBarInt()));
        this.mRefreshAction = new Action(event -> {
            if (this.mRunState == RunState.STARTABLE) {
                this.setRunningState(RunState.CANCELABLE);
                this.mRefreshThread = new Thread(() -> {
                    new SourceScanner();
                    this.setRunningState(RunState.STARTABLE);
                }, ((Object)((Object)this)).getClass().getCanonicalName());
                this.mRefreshThread.start();
            } else {
                this.mRefreshThread.interrupt();
                this.setRunningState(RunState.STARTABLE);
            }
        });
        this.setRunningState(RunState.STARTABLE);
        this.mActions = Arrays.asList(new SourceFileImportAction().getAction(), new SourceFileExportAction().getAction(), addAction, remAction, editAction, ActionUtils.ACTION_SPAN, this.mRefreshAction);
        ToolBar toolBar = ActionUtils.createToolBar(this.mActions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)toolBar.getItems().stream(), (double)Mapton.getIconSizeToolBarInt());
        FxHelper.undecorateButtons((Stream)toolBar.getItems().stream());
        FxHelper.slimToolBar((ToolBar)toolBar);
        this.mRefreshButton = (Button)toolBar.getItems().get(toolBar.getItems().size() - 1);
        this.setTop((Node)toolBar);
        this.setCenter((Node)this.mListView);
        this.mListView.itemsProperty().bind(this.mManager.itemsProperty());
    }

    private MapoSource getSelected() {
        return (MapoSource)this.mListView.getSelectionModel().getSelectedItem();
    }

    private void initListeners() {
        this.mListView.setOnMouseClicked(mouseEvent -> {
            if (this.getSelected() != null && mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2) {
                this.mManager.edit(this.getSelected());
            }
        });
        this.mListView.getSelectionModel().getSelectedItems().addListener(c -> {
            if (this.getSelected() != null) {
                this.getSelected().fitToBounds();
            }
        });
        this.mManager.getItems().addListener(c -> Platform.runLater(() -> {
            this.refreshCheckedStates();
            try {
                this.mManager.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }));
        IndexedCheckModel checkModel = this.mListView.getCheckModel();
        checkModel.getCheckedItems().addListener(c -> Platform.runLater(() -> {
            this.mManager.getItems().forEach(source -> source.setVisible(checkModel.isChecked(source)));
            this.refreshTemporal();
            try {
                this.mManager.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.mTemporalManager.refresh();
            Mapton.getGlobalState().put("photos.source_updated", (Object)this.mManager);
            Mapton.getGlobalState().put("photos.settings_updated", (Object)this.mMapo.getSettings());
        }));
        Mapton.getGlobalState().addListener(evt -> this.refreshTemporal(), new String[]{"photos.source_updated"});
        this.mTemporalManager.lowDateProperty().addListener((ov, t, t1) -> {
            this.mMapo.getSettings().setLowDate((LocalDate)t1);
            Mapton.getGlobalState().put("photos.settings_updated", (Object)this.mMapo.getSettings());
        });
        this.mTemporalManager.highDateProperty().addListener((ov, t, t1) -> {
            this.mMapo.getSettings().setHighDate((LocalDate)t1);
            Mapton.getGlobalState().put("photos.settings_updated", (Object)this.mMapo.getSettings());
        });
    }

    private void refreshCheckedStates() {
        IndexedCheckModel checkModel = this.mListView.getCheckModel();
        for (MapoSource source : this.mManager.getItems()) {
            if (source.isVisible()) {
                checkModel.check((Object)source);
                continue;
            }
            checkModel.clearCheck((Object)source);
        }
    }

    private void refreshTemporal() {
        Platform.runLater(() -> {
            this.mTemporalManager.removeAll("org.mapton.addon.mapollage.");
            this.mManager.getItems().forEach(source -> {
                if (source.isVisible()) {
                    MapoCollection collection = source.getCollection();
                    if (ObjectUtils.allNotNull((Object[])new Object[]{collection.getDateMin(), collection.getDateMax()})) {
                        this.mTemporalManager.put("org.mapton.addon.mapollage." + source.getName(), new MTemporalRange(collection.getDateMin(), collection.getDateMax()));
                    }
                }
            });
            this.mTemporalManager.refresh();
        });
    }

    private void remove() {
        MapoSource source = this.getSelected();
        SwingUtilities.invokeLater(() -> {
            Object[] buttons = new String[]{Dict.CANCEL.toString(), Dict.REMOVE.toString()};
            NotifyDescriptor d = new NotifyDescriptor((Object)Dict.Dialog.MESSAGE_PROFILE_REMOVE.toString().formatted(source.getName()), Dict.Dialog.TITLE_REMOVE_S.toString().formatted(Dict.SOURCE.toString().toLowerCase()) + "?", 2, 2, buttons, (Object)Dict.REMOVE.toString());
            if (Dict.REMOVE.toString() == DialogDisplayer.getDefault().notify(d)) {
                Platform.runLater(() -> {
                    this.mManager.removeAll(source);
                    this.mTemporalManager.remove("org.mapton.addon.mapollage." + source.getName());
                });
            }
        });
    }

    private void setRunningState(RunState runState) {
        Platform.runLater(() -> {
            this.mRunState = runState;
            switch (runState) {
                case CANCELABLE: {
                    FxHelper.disableControls((ObservableList)this.getChildrenUnmodifiable(), (boolean)true, (Control[])new Control[]{this.mRefreshButton});
                    this.mRefreshAction.setText(Dict.CANCEL.toString());
                    this.mRefreshAction.setGraphic((Node)MaterialIcon._Navigation.CANCEL.getImageView(Mapton.getIconSizeToolBarInt()));
                    this.mActions.forEach(action -> action.setDisabled(true));
                    this.mRefreshAction.setDisabled(false);
                    break;
                }
                case STARTABLE: {
                    this.mRefreshAction.setText(Dict.REFRESH.toString());
                    this.mRefreshAction.setGraphic((Node)MaterialIcon._Navigation.REFRESH.getImageView(Mapton.getIconSizeToolBarInt()));
                    try {
                        this.mActions.forEach(action -> action.setDisabled(false));
                        FxHelper.disableControls((ObservableList)this.getChildrenUnmodifiable(), (boolean)false, (Control[])new Control[]{this.mRefreshButton});
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static enum RunState {
        STARTABLE,
        CANCELABLE;

    }
}

